/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApplicationRequest extends MigrationHubRefactorSpacesRequest implements
        ToCopyableBuilder<CreateApplicationRequest.Builder, CreateApplicationRequest> {
    private static final SdkField<ApiGatewayProxyInput> API_GATEWAY_PROXY_FIELD = SdkField
            .<ApiGatewayProxyInput> builder(MarshallingType.SDK_POJO).memberName("ApiGatewayProxy")
            .getter(getter(CreateApplicationRequest::apiGatewayProxy)).setter(setter(Builder::apiGatewayProxy))
            .constructor(ApiGatewayProxyInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiGatewayProxy").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateApplicationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnvironmentIdentifier").getter(getter(CreateApplicationRequest::environmentIdentifier))
            .setter(setter(Builder::environmentIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("EnvironmentIdentifier").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateApplicationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PROXY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProxyType").getter(getter(CreateApplicationRequest::proxyTypeAsString))
            .setter(setter(Builder::proxyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProxyType").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateApplicationRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(CreateApplicationRequest::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_GATEWAY_PROXY_FIELD,
            CLIENT_TOKEN_FIELD, ENVIRONMENT_IDENTIFIER_FIELD, NAME_FIELD, PROXY_TYPE_FIELD, TAGS_FIELD, VPC_ID_FIELD));

    private final ApiGatewayProxyInput apiGatewayProxy;

    private final String clientToken;

    private final String environmentIdentifier;

    private final String name;

    private final String proxyType;

    private final Map<String, String> tags;

    private final String vpcId;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.apiGatewayProxy = builder.apiGatewayProxy;
        this.clientToken = builder.clientToken;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.name = builder.name;
        this.proxyType = builder.proxyType;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * A wrapper object holding the API Gateway endpoint type and stage name for the proxy.
     * </p>
     * 
     * @return A wrapper object holding the API Gateway endpoint type and stage name for the proxy.
     */
    public final ApiGatewayProxyInput apiGatewayProxy() {
        return apiGatewayProxy;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The unique identifier of the environment.
     * </p>
     * 
     * @return The unique identifier of the environment.
     */
    public final String environmentIdentifier() {
        return environmentIdentifier;
    }

    /**
     * <p>
     * The name to use for the application.
     * </p>
     * 
     * @return The name to use for the application.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The proxy type of the proxy created within the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #proxyType} will
     * return {@link ProxyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #proxyTypeAsString}.
     * </p>
     * 
     * @return The proxy type of the proxy created within the application.
     * @see ProxyType
     */
    public final ProxyType proxyType() {
        return ProxyType.fromValue(proxyType);
    }

    /**
     * <p>
     * The proxy type of the proxy created within the application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #proxyType} will
     * return {@link ProxyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #proxyTypeAsString}.
     * </p>
     * 
     * @return The proxy type of the proxy created within the application.
     * @see ProxyType
     */
    public final String proxyTypeAsString() {
        return proxyType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to assign to the application. A tag is a label that you assign to an Amazon Web Services resource. Each
     * tag consists of a key-value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to assign to the application. A tag is a label that you assign to an Amazon Web Services
     *         resource. Each tag consists of a key-value pair.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the virtual private cloud (VPC).
     * </p>
     * 
     * @return The ID of the virtual private cloud (VPC).
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiGatewayProxy());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(proxyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest) obj;
        return Objects.equals(apiGatewayProxy(), other.apiGatewayProxy()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(environmentIdentifier(), other.environmentIdentifier()) && Objects.equals(name(), other.name())
                && Objects.equals(proxyTypeAsString(), other.proxyTypeAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateApplicationRequest").add("ApiGatewayProxy", apiGatewayProxy())
                .add("ClientToken", clientToken()).add("EnvironmentIdentifier", environmentIdentifier()).add("Name", name())
                .add("ProxyType", proxyTypeAsString()).add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiGatewayProxy":
            return Optional.ofNullable(clazz.cast(apiGatewayProxy()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "EnvironmentIdentifier":
            return Optional.ofNullable(clazz.cast(environmentIdentifier()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ProxyType":
            return Optional.ofNullable(clazz.cast(proxyTypeAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubRefactorSpacesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateApplicationRequest> {
        /**
         * <p>
         * A wrapper object holding the API Gateway endpoint type and stage name for the proxy.
         * </p>
         * 
         * @param apiGatewayProxy
         *        A wrapper object holding the API Gateway endpoint type and stage name for the proxy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiGatewayProxy(ApiGatewayProxyInput apiGatewayProxy);

        /**
         * <p>
         * A wrapper object holding the API Gateway endpoint type and stage name for the proxy.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApiGatewayProxyInput.Builder} avoiding
         * the need to create one manually via {@link ApiGatewayProxyInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApiGatewayProxyInput.Builder#build()} is called immediately and
         * its result is passed to {@link #apiGatewayProxy(ApiGatewayProxyInput)}.
         * 
         * @param apiGatewayProxy
         *        a consumer that will call methods on {@link ApiGatewayProxyInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiGatewayProxy(ApiGatewayProxyInput)
         */
        default Builder apiGatewayProxy(Consumer<ApiGatewayProxyInput.Builder> apiGatewayProxy) {
            return apiGatewayProxy(ApiGatewayProxyInput.builder().applyMutation(apiGatewayProxy).build());
        }

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The unique identifier of the environment.
         * </p>
         * 
         * @param environmentIdentifier
         *        The unique identifier of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentIdentifier(String environmentIdentifier);

        /**
         * <p>
         * The name to use for the application.
         * </p>
         * 
         * @param name
         *        The name to use for the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The proxy type of the proxy created within the application.
         * </p>
         * 
         * @param proxyType
         *        The proxy type of the proxy created within the application.
         * @see ProxyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProxyType
         */
        Builder proxyType(String proxyType);

        /**
         * <p>
         * The proxy type of the proxy created within the application.
         * </p>
         * 
         * @param proxyType
         *        The proxy type of the proxy created within the application.
         * @see ProxyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProxyType
         */
        Builder proxyType(ProxyType proxyType);

        /**
         * <p>
         * The tags to assign to the application. A tag is a label that you assign to an Amazon Web Services resource.
         * Each tag consists of a key-value pair.
         * </p>
         * 
         * @param tags
         *        The tags to assign to the application. A tag is a label that you assign to an Amazon Web Services
         *        resource. Each tag consists of a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The ID of the virtual private cloud (VPC).
         * </p>
         * 
         * @param vpcId
         *        The ID of the virtual private cloud (VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubRefactorSpacesRequest.BuilderImpl implements Builder {
        private ApiGatewayProxyInput apiGatewayProxy;

        private String clientToken;

        private String environmentIdentifier;

        private String name;

        private String proxyType;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            apiGatewayProxy(model.apiGatewayProxy);
            clientToken(model.clientToken);
            environmentIdentifier(model.environmentIdentifier);
            name(model.name);
            proxyType(model.proxyType);
            tags(model.tags);
            vpcId(model.vpcId);
        }

        public final ApiGatewayProxyInput.Builder getApiGatewayProxy() {
            return apiGatewayProxy != null ? apiGatewayProxy.toBuilder() : null;
        }

        public final void setApiGatewayProxy(ApiGatewayProxyInput.BuilderImpl apiGatewayProxy) {
            this.apiGatewayProxy = apiGatewayProxy != null ? apiGatewayProxy.build() : null;
        }

        @Override
        public final Builder apiGatewayProxy(ApiGatewayProxyInput apiGatewayProxy) {
            this.apiGatewayProxy = apiGatewayProxy;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProxyType() {
            return proxyType;
        }

        public final void setProxyType(String proxyType) {
            this.proxyType = proxyType;
        }

        @Override
        public final Builder proxyType(String proxyType) {
            this.proxyType = proxyType;
            return this;
        }

        @Override
        public final Builder proxyType(ProxyType proxyType) {
            this.proxyType(proxyType == null ? null : proxyType.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
