/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubrefactorspaces.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhubrefactorspaces.MigrationHubRefactorSpacesAsyncClient;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListRoutesRequest;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.ListRoutesResponse;
import software.amazon.awssdk.services.migrationhubrefactorspaces.model.RouteSummary;

public class ListRoutesPublisher
implements SdkPublisher<ListRoutesResponse> {
    private final MigrationHubRefactorSpacesAsyncClient client;
    private final ListRoutesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRoutesPublisher(MigrationHubRefactorSpacesAsyncClient client, ListRoutesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRoutesPublisher(MigrationHubRefactorSpacesAsyncClient client, ListRoutesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRoutesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRoutesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RouteSummary> routeSummaryList() {
        Function<ListRoutesResponse, Iterator> getIterator = response -> {
            if (response != null && response.routeSummaryList() != null) {
                return response.routeSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRoutesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRoutesResponseFetcher
    implements AsyncPageFetcher<ListRoutesResponse> {
        private ListRoutesResponseFetcher() {
        }

        public boolean hasNextPage(ListRoutesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRoutesResponse> nextPage(ListRoutesResponse previousPage) {
            if (previousPage == null) {
                return ListRoutesPublisher.this.client.listRoutes(ListRoutesPublisher.this.firstRequest);
            }
            return ListRoutesPublisher.this.client.listRoutes((ListRoutesRequest)((Object)ListRoutesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

