/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceAttributeType {
    IPV4_ADDRESS("IPV4_ADDRESS"),
    IPV6_ADDRESS("IPV6_ADDRESS"),
    MAC_ADDRESS("MAC_ADDRESS"),
    FQDN("FQDN"),
    VM_MANAGER_ID("VM_MANAGER_ID"),
    VM_MANAGED_OBJECT_REFERENCE("VM_MANAGED_OBJECT_REFERENCE"),
    VM_NAME("VM_NAME"),
    VM_PATH("VM_PATH"),
    BIOS_ID("BIOS_ID"),
    MOTHERBOARD_SERIAL_NUMBER("MOTHERBOARD_SERIAL_NUMBER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceAttributeType> VALUE_MAP;
    private final String value;

    private ResourceAttributeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceAttributeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceAttributeType> knownValues() {
        EnumSet<ResourceAttributeType> knownValues = EnumSet.allOf(ResourceAttributeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceAttributeType.class, ResourceAttributeType::toString);
    }
}

