/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Export task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportTask implements SdkPojo, Serializable, ToCopyableBuilder<ExportTask.Builder, ExportTask> {
    private static final SdkField<String> CREATION_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("creationDateTime").getter(getter(ExportTask::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<String> END_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endDateTime").getter(getter(ExportTask::endDateTime)).setter(setter(Builder::endDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDateTime").build()).build();

    private static final SdkField<String> EXPORT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exportID").getter(getter(ExportTask::exportID)).setter(setter(Builder::exportID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportID").build()).build();

    private static final SdkField<Float> PROGRESS_PERCENTAGE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("progressPercentage").getter(getter(ExportTask::progressPercentage))
            .setter(setter(Builder::progressPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressPercentage").build())
            .build();

    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3Bucket").getter(getter(ExportTask::s3Bucket)).setter(setter(Builder::s3Bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()).build();

    private static final SdkField<String> S3_BUCKET_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3BucketOwner").getter(getter(ExportTask::s3BucketOwner)).setter(setter(Builder::s3BucketOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3BucketOwner").build()).build();

    private static final SdkField<String> S3_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3Key")
            .getter(getter(ExportTask::s3Key)).setter(setter(Builder::s3Key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Key").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ExportTask::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<ExportTaskSummary> SUMMARY_FIELD = SdkField
            .<ExportTaskSummary> builder(MarshallingType.SDK_POJO).memberName("summary").getter(getter(ExportTask::summary))
            .setter(setter(Builder::summary)).constructor(ExportTaskSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_DATE_TIME_FIELD,
            END_DATE_TIME_FIELD, EXPORT_ID_FIELD, PROGRESS_PERCENTAGE_FIELD, S3_BUCKET_FIELD, S3_BUCKET_OWNER_FIELD,
            S3_KEY_FIELD, STATUS_FIELD, SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String creationDateTime;

    private final String endDateTime;

    private final String exportID;

    private final Float progressPercentage;

    private final String s3Bucket;

    private final String s3BucketOwner;

    private final String s3Key;

    private final String status;

    private final ExportTaskSummary summary;

    private ExportTask(BuilderImpl builder) {
        this.creationDateTime = builder.creationDateTime;
        this.endDateTime = builder.endDateTime;
        this.exportID = builder.exportID;
        this.progressPercentage = builder.progressPercentage;
        this.s3Bucket = builder.s3Bucket;
        this.s3BucketOwner = builder.s3BucketOwner;
        this.s3Key = builder.s3Key;
        this.status = builder.status;
        this.summary = builder.summary;
    }

    /**
     * <p>
     * Export task creation datetime.
     * </p>
     * 
     * @return Export task creation datetime.
     */
    public final String creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * Export task end datetime.
     * </p>
     * 
     * @return Export task end datetime.
     */
    public final String endDateTime() {
        return endDateTime;
    }

    /**
     * <p>
     * Export task id.
     * </p>
     * 
     * @return Export task id.
     */
    public final String exportID() {
        return exportID;
    }

    /**
     * <p>
     * Export task progress percentage.
     * </p>
     * 
     * @return Export task progress percentage.
     */
    public final Float progressPercentage() {
        return progressPercentage;
    }

    /**
     * <p>
     * Export task s3 bucket.
     * </p>
     * 
     * @return Export task s3 bucket.
     */
    public final String s3Bucket() {
        return s3Bucket;
    }

    /**
     * <p>
     * Export task s3 bucket owner.
     * </p>
     * 
     * @return Export task s3 bucket owner.
     */
    public final String s3BucketOwner() {
        return s3BucketOwner;
    }

    /**
     * <p>
     * Export task s3 key.
     * </p>
     * 
     * @return Export task s3 key.
     */
    public final String s3Key() {
        return s3Key;
    }

    /**
     * <p>
     * Export task status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Export task status.
     * @see ExportStatus
     */
    public final ExportStatus status() {
        return ExportStatus.fromValue(status);
    }

    /**
     * <p>
     * Export task status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Export task status.
     * @see ExportStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Export task summary.
     * </p>
     * 
     * @return Export task summary.
     */
    public final ExportTaskSummary summary() {
        return summary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(exportID());
        hashCode = 31 * hashCode + Objects.hashCode(progressPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketOwner());
        hashCode = 31 * hashCode + Objects.hashCode(s3Key());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTask)) {
            return false;
        }
        ExportTask other = (ExportTask) obj;
        return Objects.equals(creationDateTime(), other.creationDateTime()) && Objects.equals(endDateTime(), other.endDateTime())
                && Objects.equals(exportID(), other.exportID())
                && Objects.equals(progressPercentage(), other.progressPercentage())
                && Objects.equals(s3Bucket(), other.s3Bucket()) && Objects.equals(s3BucketOwner(), other.s3BucketOwner())
                && Objects.equals(s3Key(), other.s3Key()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(summary(), other.summary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportTask").add("CreationDateTime", creationDateTime()).add("EndDateTime", endDateTime())
                .add("ExportID", exportID()).add("ProgressPercentage", progressPercentage()).add("S3Bucket", s3Bucket())
                .add("S3BucketOwner", s3BucketOwner()).add("S3Key", s3Key()).add("Status", statusAsString())
                .add("Summary", summary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "endDateTime":
            return Optional.ofNullable(clazz.cast(endDateTime()));
        case "exportID":
            return Optional.ofNullable(clazz.cast(exportID()));
        case "progressPercentage":
            return Optional.ofNullable(clazz.cast(progressPercentage()));
        case "s3Bucket":
            return Optional.ofNullable(clazz.cast(s3Bucket()));
        case "s3BucketOwner":
            return Optional.ofNullable(clazz.cast(s3BucketOwner()));
        case "s3Key":
            return Optional.ofNullable(clazz.cast(s3Key()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "summary":
            return Optional.ofNullable(clazz.cast(summary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExportTask, T> g) {
        return obj -> g.apply((ExportTask) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportTask> {
        /**
         * <p>
         * Export task creation datetime.
         * </p>
         * 
         * @param creationDateTime
         *        Export task creation datetime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(String creationDateTime);

        /**
         * <p>
         * Export task end datetime.
         * </p>
         * 
         * @param endDateTime
         *        Export task end datetime.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDateTime(String endDateTime);

        /**
         * <p>
         * Export task id.
         * </p>
         * 
         * @param exportID
         *        Export task id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportID(String exportID);

        /**
         * <p>
         * Export task progress percentage.
         * </p>
         * 
         * @param progressPercentage
         *        Export task progress percentage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressPercentage(Float progressPercentage);

        /**
         * <p>
         * Export task s3 bucket.
         * </p>
         * 
         * @param s3Bucket
         *        Export task s3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Bucket(String s3Bucket);

        /**
         * <p>
         * Export task s3 bucket owner.
         * </p>
         * 
         * @param s3BucketOwner
         *        Export task s3 bucket owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketOwner(String s3BucketOwner);

        /**
         * <p>
         * Export task s3 key.
         * </p>
         * 
         * @param s3Key
         *        Export task s3 key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Key(String s3Key);

        /**
         * <p>
         * Export task status.
         * </p>
         * 
         * @param status
         *        Export task status.
         * @see ExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Export task status.
         * </p>
         * 
         * @param status
         *        Export task status.
         * @see ExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportStatus
         */
        Builder status(ExportStatus status);

        /**
         * <p>
         * Export task summary.
         * </p>
         * 
         * @param summary
         *        Export task summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(ExportTaskSummary summary);

        /**
         * <p>
         * Export task summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportTaskSummary.Builder} avoiding the
         * need to create one manually via {@link ExportTaskSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportTaskSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #summary(ExportTaskSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link ExportTaskSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(ExportTaskSummary)
         */
        default Builder summary(Consumer<ExportTaskSummary.Builder> summary) {
            return summary(ExportTaskSummary.builder().applyMutation(summary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String creationDateTime;

        private String endDateTime;

        private String exportID;

        private Float progressPercentage;

        private String s3Bucket;

        private String s3BucketOwner;

        private String s3Key;

        private String status;

        private ExportTaskSummary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTask model) {
            creationDateTime(model.creationDateTime);
            endDateTime(model.endDateTime);
            exportID(model.exportID);
            progressPercentage(model.progressPercentage);
            s3Bucket(model.s3Bucket);
            s3BucketOwner(model.s3BucketOwner);
            s3Key(model.s3Key);
            status(model.status);
            summary(model.summary);
        }

        public final String getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(String creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getEndDateTime() {
            return endDateTime;
        }

        public final void setEndDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public final Builder endDateTime(String endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final String getExportID() {
            return exportID;
        }

        public final void setExportID(String exportID) {
            this.exportID = exportID;
        }

        @Override
        public final Builder exportID(String exportID) {
            this.exportID = exportID;
            return this;
        }

        public final Float getProgressPercentage() {
            return progressPercentage;
        }

        public final void setProgressPercentage(Float progressPercentage) {
            this.progressPercentage = progressPercentage;
        }

        @Override
        public final Builder progressPercentage(Float progressPercentage) {
            this.progressPercentage = progressPercentage;
            return this;
        }

        public final String getS3Bucket() {
            return s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3BucketOwner() {
            return s3BucketOwner;
        }

        public final void setS3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
        }

        @Override
        public final Builder s3BucketOwner(String s3BucketOwner) {
            this.s3BucketOwner = s3BucketOwner;
            return this;
        }

        public final String getS3Key() {
            return s3Key;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExportStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ExportTaskSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        public final void setSummary(ExportTaskSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(ExportTaskSummary summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public ExportTask build() {
            return new ExportTask(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
