/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LaunchStatus {
    PENDING("PENDING"),
    IN_PROGRESS("IN_PROGRESS"),
    LAUNCHED("LAUNCHED"),
    FAILED("FAILED"),
    TERMINATED("TERMINATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LaunchStatus> VALUE_MAP;
    private final String value;

    private LaunchStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LaunchStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LaunchStatus> knownValues() {
        EnumSet<LaunchStatus> knownValues = EnumSet.allOf(LaunchStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LaunchStatus.class, LaunchStatus::toString);
    }
}

