/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the updates being applied to the ACL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ACLPendingChanges implements SdkPojo, Serializable,
        ToCopyableBuilder<ACLPendingChanges.Builder, ACLPendingChanges> {
    private static final SdkField<List<String>> USER_NAMES_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserNamesToRemove")
            .getter(getter(ACLPendingChanges::userNamesToRemove))
            .setter(setter(Builder::userNamesToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserNamesToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> USER_NAMES_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UserNamesToAdd")
            .getter(getter(ACLPendingChanges::userNamesToAdd))
            .setter(setter(Builder::userNamesToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserNamesToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAMES_TO_REMOVE_FIELD,
            USER_NAMES_TO_ADD_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> userNamesToRemove;

    private final List<String> userNamesToAdd;

    private ACLPendingChanges(BuilderImpl builder) {
        this.userNamesToRemove = builder.userNamesToRemove;
        this.userNamesToAdd = builder.userNamesToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserNamesToRemove property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserNamesToRemove() {
        return userNamesToRemove != null && !(userNamesToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of user names being removed from the ACL
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserNamesToRemove} method.
     * </p>
     * 
     * @return A list of user names being removed from the ACL
     */
    public final List<String> userNamesToRemove() {
        return userNamesToRemove;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserNamesToAdd property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserNamesToAdd() {
        return userNamesToAdd != null && !(userNamesToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of users being added to the ACL
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserNamesToAdd} method.
     * </p>
     * 
     * @return A list of users being added to the ACL
     */
    public final List<String> userNamesToAdd() {
        return userNamesToAdd;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasUserNamesToRemove() ? userNamesToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserNamesToAdd() ? userNamesToAdd() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ACLPendingChanges)) {
            return false;
        }
        ACLPendingChanges other = (ACLPendingChanges) obj;
        return hasUserNamesToRemove() == other.hasUserNamesToRemove()
                && Objects.equals(userNamesToRemove(), other.userNamesToRemove())
                && hasUserNamesToAdd() == other.hasUserNamesToAdd() && Objects.equals(userNamesToAdd(), other.userNamesToAdd());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ACLPendingChanges")
                .add("UserNamesToRemove", hasUserNamesToRemove() ? userNamesToRemove() : null)
                .add("UserNamesToAdd", hasUserNamesToAdd() ? userNamesToAdd() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserNamesToRemove":
            return Optional.ofNullable(clazz.cast(userNamesToRemove()));
        case "UserNamesToAdd":
            return Optional.ofNullable(clazz.cast(userNamesToAdd()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ACLPendingChanges, T> g) {
        return obj -> g.apply((ACLPendingChanges) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ACLPendingChanges> {
        /**
         * <p>
         * A list of user names being removed from the ACL
         * </p>
         * 
         * @param userNamesToRemove
         *        A list of user names being removed from the ACL
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userNamesToRemove(Collection<String> userNamesToRemove);

        /**
         * <p>
         * A list of user names being removed from the ACL
         * </p>
         * 
         * @param userNamesToRemove
         *        A list of user names being removed from the ACL
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userNamesToRemove(String... userNamesToRemove);

        /**
         * <p>
         * A list of users being added to the ACL
         * </p>
         * 
         * @param userNamesToAdd
         *        A list of users being added to the ACL
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userNamesToAdd(Collection<String> userNamesToAdd);

        /**
         * <p>
         * A list of users being added to the ACL
         * </p>
         * 
         * @param userNamesToAdd
         *        A list of users being added to the ACL
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userNamesToAdd(String... userNamesToAdd);
    }

    static final class BuilderImpl implements Builder {
        private List<String> userNamesToRemove = DefaultSdkAutoConstructList.getInstance();

        private List<String> userNamesToAdd = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ACLPendingChanges model) {
            userNamesToRemove(model.userNamesToRemove);
            userNamesToAdd(model.userNamesToAdd);
        }

        public final Collection<String> getUserNamesToRemove() {
            if (userNamesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return userNamesToRemove;
        }

        public final void setUserNamesToRemove(Collection<String> userNamesToRemove) {
            this.userNamesToRemove = UserNameListCopier.copy(userNamesToRemove);
        }

        @Override
        public final Builder userNamesToRemove(Collection<String> userNamesToRemove) {
            this.userNamesToRemove = UserNameListCopier.copy(userNamesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userNamesToRemove(String... userNamesToRemove) {
            userNamesToRemove(Arrays.asList(userNamesToRemove));
            return this;
        }

        public final Collection<String> getUserNamesToAdd() {
            if (userNamesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return userNamesToAdd;
        }

        public final void setUserNamesToAdd(Collection<String> userNamesToAdd) {
            this.userNamesToAdd = UserNameListCopier.copy(userNamesToAdd);
        }

        @Override
        public final Builder userNamesToAdd(Collection<String> userNamesToAdd) {
            this.userNamesToAdd = UserNameListCopier.copy(userNamesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userNamesToAdd(String... userNamesToAdd) {
            userNamesToAdd(Arrays.asList(userNamesToAdd));
            return this;
        }

        @Override
        public ACLPendingChanges build() {
            return new ACLPendingChanges(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
