/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the subnet associated with a cluster. This parameter refers to subnets defined in Amazon Virtual Private
 * Cloud (Amazon VPC) and used with MemoryDB.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Subnet implements SdkPojo, Serializable, ToCopyableBuilder<Subnet.Builder, Subnet> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(Subnet::identifier)).setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<AvailabilityZone> AVAILABILITY_ZONE_FIELD = SdkField
            .<AvailabilityZone> builder(MarshallingType.SDK_POJO).memberName("AvailabilityZone")
            .getter(getter(Subnet::availabilityZone)).setter(setter(Builder::availabilityZone))
            .constructor(AvailabilityZone::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD,
            AVAILABILITY_ZONE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String identifier;

    private final AvailabilityZone availabilityZone;

    private Subnet(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.availabilityZone = builder.availabilityZone;
    }

    /**
     * <p>
     * The unique identifier for the subnet.
     * </p>
     * 
     * @return The unique identifier for the subnet.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * <p>
     * The Availability Zone where the subnet resides
     * </p>
     * 
     * @return The Availability Zone where the subnet resides
     */
    public final AvailabilityZone availabilityZone() {
        return availabilityZone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet) obj;
        return Objects.equals(identifier(), other.identifier()) && Objects.equals(availabilityZone(), other.availabilityZone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Subnet").add("Identifier", identifier()).add("AvailabilityZone", availabilityZone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Subnet, T> g) {
        return obj -> g.apply((Subnet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Subnet> {
        /**
         * <p>
         * The unique identifier for the subnet.
         * </p>
         * 
         * @param identifier
         *        The unique identifier for the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * The Availability Zone where the subnet resides
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone where the subnet resides
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(AvailabilityZone availabilityZone);

        /**
         * <p>
         * The Availability Zone where the subnet resides
         * </p>
         * This is a convenience method that creates an instance of the {@link AvailabilityZone.Builder} avoiding the
         * need to create one manually via {@link AvailabilityZone#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AvailabilityZone.Builder#build()} is called immediately and its
         * result is passed to {@link #availabilityZone(AvailabilityZone)}.
         * 
         * @param availabilityZone
         *        a consumer that will call methods on {@link AvailabilityZone.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availabilityZone(AvailabilityZone)
         */
        default Builder availabilityZone(Consumer<AvailabilityZone.Builder> availabilityZone) {
            return availabilityZone(AvailabilityZone.builder().applyMutation(availabilityZone).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String identifier;

        private AvailabilityZone availabilityZone;

        private BuilderImpl() {
        }

        private BuilderImpl(Subnet model) {
            identifier(model.identifier);
            availabilityZone(model.availabilityZone);
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final AvailabilityZone.Builder getAvailabilityZone() {
            return availabilityZone != null ? availabilityZone.toBuilder() : null;
        }

        public final void setAvailabilityZone(AvailabilityZone.BuilderImpl availabilityZone) {
            this.availabilityZone = availabilityZone != null ? availabilityZone.build() : null;
        }

        @Override
        public final Builder availabilityZone(AvailabilityZone availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        @Override
        public Subnet build() {
            return new Subnet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
