/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.UserNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ACLPendingChanges
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ACLPendingChanges> {
    private static final SdkField<List<String>> USER_NAMES_TO_REMOVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserNamesToRemove").getter(ACLPendingChanges.getter(ACLPendingChanges::userNamesToRemove)).setter(ACLPendingChanges.setter(Builder::userNamesToRemove)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserNamesToRemove").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> USER_NAMES_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserNamesToAdd").getter(ACLPendingChanges.getter(ACLPendingChanges::userNamesToAdd)).setter(ACLPendingChanges.setter(Builder::userNamesToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserNamesToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAMES_TO_REMOVE_FIELD, USER_NAMES_TO_ADD_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> userNamesToRemove;
    private final List<String> userNamesToAdd;

    private ACLPendingChanges(BuilderImpl builder) {
        this.userNamesToRemove = builder.userNamesToRemove;
        this.userNamesToAdd = builder.userNamesToAdd;
    }

    public final boolean hasUserNamesToRemove() {
        return this.userNamesToRemove != null && !(this.userNamesToRemove instanceof SdkAutoConstructList);
    }

    public final List<String> userNamesToRemove() {
        return this.userNamesToRemove;
    }

    public final boolean hasUserNamesToAdd() {
        return this.userNamesToAdd != null && !(this.userNamesToAdd instanceof SdkAutoConstructList);
    }

    public final List<String> userNamesToAdd() {
        return this.userNamesToAdd;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserNamesToRemove() ? this.userNamesToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserNamesToAdd() ? this.userNamesToAdd() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ACLPendingChanges)) {
            return false;
        }
        ACLPendingChanges other = (ACLPendingChanges)obj;
        return this.hasUserNamesToRemove() == other.hasUserNamesToRemove() && Objects.equals(this.userNamesToRemove(), other.userNamesToRemove()) && this.hasUserNamesToAdd() == other.hasUserNamesToAdd() && Objects.equals(this.userNamesToAdd(), other.userNamesToAdd());
    }

    public final String toString() {
        return ToString.builder((String)"ACLPendingChanges").add("UserNamesToRemove", this.hasUserNamesToRemove() ? this.userNamesToRemove() : null).add("UserNamesToAdd", this.hasUserNamesToAdd() ? this.userNamesToAdd() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserNamesToRemove": {
                return Optional.ofNullable(clazz.cast(this.userNamesToRemove()));
            }
            case "UserNamesToAdd": {
                return Optional.ofNullable(clazz.cast(this.userNamesToAdd()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ACLPendingChanges, T> g) {
        return obj -> g.apply((ACLPendingChanges)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> userNamesToRemove = DefaultSdkAutoConstructList.getInstance();
        private List<String> userNamesToAdd = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ACLPendingChanges model) {
            this.userNamesToRemove(model.userNamesToRemove);
            this.userNamesToAdd(model.userNamesToAdd);
        }

        public final Collection<String> getUserNamesToRemove() {
            if (this.userNamesToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userNamesToRemove;
        }

        public final void setUserNamesToRemove(Collection<String> userNamesToRemove) {
            this.userNamesToRemove = UserNameListCopier.copy(userNamesToRemove);
        }

        @Override
        public final Builder userNamesToRemove(Collection<String> userNamesToRemove) {
            this.userNamesToRemove = UserNameListCopier.copy(userNamesToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userNamesToRemove(String ... userNamesToRemove) {
            this.userNamesToRemove(Arrays.asList(userNamesToRemove));
            return this;
        }

        public final Collection<String> getUserNamesToAdd() {
            if (this.userNamesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userNamesToAdd;
        }

        public final void setUserNamesToAdd(Collection<String> userNamesToAdd) {
            this.userNamesToAdd = UserNameListCopier.copy(userNamesToAdd);
        }

        @Override
        public final Builder userNamesToAdd(Collection<String> userNamesToAdd) {
            this.userNamesToAdd = UserNameListCopier.copy(userNamesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userNamesToAdd(String ... userNamesToAdd) {
            this.userNamesToAdd(Arrays.asList(userNamesToAdd));
            return this;
        }

        public ACLPendingChanges build() {
            return new ACLPendingChanges(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ACLPendingChanges> {
        public Builder userNamesToRemove(Collection<String> var1);

        public Builder userNamesToRemove(String ... var1);

        public Builder userNamesToAdd(Collection<String> var1);

        public Builder userNamesToAdd(String ... var1);
    }
}

