/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medicalimaging.MedicalImagingClient;
import software.amazon.awssdk.services.medicalimaging.internal.UserAgentUtils;
import software.amazon.awssdk.services.medicalimaging.model.ImageSetProperties;
import software.amazon.awssdk.services.medicalimaging.model.ListImageSetVersionsRequest;
import software.amazon.awssdk.services.medicalimaging.model.ListImageSetVersionsResponse;

public class ListImageSetVersionsIterable
implements SdkIterable<ListImageSetVersionsResponse> {
    private final MedicalImagingClient client;
    private final ListImageSetVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImageSetVersionsIterable(MedicalImagingClient client, ListImageSetVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListImageSetVersionsResponseFetcher();
    }

    public Iterator<ListImageSetVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImageSetProperties> imageSetPropertiesList() {
        Function<ListImageSetVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageSetPropertiesList() != null) {
                return response.imageSetPropertiesList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListImageSetVersionsResponseFetcher
    implements SyncPageFetcher<ListImageSetVersionsResponse> {
        private ListImageSetVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListImageSetVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImageSetVersionsResponse nextPage(ListImageSetVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListImageSetVersionsIterable.this.client.listImageSetVersions(ListImageSetVersionsIterable.this.firstRequest);
            }
            return ListImageSetVersionsIterable.this.client.listImageSetVersions((ListImageSetVersionsRequest)((Object)ListImageSetVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

