/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medicalimaging.MedicalImagingAsyncClient;
import software.amazon.awssdk.services.medicalimaging.internal.UserAgentUtils;
import software.amazon.awssdk.services.medicalimaging.model.DICOMImportJobSummary;
import software.amazon.awssdk.services.medicalimaging.model.ListDicomImportJobsRequest;
import software.amazon.awssdk.services.medicalimaging.model.ListDicomImportJobsResponse;

public class ListDICOMImportJobsPublisher
implements SdkPublisher<ListDicomImportJobsResponse> {
    private final MedicalImagingAsyncClient client;
    private final ListDicomImportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDICOMImportJobsPublisher(MedicalImagingAsyncClient client, ListDicomImportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDICOMImportJobsPublisher(MedicalImagingAsyncClient client, ListDicomImportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDicomImportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDicomImportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DICOMImportJobSummary> jobSummaries() {
        Function<ListDicomImportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobSummaries() != null) {
                return response.jobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDicomImportJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDicomImportJobsResponseFetcher
    implements AsyncPageFetcher<ListDicomImportJobsResponse> {
        private ListDicomImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListDicomImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDicomImportJobsResponse> nextPage(ListDicomImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListDICOMImportJobsPublisher.this.client.listDICOMImportJobs(ListDICOMImportJobsPublisher.this.firstRequest);
            }
            return ListDICOMImportJobsPublisher.this.client.listDICOMImportJobs((ListDicomImportJobsRequest)((Object)ListDICOMImportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

