/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Program transition configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProgramTransition implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateProgramTransition.Builder, UpdateProgramTransition> {
    private static final SdkField<Long> DURATION_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationMillis").getter(getter(UpdateProgramTransition::durationMillis))
            .setter(setter(Builder::durationMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMillis").build()).build();

    private static final SdkField<Long> SCHEDULED_START_TIME_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ScheduledStartTimeMillis").getter(getter(UpdateProgramTransition::scheduledStartTimeMillis))
            .setter(setter(Builder::scheduledStartTimeMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledStartTimeMillis").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DURATION_MILLIS_FIELD,
            SCHEDULED_START_TIME_MILLIS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long durationMillis;

    private final Long scheduledStartTimeMillis;

    private UpdateProgramTransition(BuilderImpl builder) {
        this.durationMillis = builder.durationMillis;
        this.scheduledStartTimeMillis = builder.scheduledStartTimeMillis;
    }

    /**
     * <p>
     * The duration of the live program in seconds.
     * </p>
     * 
     * @return The duration of the live program in seconds.
     */
    public final Long durationMillis() {
        return durationMillis;
    }

    /**
     * <p>
     * The date and time that the program is scheduled to start, in epoch milliseconds.
     * </p>
     * 
     * @return The date and time that the program is scheduled to start, in epoch milliseconds.
     */
    public final Long scheduledStartTimeMillis() {
        return scheduledStartTimeMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(durationMillis());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledStartTimeMillis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProgramTransition)) {
            return false;
        }
        UpdateProgramTransition other = (UpdateProgramTransition) obj;
        return Objects.equals(durationMillis(), other.durationMillis())
                && Objects.equals(scheduledStartTimeMillis(), other.scheduledStartTimeMillis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProgramTransition").add("DurationMillis", durationMillis())
                .add("ScheduledStartTimeMillis", scheduledStartTimeMillis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DurationMillis":
            return Optional.ofNullable(clazz.cast(durationMillis()));
        case "ScheduledStartTimeMillis":
            return Optional.ofNullable(clazz.cast(scheduledStartTimeMillis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProgramTransition, T> g) {
        return obj -> g.apply((UpdateProgramTransition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateProgramTransition> {
        /**
         * <p>
         * The duration of the live program in seconds.
         * </p>
         * 
         * @param durationMillis
         *        The duration of the live program in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationMillis(Long durationMillis);

        /**
         * <p>
         * The date and time that the program is scheduled to start, in epoch milliseconds.
         * </p>
         * 
         * @param scheduledStartTimeMillis
         *        The date and time that the program is scheduled to start, in epoch milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledStartTimeMillis(Long scheduledStartTimeMillis);
    }

    static final class BuilderImpl implements Builder {
        private Long durationMillis;

        private Long scheduledStartTimeMillis;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProgramTransition model) {
            durationMillis(model.durationMillis);
            scheduledStartTimeMillis(model.scheduledStartTimeMillis);
        }

        public final Long getDurationMillis() {
            return durationMillis;
        }

        public final void setDurationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
        }

        @Override
        public final Builder durationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        public final Long getScheduledStartTimeMillis() {
            return scheduledStartTimeMillis;
        }

        public final void setScheduledStartTimeMillis(Long scheduledStartTimeMillis) {
            this.scheduledStartTimeMillis = scheduledStartTimeMillis;
        }

        @Override
        public final Builder scheduledStartTimeMillis(Long scheduledStartTimeMillis) {
            this.scheduledStartTimeMillis = scheduledStartTimeMillis;
            return this;
        }

        @Override
        public UpdateProgramTransition build() {
            return new UpdateProgramTransition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
