/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediapackage.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediapackage.MediaPackageClient;
import software.amazon.awssdk.services.mediapackage.model.HarvestJob;
import software.amazon.awssdk.services.mediapackage.model.ListHarvestJobsRequest;
import software.amazon.awssdk.services.mediapackage.model.ListHarvestJobsResponse;

public class ListHarvestJobsIterable
implements SdkIterable<ListHarvestJobsResponse> {
    private final MediaPackageClient client;
    private final ListHarvestJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListHarvestJobsIterable(MediaPackageClient client, ListHarvestJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListHarvestJobsResponseFetcher();
    }

    public Iterator<ListHarvestJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HarvestJob> harvestJobs() {
        Function<ListHarvestJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.harvestJobs() != null) {
                return response.harvestJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListHarvestJobsResponseFetcher
    implements SyncPageFetcher<ListHarvestJobsResponse> {
        private ListHarvestJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListHarvestJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListHarvestJobsResponse nextPage(ListHarvestJobsResponse previousPage) {
            if (previousPage == null) {
                return ListHarvestJobsIterable.this.client.listHarvestJobs(ListHarvestJobsIterable.this.firstRequest);
            }
            return ListHarvestJobsIterable.this.client.listHarvestJobs((ListHarvestJobsRequest)((Object)ListHarvestJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

