/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsRequest;
import software.amazon.awssdk.services.medialive.model.ListMultiplexProgramsResponse;
import software.amazon.awssdk.services.medialive.model.MultiplexProgramSummary;

public class ListMultiplexProgramsIterable
implements SdkIterable<ListMultiplexProgramsResponse> {
    private final MediaLiveClient client;
    private final ListMultiplexProgramsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMultiplexProgramsIterable(MediaLiveClient client, ListMultiplexProgramsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMultiplexProgramsResponseFetcher();
    }

    public Iterator<ListMultiplexProgramsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MultiplexProgramSummary> multiplexPrograms() {
        Function<ListMultiplexProgramsResponse, Iterator> getIterator = response -> {
            if (response != null && response.multiplexPrograms() != null) {
                return response.multiplexPrograms().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMultiplexProgramsResponseFetcher
    implements SyncPageFetcher<ListMultiplexProgramsResponse> {
        private ListMultiplexProgramsResponseFetcher() {
        }

        public boolean hasNextPage(ListMultiplexProgramsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMultiplexProgramsResponse nextPage(ListMultiplexProgramsResponse previousPage) {
            if (previousPage == null) {
                return ListMultiplexProgramsIterable.this.client.listMultiplexPrograms(ListMultiplexProgramsIterable.this.firstRequest);
            }
            return ListMultiplexProgramsIterable.this.client.listMultiplexPrograms((ListMultiplexProgramsRequest)((Object)ListMultiplexProgramsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

