/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AudioType {
    CLEAN_EFFECTS("CLEAN_EFFECTS"),
    HEARING_IMPAIRED("HEARING_IMPAIRED"),
    UNDEFINED("UNDEFINED"),
    VISUAL_IMPAIRED_COMMENTARY("VISUAL_IMPAIRED_COMMENTARY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AudioType> VALUE_MAP;
    private final String value;

    private AudioType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AudioType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AudioType> knownValues() {
        EnumSet<AudioType> knownValues = EnumSet.allOf(AudioType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AudioType.class, AudioType::toString);
    }
}

