/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AacSpec {
    MPEG2("MPEG2"),
    MPEG4("MPEG4"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AacSpec> VALUE_MAP;
    private final String value;

    private AacSpec(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AacSpec fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AacSpec> knownValues() {
        EnumSet<AacSpec> knownValues = EnumSet.allOf(AacSpec.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AacSpec.class, AacSpec::toString);
    }
}

