/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.medialive.model.ChannelClass;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.services.medialive.model.OutputDestination;
import software.amazon.awssdk.services.medialive.model.___listOfOutputDestinationCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateChannelClassRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, UpdateChannelClassRequest> {
    private static final SdkField<String> CHANNEL_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelClass").getter(UpdateChannelClassRequest.getter(UpdateChannelClassRequest::channelClassAsString)).setter(UpdateChannelClassRequest.setter(Builder::channelClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channelClass").build()}).build();
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelId").getter(UpdateChannelClassRequest.getter(UpdateChannelClassRequest::channelId)).setter(UpdateChannelClassRequest.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelId").build()}).build();
    private static final SdkField<List<OutputDestination>> DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Destinations").getter(UpdateChannelClassRequest.getter(UpdateChannelClassRequest::destinations)).setter(UpdateChannelClassRequest.setter(Builder::destinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OutputDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_CLASS_FIELD, CHANNEL_ID_FIELD, DESTINATIONS_FIELD));
    private final String channelClass;
    private final String channelId;
    private final List<OutputDestination> destinations;

    private UpdateChannelClassRequest(BuilderImpl builder) {
        super(builder);
        this.channelClass = builder.channelClass;
        this.channelId = builder.channelId;
        this.destinations = builder.destinations;
    }

    public final ChannelClass channelClass() {
        return ChannelClass.fromValue(this.channelClass);
    }

    public final String channelClassAsString() {
        return this.channelClass;
    }

    public final String channelId() {
        return this.channelId;
    }

    public final boolean hasDestinations() {
        return this.destinations != null && !(this.destinations instanceof SdkAutoConstructList);
    }

    public final List<OutputDestination> destinations() {
        return this.destinations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDestinations() ? this.destinations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelClassRequest)) {
            return false;
        }
        UpdateChannelClassRequest other = (UpdateChannelClassRequest)((Object)obj);
        return Objects.equals(this.channelClassAsString(), other.channelClassAsString()) && Objects.equals(this.channelId(), other.channelId()) && this.hasDestinations() == other.hasDestinations() && Objects.equals(this.destinations(), other.destinations());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateChannelClassRequest").add("ChannelClass", (Object)this.channelClassAsString()).add("ChannelId", (Object)this.channelId()).add("Destinations", this.hasDestinations() ? this.destinations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelClass": {
                return Optional.ofNullable(clazz.cast(this.channelClassAsString()));
            }
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
            case "Destinations": {
                return Optional.ofNullable(clazz.cast(this.destinations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateChannelClassRequest, T> g) {
        return obj -> g.apply((UpdateChannelClassRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private String channelClass;
        private String channelId;
        private List<OutputDestination> destinations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChannelClassRequest model) {
            super(model);
            this.channelClass(model.channelClass);
            this.channelId(model.channelId);
            this.destinations(model.destinations);
        }

        public final String getChannelClass() {
            return this.channelClass;
        }

        public final void setChannelClass(String channelClass) {
            this.channelClass = channelClass;
        }

        @Override
        @Transient
        public final Builder channelClass(String channelClass) {
            this.channelClass = channelClass;
            return this;
        }

        @Override
        @Transient
        public final Builder channelClass(ChannelClass channelClass) {
            this.channelClass(channelClass == null ? null : channelClass.toString());
            return this;
        }

        public final String getChannelId() {
            return this.channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        @Transient
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final List<OutputDestination.Builder> getDestinations() {
            List<OutputDestination.Builder> result = ___listOfOutputDestinationCopier.copyToBuilder(this.destinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDestinations(Collection<OutputDestination.BuilderImpl> destinations) {
            this.destinations = ___listOfOutputDestinationCopier.copyFromBuilder(destinations);
        }

        @Override
        @Transient
        public final Builder destinations(Collection<OutputDestination> destinations) {
            this.destinations = ___listOfOutputDestinationCopier.copy(destinations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder destinations(OutputDestination ... destinations) {
            this.destinations(Arrays.asList(destinations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder destinations(Consumer<OutputDestination.Builder> ... destinations) {
            this.destinations(Stream.of(destinations).map(c -> (OutputDestination)((OutputDestination.Builder)OutputDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChannelClassRequest build() {
            return new UpdateChannelClassRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateChannelClassRequest> {
        public Builder channelClass(String var1);

        public Builder channelClass(ChannelClass var1);

        public Builder channelId(String var1);

        public Builder destinations(Collection<OutputDestination> var1);

        public Builder destinations(OutputDestination ... var1);

        public Builder destinations(Consumer<OutputDestination.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

