/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.OfferingDurationUnits;
import software.amazon.awssdk.services.medialive.model.OfferingType;
import software.amazon.awssdk.services.medialive.model.ReservationResourceSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Offering
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Offering> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Offering.getter(Offering::arn)).setter(Offering.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrencyCode").getter(Offering.getter(Offering::currencyCode)).setter(Offering.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()}).build();
    private static final SdkField<Integer> DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Duration").getter(Offering.getter(Offering::duration)).setter(Offering.setter(Builder::duration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("duration").build()}).build();
    private static final SdkField<String> DURATION_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DurationUnits").getter(Offering.getter(Offering::durationUnitsAsString)).setter(Offering.setter(Builder::durationUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("durationUnits").build()}).build();
    private static final SdkField<Double> FIXED_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("FixedPrice").getter(Offering.getter(Offering::fixedPrice)).setter(Offering.setter(Builder::fixedPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedPrice").build()}).build();
    private static final SdkField<String> OFFERING_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingDescription").getter(Offering.getter(Offering::offeringDescription)).setter(Offering.setter(Builder::offeringDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringDescription").build()}).build();
    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingId").getter(Offering.getter(Offering::offeringId)).setter(Offering.setter(Builder::offeringId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringId").build()}).build();
    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingType").getter(Offering.getter(Offering::offeringTypeAsString)).setter(Offering.setter(Builder::offeringType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringType").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(Offering.getter(Offering::region)).setter(Offering.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<ReservationResourceSpecification> RESOURCE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceSpecification").getter(Offering.getter(Offering::resourceSpecification)).setter(Offering.setter(Builder::resourceSpecification)).constructor(ReservationResourceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceSpecification").build()}).build();
    private static final SdkField<Double> USAGE_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("UsagePrice").getter(Offering.getter(Offering::usagePrice)).setter(Offering.setter(Builder::usagePrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usagePrice").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CURRENCY_CODE_FIELD, DURATION_FIELD, DURATION_UNITS_FIELD, FIXED_PRICE_FIELD, OFFERING_DESCRIPTION_FIELD, OFFERING_ID_FIELD, OFFERING_TYPE_FIELD, REGION_FIELD, RESOURCE_SPECIFICATION_FIELD, USAGE_PRICE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String currencyCode;
    private final Integer duration;
    private final String durationUnits;
    private final Double fixedPrice;
    private final String offeringDescription;
    private final String offeringId;
    private final String offeringType;
    private final String region;
    private final ReservationResourceSpecification resourceSpecification;
    private final Double usagePrice;

    private Offering(BuilderImpl builder) {
        this.arn = builder.arn;
        this.currencyCode = builder.currencyCode;
        this.duration = builder.duration;
        this.durationUnits = builder.durationUnits;
        this.fixedPrice = builder.fixedPrice;
        this.offeringDescription = builder.offeringDescription;
        this.offeringId = builder.offeringId;
        this.offeringType = builder.offeringType;
        this.region = builder.region;
        this.resourceSpecification = builder.resourceSpecification;
        this.usagePrice = builder.usagePrice;
    }

    public final String arn() {
        return this.arn;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final Integer duration() {
        return this.duration;
    }

    public final OfferingDurationUnits durationUnits() {
        return OfferingDurationUnits.fromValue(this.durationUnits);
    }

    public final String durationUnitsAsString() {
        return this.durationUnits;
    }

    public final Double fixedPrice() {
        return this.fixedPrice;
    }

    public final String offeringDescription() {
        return this.offeringDescription;
    }

    public final String offeringId() {
        return this.offeringId;
    }

    public final OfferingType offeringType() {
        return OfferingType.fromValue(this.offeringType);
    }

    public final String offeringTypeAsString() {
        return this.offeringType;
    }

    public final String region() {
        return this.region;
    }

    public final ReservationResourceSpecification resourceSpecification() {
        return this.resourceSpecification;
    }

    public final Double usagePrice() {
        return this.usagePrice;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.duration());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fixedPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.usagePrice());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Offering)) {
            return false;
        }
        Offering other = (Offering)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.duration(), other.duration()) && Objects.equals(this.durationUnitsAsString(), other.durationUnitsAsString()) && Objects.equals(this.fixedPrice(), other.fixedPrice()) && Objects.equals(this.offeringDescription(), other.offeringDescription()) && Objects.equals(this.offeringId(), other.offeringId()) && Objects.equals(this.offeringTypeAsString(), other.offeringTypeAsString()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.resourceSpecification(), other.resourceSpecification()) && Objects.equals(this.usagePrice(), other.usagePrice());
    }

    public final String toString() {
        return ToString.builder((String)"Offering").add("Arn", (Object)this.arn()).add("CurrencyCode", (Object)this.currencyCode()).add("Duration", (Object)this.duration()).add("DurationUnits", (Object)this.durationUnitsAsString()).add("FixedPrice", (Object)this.fixedPrice()).add("OfferingDescription", (Object)this.offeringDescription()).add("OfferingId", (Object)this.offeringId()).add("OfferingType", (Object)this.offeringTypeAsString()).add("Region", (Object)this.region()).add("ResourceSpecification", (Object)this.resourceSpecification()).add("UsagePrice", (Object)this.usagePrice()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "Duration": {
                return Optional.ofNullable(clazz.cast(this.duration()));
            }
            case "DurationUnits": {
                return Optional.ofNullable(clazz.cast(this.durationUnitsAsString()));
            }
            case "FixedPrice": {
                return Optional.ofNullable(clazz.cast(this.fixedPrice()));
            }
            case "OfferingDescription": {
                return Optional.ofNullable(clazz.cast(this.offeringDescription()));
            }
            case "OfferingId": {
                return Optional.ofNullable(clazz.cast(this.offeringId()));
            }
            case "OfferingType": {
                return Optional.ofNullable(clazz.cast(this.offeringTypeAsString()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "ResourceSpecification": {
                return Optional.ofNullable(clazz.cast(this.resourceSpecification()));
            }
            case "UsagePrice": {
                return Optional.ofNullable(clazz.cast(this.usagePrice()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Offering, T> g) {
        return obj -> g.apply((Offering)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String currencyCode;
        private Integer duration;
        private String durationUnits;
        private Double fixedPrice;
        private String offeringDescription;
        private String offeringId;
        private String offeringType;
        private String region;
        private ReservationResourceSpecification resourceSpecification;
        private Double usagePrice;

        private BuilderImpl() {
        }

        private BuilderImpl(Offering model) {
            this.arn(model.arn);
            this.currencyCode(model.currencyCode);
            this.duration(model.duration);
            this.durationUnits(model.durationUnits);
            this.fixedPrice(model.fixedPrice);
            this.offeringDescription(model.offeringDescription);
            this.offeringId(model.offeringId);
            this.offeringType(model.offeringType);
            this.region(model.region);
            this.resourceSpecification(model.resourceSpecification);
            this.usagePrice(model.usagePrice);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        @Transient
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final Integer getDuration() {
            return this.duration;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        @Override
        @Transient
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final String getDurationUnits() {
            return this.durationUnits;
        }

        public final void setDurationUnits(String durationUnits) {
            this.durationUnits = durationUnits;
        }

        @Override
        @Transient
        public final Builder durationUnits(String durationUnits) {
            this.durationUnits = durationUnits;
            return this;
        }

        @Override
        @Transient
        public final Builder durationUnits(OfferingDurationUnits durationUnits) {
            this.durationUnits(durationUnits == null ? null : durationUnits.toString());
            return this;
        }

        public final Double getFixedPrice() {
            return this.fixedPrice;
        }

        public final void setFixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
        }

        @Override
        @Transient
        public final Builder fixedPrice(Double fixedPrice) {
            this.fixedPrice = fixedPrice;
            return this;
        }

        public final String getOfferingDescription() {
            return this.offeringDescription;
        }

        public final void setOfferingDescription(String offeringDescription) {
            this.offeringDescription = offeringDescription;
        }

        @Override
        @Transient
        public final Builder offeringDescription(String offeringDescription) {
            this.offeringDescription = offeringDescription;
            return this;
        }

        public final String getOfferingId() {
            return this.offeringId;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        @Transient
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        @Transient
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        @Transient
        public final Builder offeringType(OfferingType offeringType) {
            this.offeringType(offeringType == null ? null : offeringType.toString());
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final ReservationResourceSpecification.Builder getResourceSpecification() {
            return this.resourceSpecification != null ? this.resourceSpecification.toBuilder() : null;
        }

        public final void setResourceSpecification(ReservationResourceSpecification.BuilderImpl resourceSpecification) {
            this.resourceSpecification = resourceSpecification != null ? resourceSpecification.build() : null;
        }

        @Override
        @Transient
        public final Builder resourceSpecification(ReservationResourceSpecification resourceSpecification) {
            this.resourceSpecification = resourceSpecification;
            return this;
        }

        public final Double getUsagePrice() {
            return this.usagePrice;
        }

        public final void setUsagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
        }

        @Override
        @Transient
        public final Builder usagePrice(Double usagePrice) {
            this.usagePrice = usagePrice;
            return this;
        }

        public Offering build() {
            return new Offering(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Offering> {
        public Builder arn(String var1);

        public Builder currencyCode(String var1);

        public Builder duration(Integer var1);

        public Builder durationUnits(String var1);

        public Builder durationUnits(OfferingDurationUnits var1);

        public Builder fixedPrice(Double var1);

        public Builder offeringDescription(String var1);

        public Builder offeringId(String var1);

        public Builder offeringType(String var1);

        public Builder offeringType(OfferingType var1);

        public Builder region(String var1);

        public Builder resourceSpecification(ReservationResourceSpecification var1);

        default public Builder resourceSpecification(Consumer<ReservationResourceSpecification.Builder> resourceSpecification) {
            return this.resourceSpecification((ReservationResourceSpecification)((ReservationResourceSpecification.Builder)ReservationResourceSpecification.builder().applyMutation(resourceSpecification)).build());
        }

        public Builder usagePrice(Double var1);
    }
}

