/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medialive.model.HlsH265PackagingType;
import software.amazon.awssdk.services.medialive.model.HlsSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsOutputSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsOutputSettings> {
    private static final SdkField<String> H265_PACKAGING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("H265PackagingType").getter(HlsOutputSettings.getter(HlsOutputSettings::h265PackagingTypeAsString)).setter(HlsOutputSettings.setter(Builder::h265PackagingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("h265PackagingType").build()}).build();
    private static final SdkField<HlsSettings> HLS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HlsSettings").getter(HlsOutputSettings.getter(HlsOutputSettings::hlsSettings)).setter(HlsOutputSettings.setter(Builder::hlsSettings)).constructor(HlsSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsSettings").build()}).build();
    private static final SdkField<String> NAME_MODIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NameModifier").getter(HlsOutputSettings.getter(HlsOutputSettings::nameModifier)).setter(HlsOutputSettings.setter(Builder::nameModifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nameModifier").build()}).build();
    private static final SdkField<String> SEGMENT_MODIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SegmentModifier").getter(HlsOutputSettings.getter(HlsOutputSettings::segmentModifier)).setter(HlsOutputSettings.setter(Builder::segmentModifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentModifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(H265_PACKAGING_TYPE_FIELD, HLS_SETTINGS_FIELD, NAME_MODIFIER_FIELD, SEGMENT_MODIFIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String h265PackagingType;
    private final HlsSettings hlsSettings;
    private final String nameModifier;
    private final String segmentModifier;

    private HlsOutputSettings(BuilderImpl builder) {
        this.h265PackagingType = builder.h265PackagingType;
        this.hlsSettings = builder.hlsSettings;
        this.nameModifier = builder.nameModifier;
        this.segmentModifier = builder.segmentModifier;
    }

    public final HlsH265PackagingType h265PackagingType() {
        return HlsH265PackagingType.fromValue(this.h265PackagingType);
    }

    public final String h265PackagingTypeAsString() {
        return this.h265PackagingType;
    }

    public final HlsSettings hlsSettings() {
        return this.hlsSettings;
    }

    public final String nameModifier() {
        return this.nameModifier;
    }

    public final String segmentModifier() {
        return this.segmentModifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.h265PackagingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameModifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentModifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsOutputSettings)) {
            return false;
        }
        HlsOutputSettings other = (HlsOutputSettings)obj;
        return Objects.equals(this.h265PackagingTypeAsString(), other.h265PackagingTypeAsString()) && Objects.equals(this.hlsSettings(), other.hlsSettings()) && Objects.equals(this.nameModifier(), other.nameModifier()) && Objects.equals(this.segmentModifier(), other.segmentModifier());
    }

    public final String toString() {
        return ToString.builder((String)"HlsOutputSettings").add("H265PackagingType", (Object)this.h265PackagingTypeAsString()).add("HlsSettings", (Object)this.hlsSettings()).add("NameModifier", (Object)this.nameModifier()).add("SegmentModifier", (Object)this.segmentModifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "H265PackagingType": {
                return Optional.ofNullable(clazz.cast(this.h265PackagingTypeAsString()));
            }
            case "HlsSettings": {
                return Optional.ofNullable(clazz.cast(this.hlsSettings()));
            }
            case "NameModifier": {
                return Optional.ofNullable(clazz.cast(this.nameModifier()));
            }
            case "SegmentModifier": {
                return Optional.ofNullable(clazz.cast(this.segmentModifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsOutputSettings, T> g) {
        return obj -> g.apply((HlsOutputSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String h265PackagingType;
        private HlsSettings hlsSettings;
        private String nameModifier;
        private String segmentModifier;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsOutputSettings model) {
            this.h265PackagingType(model.h265PackagingType);
            this.hlsSettings(model.hlsSettings);
            this.nameModifier(model.nameModifier);
            this.segmentModifier(model.segmentModifier);
        }

        public final String getH265PackagingType() {
            return this.h265PackagingType;
        }

        public final void setH265PackagingType(String h265PackagingType) {
            this.h265PackagingType = h265PackagingType;
        }

        @Override
        @Transient
        public final Builder h265PackagingType(String h265PackagingType) {
            this.h265PackagingType = h265PackagingType;
            return this;
        }

        @Override
        @Transient
        public final Builder h265PackagingType(HlsH265PackagingType h265PackagingType) {
            this.h265PackagingType(h265PackagingType == null ? null : h265PackagingType.toString());
            return this;
        }

        public final HlsSettings.Builder getHlsSettings() {
            return this.hlsSettings != null ? this.hlsSettings.toBuilder() : null;
        }

        public final void setHlsSettings(HlsSettings.BuilderImpl hlsSettings) {
            this.hlsSettings = hlsSettings != null ? hlsSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder hlsSettings(HlsSettings hlsSettings) {
            this.hlsSettings = hlsSettings;
            return this;
        }

        public final String getNameModifier() {
            return this.nameModifier;
        }

        public final void setNameModifier(String nameModifier) {
            this.nameModifier = nameModifier;
        }

        @Override
        @Transient
        public final Builder nameModifier(String nameModifier) {
            this.nameModifier = nameModifier;
            return this;
        }

        public final String getSegmentModifier() {
            return this.segmentModifier;
        }

        public final void setSegmentModifier(String segmentModifier) {
            this.segmentModifier = segmentModifier;
        }

        @Override
        @Transient
        public final Builder segmentModifier(String segmentModifier) {
            this.segmentModifier = segmentModifier;
            return this;
        }

        public HlsOutputSettings build() {
            return new HlsOutputSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsOutputSettings> {
        public Builder h265PackagingType(String var1);

        public Builder h265PackagingType(HlsH265PackagingType var1);

        public Builder hlsSettings(HlsSettings var1);

        default public Builder hlsSettings(Consumer<HlsSettings.Builder> hlsSettings) {
            return this.hlsSettings((HlsSettings)((HlsSettings.Builder)HlsSettings.builder().applyMutation(hlsSettings)).build());
        }

        public Builder nameModifier(String var1);

        public Builder segmentModifier(String var1);
    }
}

