/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Choose the method that you want MediaConvert to use when increasing or decreasing the frame rate. For numerically
 * simple conversions, such as 60 fps to 30 fps: We recommend that you keep the default value, Drop duplicate. For
 * numerically complex conversions, to avoid stutter: Choose Interpolate. This results in a smooth picture, but might
 * introduce undesirable video artifacts. For complex frame rate conversions, especially if your source video has
 * already been converted from its original cadence: Choose FrameFormer to do motion-compensated interpolation.
 * FrameFormer uses the best conversion method frame by frame. Note that using FrameFormer increases the transcoding
 * time and incurs a significant add-on cost. When you choose FrameFormer, your input video resolution must be at least
 * 128x96.
 */
@Generated("software.amazon.awssdk:codegen")
public enum XavcFramerateConversionAlgorithm {
    DUPLICATE_DROP("DUPLICATE_DROP"),

    INTERPOLATE("INTERPOLATE"),

    FRAMEFORMER("FRAMEFORMER"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, XavcFramerateConversionAlgorithm> VALUE_MAP = EnumUtils.uniqueIndex(
            XavcFramerateConversionAlgorithm.class, XavcFramerateConversionAlgorithm::toString);

    private final String value;

    private XavcFramerateConversionAlgorithm(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return XavcFramerateConversionAlgorithm corresponding to the value
     */
    public static XavcFramerateConversionAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link XavcFramerateConversionAlgorithm}s
     */
    public static Set<XavcFramerateConversionAlgorithm> knownValues() {
        Set<XavcFramerateConversionAlgorithm> knownValues = EnumSet.allOf(XavcFramerateConversionAlgorithm.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
