/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify this setting only when your output will be consumed by a downstream repackaging workflow that is sensitive to
 * very small duration differences between video and audio. For this situation, choose Match video duration. In all
 * other cases, keep the default value, Default codec duration. When you choose Match video duration, MediaConvert pads
 * the output audio streams with silence or trims them to ensure that the total duration of each audio stream is at
 * least as long as the total duration of the video stream. After padding or trimming, the audio stream duration is no
 * more than one frame longer than the video stream. MediaConvert applies audio padding or trimming only to the end of
 * the last segment of the output. For unsegmented outputs, MediaConvert adds padding only to the end of the file. When
 * you keep the default value, any minor discrepancies between audio and video duration will depend on your output audio
 * codec.
 */
@Generated("software.amazon.awssdk:codegen")
public enum MpdAudioDuration {
    DEFAULT_CODEC_DURATION("DEFAULT_CODEC_DURATION"),

    MATCH_VIDEO_DURATION("MATCH_VIDEO_DURATION"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MpdAudioDuration> VALUE_MAP = EnumUtils.uniqueIndex(MpdAudioDuration.class,
            MpdAudioDuration::toString);

    private final String value;

    private MpdAudioDuration(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return MpdAudioDuration corresponding to the value
     */
    public static MpdAudioDuration fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link MpdAudioDuration}s
     */
    public static Set<MpdAudioDuration> knownValues() {
        Set<MpdAudioDuration> knownValues = EnumSet.allOf(MpdAudioDuration.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
