/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Use Source (TimecodeSource) to set how timecodes are handled within this job. To make sure that your video, audio,
 * captions, and markers are synchronized and that time-based features, such as image inserter, work correctly, choose
 * the Timecode source option that matches your assets. All timecodes are in a 24-hour format with frame number
 * (HH:MM:SS:FF). * Embedded (EMBEDDED) - Use the timecode that is in the input video. If no embedded timecode is in the
 * source, the service will use Start at 0 (ZEROBASED) instead. * Start at 0 (ZEROBASED) - Set the timecode of the
 * initial frame to 00:00:00:00. * Specified Start (SPECIFIEDSTART) - Set the timecode of the initial frame to a value
 * other than zero. You use Start timecode (Start) to provide this value.
 */
@Generated("software.amazon.awssdk:codegen")
public enum TimecodeSource {
    EMBEDDED("EMBEDDED"),

    ZEROBASED("ZEROBASED"),

    SPECIFIEDSTART("SPECIFIEDSTART"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TimecodeSource> VALUE_MAP = EnumUtils.uniqueIndex(TimecodeSource.class,
            TimecodeSource::toString);

    private final String value;

    private TimecodeSource(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return TimecodeSource corresponding to the value
     */
    public static TimecodeSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link TimecodeSource}s
     */
    public static Set<TimecodeSource> knownValues() {
        Set<TimecodeSource> knownValues = EnumSet.allOf(TimecodeSource.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
