/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings associated with S3 destination
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3DestinationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<S3DestinationSettings.Builder, S3DestinationSettings> {
    private static final SdkField<S3DestinationAccessControl> ACCESS_CONTROL_FIELD = SdkField
            .<S3DestinationAccessControl> builder(MarshallingType.SDK_POJO).memberName("AccessControl")
            .getter(getter(S3DestinationSettings::accessControl)).setter(setter(Builder::accessControl))
            .constructor(S3DestinationAccessControl::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessControl").build()).build();

    private static final SdkField<S3EncryptionSettings> ENCRYPTION_FIELD = SdkField
            .<S3EncryptionSettings> builder(MarshallingType.SDK_POJO).memberName("Encryption")
            .getter(getter(S3DestinationSettings::encryption)).setter(setter(Builder::encryption))
            .constructor(S3EncryptionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_CONTROL_FIELD,
            ENCRYPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3DestinationAccessControl accessControl;

    private final S3EncryptionSettings encryption;

    private S3DestinationSettings(BuilderImpl builder) {
        this.accessControl = builder.accessControl;
        this.encryption = builder.encryption;
    }

    /**
     * Optional. Have MediaConvert automatically apply Amazon S3 access control for the outputs in this output group.
     * When you don't use this setting, S3 automatically applies the default access control list PRIVATE.
     * 
     * @return Optional. Have MediaConvert automatically apply Amazon S3 access control for the outputs in this output
     *         group. When you don't use this setting, S3 automatically applies the default access control list PRIVATE.
     */
    public final S3DestinationAccessControl accessControl() {
        return accessControl;
    }

    /**
     * Settings for how your job outputs are encrypted as they are uploaded to Amazon S3.
     * 
     * @return Settings for how your job outputs are encrypted as they are uploaded to Amazon S3.
     */
    public final S3EncryptionSettings encryption() {
        return encryption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessControl());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DestinationSettings)) {
            return false;
        }
        S3DestinationSettings other = (S3DestinationSettings) obj;
        return Objects.equals(accessControl(), other.accessControl()) && Objects.equals(encryption(), other.encryption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3DestinationSettings").add("AccessControl", accessControl()).add("Encryption", encryption())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessControl":
            return Optional.ofNullable(clazz.cast(accessControl()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3DestinationSettings, T> g) {
        return obj -> g.apply((S3DestinationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3DestinationSettings> {
        /**
         * Optional. Have MediaConvert automatically apply Amazon S3 access control for the outputs in this output
         * group. When you don't use this setting, S3 automatically applies the default access control list PRIVATE.
         * 
         * @param accessControl
         *        Optional. Have MediaConvert automatically apply Amazon S3 access control for the outputs in this
         *        output group. When you don't use this setting, S3 automatically applies the default access control
         *        list PRIVATE.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControl(S3DestinationAccessControl accessControl);

        /**
         * Optional. Have MediaConvert automatically apply Amazon S3 access control for the outputs in this output
         * group. When you don't use this setting, S3 automatically applies the default access control list PRIVATE.
         * This is a convenience method that creates an instance of the {@link S3DestinationAccessControl.Builder}
         * avoiding the need to create one manually via {@link S3DestinationAccessControl#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DestinationAccessControl.Builder#build()} is called immediately
         * and its result is passed to {@link #accessControl(S3DestinationAccessControl)}.
         * 
         * @param accessControl
         *        a consumer that will call methods on {@link S3DestinationAccessControl.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessControl(S3DestinationAccessControl)
         */
        default Builder accessControl(Consumer<S3DestinationAccessControl.Builder> accessControl) {
            return accessControl(S3DestinationAccessControl.builder().applyMutation(accessControl).build());
        }

        /**
         * Settings for how your job outputs are encrypted as they are uploaded to Amazon S3.
         * 
         * @param encryption
         *        Settings for how your job outputs are encrypted as they are uploaded to Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(S3EncryptionSettings encryption);

        /**
         * Settings for how your job outputs are encrypted as they are uploaded to Amazon S3. This is a convenience
         * method that creates an instance of the {@link S3EncryptionSettings.Builder} avoiding the need to create one
         * manually via {@link S3EncryptionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3EncryptionSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #encryption(S3EncryptionSettings)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link S3EncryptionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(S3EncryptionSettings)
         */
        default Builder encryption(Consumer<S3EncryptionSettings.Builder> encryption) {
            return encryption(S3EncryptionSettings.builder().applyMutation(encryption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3DestinationAccessControl accessControl;

        private S3EncryptionSettings encryption;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DestinationSettings model) {
            accessControl(model.accessControl);
            encryption(model.encryption);
        }

        public final S3DestinationAccessControl.Builder getAccessControl() {
            return accessControl != null ? accessControl.toBuilder() : null;
        }

        public final void setAccessControl(S3DestinationAccessControl.BuilderImpl accessControl) {
            this.accessControl = accessControl != null ? accessControl.build() : null;
        }

        @Override
        public final Builder accessControl(S3DestinationAccessControl accessControl) {
            this.accessControl = accessControl;
            return this;
        }

        public final S3EncryptionSettings.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        public final void setEncryption(S3EncryptionSettings.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(S3EncryptionSettings encryption) {
            this.encryption = encryption;
            return this;
        }

        @Override
        public S3DestinationSettings build() {
            return new S3DestinationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
