/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Use this setting if your input has video and audio durations that don't align, and your output or player has strict
 * alignment requirements. Examples: Input audio track has a delayed start. Input video track ends before audio ends.
 * When you set Pad video (padVideo) to Black (BLACK), MediaConvert generates black video frames so that output video
 * and audio durations match. Black video frames are added at the beginning or end, depending on your input. To keep the
 * default behavior and not generate black video, set Pad video to Disabled (DISABLED) or leave blank.
 */
@Generated("software.amazon.awssdk:codegen")
public enum PadVideo {
    DISABLED("DISABLED"),

    BLACK("BLACK"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PadVideo> VALUE_MAP = EnumUtils.uniqueIndex(PadVideo.class, PadVideo::toString);

    private final String value;

    private PadVideo(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return PadVideo corresponding to the value
     */
    public static PadVideo fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link PadVideo}s
     */
    public static Set<PadVideo> knownValues() {
        Set<PadVideo> knownValues = EnumSet.allOf(PadVideo.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
