/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * When you do frame rate conversion from 23.976 frames per second (fps) to 29.97 fps, and your output scan type is
 * interlaced, you can optionally enable hard or soft telecine to create a smoother picture. Hard telecine (HARD)
 * produces a 29.97i output. Soft telecine (SOFT) produces an output with a 23.976 output that signals to the video
 * player device to do the conversion during play back. When you keep the default value, None (NONE), MediaConvert does
 * a standard frame rate conversion to 29.97 without doing anything with the field polarity to create a smoother
 * picture.
 */
@Generated("software.amazon.awssdk:codegen")
public enum Mpeg2Telecine {
    NONE("NONE"),

    SOFT("SOFT"),

    HARD("HARD"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Mpeg2Telecine> VALUE_MAP = EnumUtils.uniqueIndex(Mpeg2Telecine.class,
            Mpeg2Telecine::toString);

    private final String value;

    private Mpeg2Telecine(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Mpeg2Telecine corresponding to the value
     */
    public static Mpeg2Telecine fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Mpeg2Telecine}s
     */
    public static Set<Mpeg2Telecine> knownValues() {
        Set<Mpeg2Telecine> knownValues = EnumSet.allOf(Mpeg2Telecine.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
