/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * If the sample range metadata in your input video is accurate, or if you don't know about sample range, keep the
 * default value, Follow (FOLLOW), for this setting. When you do, the service automatically detects your input sample
 * range. If your input video has metadata indicating the wrong sample range, specify the accurate sample range here.
 * When you do, MediaConvert ignores any sample range information in the input metadata. Regardless of whether
 * MediaConvert uses the input sample range or the sample range that you specify, MediaConvert uses the sample range for
 * transcoding and also writes it to the output metadata.
 */
@Generated("software.amazon.awssdk:codegen")
public enum InputSampleRange {
    FOLLOW("FOLLOW"),

    FULL_RANGE("FULL_RANGE"),

    LIMITED_RANGE("LIMITED_RANGE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InputSampleRange> VALUE_MAP = EnumUtils.uniqueIndex(InputSampleRange.class,
            InputSampleRange::toString);

    private final String value;

    private InputSampleRange(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return InputSampleRange corresponding to the value
     */
    public static InputSampleRange fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link InputSampleRange}s
     */
    public static Set<InputSampleRange> knownValues() {
        Set<InputSampleRange> knownValues = EnumSet.allOf(InputSampleRange.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
