/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above its current
 * value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to the nearest integer
 * value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down if less than 0.5 (< 0.5). You
 * may need to use LEGACY if your client needs to ensure that the target duration is always longer than the actual
 * duration of the segment. Some older players may experience interrupted playback when the actual duration of a track
 * in a segment is longer than the target duration.
 */
@Generated("software.amazon.awssdk:codegen")
public enum HlsTargetDurationCompatibilityMode {
    LEGACY("LEGACY"),

    SPEC_COMPLIANT("SPEC_COMPLIANT"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HlsTargetDurationCompatibilityMode> VALUE_MAP = EnumUtils.uniqueIndex(
            HlsTargetDurationCompatibilityMode.class, HlsTargetDurationCompatibilityMode::toString);

    private final String value;

    private HlsTargetDurationCompatibilityMode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return HlsTargetDurationCompatibilityMode corresponding to the value
     */
    public static HlsTargetDurationCompatibilityMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link HlsTargetDurationCompatibilityMode}s
     */
    public static Set<HlsTargetDurationCompatibilityMode> knownValues() {
        Set<HlsTargetDurationCompatibilityMode> knownValues = EnumSet.allOf(HlsTargetDurationCompatibilityMode.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
