/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings related to your HLS output package. For more information, see
 * https://docs.aws.amazon.com/mediaconvert/latest/ug/outputs-file-ABR.html. When you work directly in your JSON job
 * specification, include this object and any required children when you set Type, under OutputGroupSettings, to
 * HLS_GROUP_SETTINGS.
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsGroupSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<HlsGroupSettings.Builder, HlsGroupSettings> {
    private static final SdkField<List<String>> AD_MARKERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdMarkers")
            .getter(getter(HlsGroupSettings::adMarkersAsStrings))
            .setter(setter(Builder::adMarkersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adMarkers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<HlsAdditionalManifest>> ADDITIONAL_MANIFESTS_FIELD = SdkField
            .<List<HlsAdditionalManifest>> builder(MarshallingType.LIST)
            .memberName("AdditionalManifests")
            .getter(getter(HlsGroupSettings::additionalManifests))
            .setter(setter(Builder::additionalManifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalManifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HlsAdditionalManifest> builder(MarshallingType.SDK_POJO)
                                            .constructor(HlsAdditionalManifest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AUDIO_ONLY_HEADER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AudioOnlyHeader").getter(getter(HlsGroupSettings::audioOnlyHeaderAsString))
            .setter(setter(Builder::audioOnlyHeader))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioOnlyHeader").build()).build();

    private static final SdkField<String> BASE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseUrl").getter(getter(HlsGroupSettings::baseUrl)).setter(setter(Builder::baseUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseUrl").build()).build();

    private static final SdkField<List<HlsCaptionLanguageMapping>> CAPTION_LANGUAGE_MAPPINGS_FIELD = SdkField
            .<List<HlsCaptionLanguageMapping>> builder(MarshallingType.LIST)
            .memberName("CaptionLanguageMappings")
            .getter(getter(HlsGroupSettings::captionLanguageMappings))
            .setter(setter(Builder::captionLanguageMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionLanguageMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HlsCaptionLanguageMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(HlsCaptionLanguageMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CAPTION_LANGUAGE_SETTING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CaptionLanguageSetting").getter(getter(HlsGroupSettings::captionLanguageSettingAsString))
            .setter(setter(Builder::captionLanguageSetting))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionLanguageSetting").build())
            .build();

    private static final SdkField<String> CAPTION_SEGMENT_LENGTH_CONTROL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CaptionSegmentLengthControl")
            .getter(getter(HlsGroupSettings::captionSegmentLengthControlAsString))
            .setter(setter(Builder::captionSegmentLengthControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionSegmentLengthControl")
                    .build()).build();

    private static final SdkField<String> CLIENT_CACHE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientCache").getter(getter(HlsGroupSettings::clientCacheAsString)).setter(setter(Builder::clientCache))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCache").build()).build();

    private static final SdkField<String> CODEC_SPECIFICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CodecSpecification").getter(getter(HlsGroupSettings::codecSpecificationAsString))
            .setter(setter(Builder::codecSpecification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecSpecification").build())
            .build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Destination").getter(getter(HlsGroupSettings::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<DestinationSettings> DESTINATION_SETTINGS_FIELD = SdkField
            .<DestinationSettings> builder(MarshallingType.SDK_POJO).memberName("DestinationSettings")
            .getter(getter(HlsGroupSettings::destinationSettings)).setter(setter(Builder::destinationSettings))
            .constructor(DestinationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSettings").build())
            .build();

    private static final SdkField<String> DIRECTORY_STRUCTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryStructure").getter(getter(HlsGroupSettings::directoryStructureAsString))
            .setter(setter(Builder::directoryStructure))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directoryStructure").build())
            .build();

    private static final SdkField<HlsEncryptionSettings> ENCRYPTION_FIELD = SdkField
            .<HlsEncryptionSettings> builder(MarshallingType.SDK_POJO).memberName("Encryption")
            .getter(getter(HlsGroupSettings::encryption)).setter(setter(Builder::encryption))
            .constructor(HlsEncryptionSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()).build();

    private static final SdkField<String> IMAGE_BASED_TRICK_PLAY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageBasedTrickPlay").getter(getter(HlsGroupSettings::imageBasedTrickPlayAsString))
            .setter(setter(Builder::imageBasedTrickPlay))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBasedTrickPlay").build())
            .build();

    private static final SdkField<HlsImageBasedTrickPlaySettings> IMAGE_BASED_TRICK_PLAY_SETTINGS_FIELD = SdkField
            .<HlsImageBasedTrickPlaySettings> builder(MarshallingType.SDK_POJO)
            .memberName("ImageBasedTrickPlaySettings")
            .getter(getter(HlsGroupSettings::imageBasedTrickPlaySettings))
            .setter(setter(Builder::imageBasedTrickPlaySettings))
            .constructor(HlsImageBasedTrickPlaySettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageBasedTrickPlaySettings")
                    .build()).build();

    private static final SdkField<String> MANIFEST_COMPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestCompression").getter(getter(HlsGroupSettings::manifestCompressionAsString))
            .setter(setter(Builder::manifestCompression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestCompression").build())
            .build();

    private static final SdkField<String> MANIFEST_DURATION_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestDurationFormat").getter(getter(HlsGroupSettings::manifestDurationFormatAsString))
            .setter(setter(Builder::manifestDurationFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestDurationFormat").build())
            .build();

    private static final SdkField<Double> MIN_FINAL_SEGMENT_LENGTH_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("MinFinalSegmentLength").getter(getter(HlsGroupSettings::minFinalSegmentLength))
            .setter(setter(Builder::minFinalSegmentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minFinalSegmentLength").build())
            .build();

    private static final SdkField<Integer> MIN_SEGMENT_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinSegmentLength").getter(getter(HlsGroupSettings::minSegmentLength))
            .setter(setter(Builder::minSegmentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minSegmentLength").build()).build();

    private static final SdkField<String> OUTPUT_SELECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OutputSelection").getter(getter(HlsGroupSettings::outputSelectionAsString))
            .setter(setter(Builder::outputSelection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputSelection").build()).build();

    private static final SdkField<String> PROGRAM_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProgramDateTime").getter(getter(HlsGroupSettings::programDateTimeAsString))
            .setter(setter(Builder::programDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programDateTime").build()).build();

    private static final SdkField<Integer> PROGRAM_DATE_TIME_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProgramDateTimePeriod").getter(getter(HlsGroupSettings::programDateTimePeriod))
            .setter(setter(Builder::programDateTimePeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programDateTimePeriod").build())
            .build();

    private static final SdkField<String> PROGRESSIVE_WRITE_HLS_MANIFEST_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProgressiveWriteHlsManifest")
            .getter(getter(HlsGroupSettings::progressiveWriteHlsManifestAsString))
            .setter(setter(Builder::progressiveWriteHlsManifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressiveWriteHlsManifest")
                    .build()).build();

    private static final SdkField<String> SEGMENT_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentControl").getter(getter(HlsGroupSettings::segmentControlAsString))
            .setter(setter(Builder::segmentControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentControl").build()).build();

    private static final SdkField<Integer> SEGMENT_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentLength").getter(getter(HlsGroupSettings::segmentLength)).setter(setter(Builder::segmentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLength").build()).build();

    private static final SdkField<String> SEGMENT_LENGTH_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SegmentLengthControl").getter(getter(HlsGroupSettings::segmentLengthControlAsString))
            .setter(setter(Builder::segmentLengthControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLengthControl").build())
            .build();

    private static final SdkField<Integer> SEGMENTS_PER_SUBDIRECTORY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SegmentsPerSubdirectory").getter(getter(HlsGroupSettings::segmentsPerSubdirectory))
            .setter(setter(Builder::segmentsPerSubdirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentsPerSubdirectory").build())
            .build();

    private static final SdkField<String> STREAM_INF_RESOLUTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamInfResolution").getter(getter(HlsGroupSettings::streamInfResolutionAsString))
            .setter(setter(Builder::streamInfResolution))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamInfResolution").build())
            .build();

    private static final SdkField<String> TARGET_DURATION_COMPATIBILITY_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TargetDurationCompatibilityMode")
            .getter(getter(HlsGroupSettings::targetDurationCompatibilityModeAsString))
            .setter(setter(Builder::targetDurationCompatibilityMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetDurationCompatibilityMode")
                    .build()).build();

    private static final SdkField<String> TIMED_METADATA_ID3_FRAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimedMetadataId3Frame").getter(getter(HlsGroupSettings::timedMetadataId3FrameAsString))
            .setter(setter(Builder::timedMetadataId3Frame))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataId3Frame").build())
            .build();

    private static final SdkField<Integer> TIMED_METADATA_ID3_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimedMetadataId3Period").getter(getter(HlsGroupSettings::timedMetadataId3Period))
            .setter(setter(Builder::timedMetadataId3Period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadataId3Period").build())
            .build();

    private static final SdkField<Integer> TIMESTAMP_DELTA_MILLISECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimestampDeltaMilliseconds")
            .getter(getter(HlsGroupSettings::timestampDeltaMilliseconds))
            .setter(setter(Builder::timestampDeltaMilliseconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestampDeltaMilliseconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_MARKERS_FIELD,
            ADDITIONAL_MANIFESTS_FIELD, AUDIO_ONLY_HEADER_FIELD, BASE_URL_FIELD, CAPTION_LANGUAGE_MAPPINGS_FIELD,
            CAPTION_LANGUAGE_SETTING_FIELD, CAPTION_SEGMENT_LENGTH_CONTROL_FIELD, CLIENT_CACHE_FIELD, CODEC_SPECIFICATION_FIELD,
            DESTINATION_FIELD, DESTINATION_SETTINGS_FIELD, DIRECTORY_STRUCTURE_FIELD, ENCRYPTION_FIELD,
            IMAGE_BASED_TRICK_PLAY_FIELD, IMAGE_BASED_TRICK_PLAY_SETTINGS_FIELD, MANIFEST_COMPRESSION_FIELD,
            MANIFEST_DURATION_FORMAT_FIELD, MIN_FINAL_SEGMENT_LENGTH_FIELD, MIN_SEGMENT_LENGTH_FIELD, OUTPUT_SELECTION_FIELD,
            PROGRAM_DATE_TIME_FIELD, PROGRAM_DATE_TIME_PERIOD_FIELD, PROGRESSIVE_WRITE_HLS_MANIFEST_FIELD, SEGMENT_CONTROL_FIELD,
            SEGMENT_LENGTH_FIELD, SEGMENT_LENGTH_CONTROL_FIELD, SEGMENTS_PER_SUBDIRECTORY_FIELD, STREAM_INF_RESOLUTION_FIELD,
            TARGET_DURATION_COMPATIBILITY_MODE_FIELD, TIMED_METADATA_ID3_FRAME_FIELD, TIMED_METADATA_ID3_PERIOD_FIELD,
            TIMESTAMP_DELTA_MILLISECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> adMarkers;

    private final List<HlsAdditionalManifest> additionalManifests;

    private final String audioOnlyHeader;

    private final String baseUrl;

    private final List<HlsCaptionLanguageMapping> captionLanguageMappings;

    private final String captionLanguageSetting;

    private final String captionSegmentLengthControl;

    private final String clientCache;

    private final String codecSpecification;

    private final String destination;

    private final DestinationSettings destinationSettings;

    private final String directoryStructure;

    private final HlsEncryptionSettings encryption;

    private final String imageBasedTrickPlay;

    private final HlsImageBasedTrickPlaySettings imageBasedTrickPlaySettings;

    private final String manifestCompression;

    private final String manifestDurationFormat;

    private final Double minFinalSegmentLength;

    private final Integer minSegmentLength;

    private final String outputSelection;

    private final String programDateTime;

    private final Integer programDateTimePeriod;

    private final String progressiveWriteHlsManifest;

    private final String segmentControl;

    private final Integer segmentLength;

    private final String segmentLengthControl;

    private final Integer segmentsPerSubdirectory;

    private final String streamInfResolution;

    private final String targetDurationCompatibilityMode;

    private final String timedMetadataId3Frame;

    private final Integer timedMetadataId3Period;

    private final Integer timestampDeltaMilliseconds;

    private HlsGroupSettings(BuilderImpl builder) {
        this.adMarkers = builder.adMarkers;
        this.additionalManifests = builder.additionalManifests;
        this.audioOnlyHeader = builder.audioOnlyHeader;
        this.baseUrl = builder.baseUrl;
        this.captionLanguageMappings = builder.captionLanguageMappings;
        this.captionLanguageSetting = builder.captionLanguageSetting;
        this.captionSegmentLengthControl = builder.captionSegmentLengthControl;
        this.clientCache = builder.clientCache;
        this.codecSpecification = builder.codecSpecification;
        this.destination = builder.destination;
        this.destinationSettings = builder.destinationSettings;
        this.directoryStructure = builder.directoryStructure;
        this.encryption = builder.encryption;
        this.imageBasedTrickPlay = builder.imageBasedTrickPlay;
        this.imageBasedTrickPlaySettings = builder.imageBasedTrickPlaySettings;
        this.manifestCompression = builder.manifestCompression;
        this.manifestDurationFormat = builder.manifestDurationFormat;
        this.minFinalSegmentLength = builder.minFinalSegmentLength;
        this.minSegmentLength = builder.minSegmentLength;
        this.outputSelection = builder.outputSelection;
        this.programDateTime = builder.programDateTime;
        this.programDateTimePeriod = builder.programDateTimePeriod;
        this.progressiveWriteHlsManifest = builder.progressiveWriteHlsManifest;
        this.segmentControl = builder.segmentControl;
        this.segmentLength = builder.segmentLength;
        this.segmentLengthControl = builder.segmentLengthControl;
        this.segmentsPerSubdirectory = builder.segmentsPerSubdirectory;
        this.streamInfResolution = builder.streamInfResolution;
        this.targetDurationCompatibilityMode = builder.targetDurationCompatibilityMode;
        this.timedMetadataId3Frame = builder.timedMetadataId3Frame;
        this.timedMetadataId3Period = builder.timedMetadataId3Period;
        this.timestampDeltaMilliseconds = builder.timestampDeltaMilliseconds;
    }

    /**
     * Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not determine whether
     * SCTE-35 markers appear in the outputs themselves.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdMarkers} method.
     * </p>
     * 
     * @return Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not determine
     *         whether SCTE-35 markers appear in the outputs themselves.
     */
    public final List<HlsAdMarkers> adMarkers() {
        return ___listOfHlsAdMarkersCopier.copyStringToEnum(adMarkers);
    }

    /**
     * For responses, this returns true if the service returned a value for the AdMarkers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAdMarkers() {
        return adMarkers != null && !(adMarkers instanceof SdkAutoConstructList);
    }

    /**
     * Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not determine whether
     * SCTE-35 markers appear in the outputs themselves.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdMarkers} method.
     * </p>
     * 
     * @return Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not determine
     *         whether SCTE-35 markers appear in the outputs themselves.
     */
    public final List<String> adMarkersAsStrings() {
        return adMarkers;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalManifests property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdditionalManifests() {
        return additionalManifests != null && !(additionalManifests instanceof SdkAutoConstructList);
    }

    /**
     * By default, the service creates one top-level .m3u8 HLS manifest for each HLS output group in your job. This
     * default manifest references every output in the output group. To create additional top-level manifests that
     * reference a subset of the outputs in the output group, specify a list of them here.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalManifests} method.
     * </p>
     * 
     * @return By default, the service creates one top-level .m3u8 HLS manifest for each HLS output group in your job.
     *         This default manifest references every output in the output group. To create additional top-level
     *         manifests that reference a subset of the outputs in the output group, specify a list of them here.
     */
    public final List<HlsAdditionalManifest> additionalManifests() {
        return additionalManifests;
    }

    /**
     * Ignore this setting unless you are using FairPlay DRM with Verimatrix and you encounter playback issues. Keep the
     * default value, Include (INCLUDE), to output audio-only headers. Choose Exclude (EXCLUDE) to remove the audio-only
     * headers from your audio segments.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioOnlyHeader}
     * will return {@link HlsAudioOnlyHeader#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #audioOnlyHeaderAsString}.
     * </p>
     * 
     * @return Ignore this setting unless you are using FairPlay DRM with Verimatrix and you encounter playback issues.
     *         Keep the default value, Include (INCLUDE), to output audio-only headers. Choose Exclude (EXCLUDE) to
     *         remove the audio-only headers from your audio segments.
     * @see HlsAudioOnlyHeader
     */
    public final HlsAudioOnlyHeader audioOnlyHeader() {
        return HlsAudioOnlyHeader.fromValue(audioOnlyHeader);
    }

    /**
     * Ignore this setting unless you are using FairPlay DRM with Verimatrix and you encounter playback issues. Keep the
     * default value, Include (INCLUDE), to output audio-only headers. Choose Exclude (EXCLUDE) to remove the audio-only
     * headers from your audio segments.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #audioOnlyHeader}
     * will return {@link HlsAudioOnlyHeader#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #audioOnlyHeaderAsString}.
     * </p>
     * 
     * @return Ignore this setting unless you are using FairPlay DRM with Verimatrix and you encounter playback issues.
     *         Keep the default value, Include (INCLUDE), to output audio-only headers. Choose Exclude (EXCLUDE) to
     *         remove the audio-only headers from your audio segments.
     * @see HlsAudioOnlyHeader
     */
    public final String audioOnlyHeaderAsString() {
        return audioOnlyHeader;
    }

    /**
     * A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if base manifest
     * is delivered from a different URL than the main .m3u8 file.
     * 
     * @return A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if base
     *         manifest is delivered from a different URL than the main .m3u8 file.
     */
    public final String baseUrl() {
        return baseUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the CaptionLanguageMappings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCaptionLanguageMappings() {
        return captionLanguageMappings != null && !(captionLanguageMappings instanceof SdkAutoConstructList);
    }

    /**
     * Language to be used on Caption outputs
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCaptionLanguageMappings} method.
     * </p>
     * 
     * @return Language to be used on Caption outputs
     */
    public final List<HlsCaptionLanguageMapping> captionLanguageMappings() {
        return captionLanguageMappings;
    }

    /**
     * Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest. Specify at
     * least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code you
     * specify. Make sure to specify the languages in the order in which they appear in the original source (if the
     * source is embedded format) or the order of the caption selectors (if the source is other than embedded).
     * Otherwise, languages in the manifest will not match up properly with the output captions. None: Include
     * CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any CLOSED-CAPTIONS line from the manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #captionLanguageSetting} will return {@link HlsCaptionLanguageSetting#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #captionLanguageSettingAsString}.
     * </p>
     * 
     * @return Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest.
     *         Specify at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each
     *         Language Code you specify. Make sure to specify the languages in the order in which they appear in the
     *         original source (if the source is embedded format) or the order of the caption selectors (if the source
     *         is other than embedded). Otherwise, languages in the manifest will not match up properly with the output
     *         captions. None: Include CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any CLOSED-CAPTIONS line
     *         from the manifest.
     * @see HlsCaptionLanguageSetting
     */
    public final HlsCaptionLanguageSetting captionLanguageSetting() {
        return HlsCaptionLanguageSetting.fromValue(captionLanguageSetting);
    }

    /**
     * Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest. Specify at
     * least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code you
     * specify. Make sure to specify the languages in the order in which they appear in the original source (if the
     * source is embedded format) or the order of the caption selectors (if the source is other than embedded).
     * Otherwise, languages in the manifest will not match up properly with the output captions. None: Include
     * CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any CLOSED-CAPTIONS line from the manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #captionLanguageSetting} will return {@link HlsCaptionLanguageSetting#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #captionLanguageSettingAsString}.
     * </p>
     * 
     * @return Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest.
     *         Specify at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each
     *         Language Code you specify. Make sure to specify the languages in the order in which they appear in the
     *         original source (if the source is embedded format) or the order of the caption selectors (if the source
     *         is other than embedded). Otherwise, languages in the manifest will not match up properly with the output
     *         captions. None: Include CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any CLOSED-CAPTIONS line
     *         from the manifest.
     * @see HlsCaptionLanguageSetting
     */
    public final String captionLanguageSettingAsString() {
        return captionLanguageSetting;
    }

    /**
     * Set Caption segment length control (CaptionSegmentLengthControl) to Match video (MATCH_VIDEO) to create caption
     * segments that align with the video segments from the first video output in this output group. For example, if the
     * video segments are 2 seconds long, your WebVTT segments will also be 2 seconds long. Keep the default setting,
     * Large segments (LARGE_SEGMENTS) to create caption segments that are 300 seconds long.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #captionSegmentLengthControl} will return {@link HlsCaptionSegmentLengthControl#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #captionSegmentLengthControlAsString}.
     * </p>
     * 
     * @return Set Caption segment length control (CaptionSegmentLengthControl) to Match video (MATCH_VIDEO) to create
     *         caption segments that align with the video segments from the first video output in this output group. For
     *         example, if the video segments are 2 seconds long, your WebVTT segments will also be 2 seconds long. Keep
     *         the default setting, Large segments (LARGE_SEGMENTS) to create caption segments that are 300 seconds
     *         long.
     * @see HlsCaptionSegmentLengthControl
     */
    public final HlsCaptionSegmentLengthControl captionSegmentLengthControl() {
        return HlsCaptionSegmentLengthControl.fromValue(captionSegmentLengthControl);
    }

    /**
     * Set Caption segment length control (CaptionSegmentLengthControl) to Match video (MATCH_VIDEO) to create caption
     * segments that align with the video segments from the first video output in this output group. For example, if the
     * video segments are 2 seconds long, your WebVTT segments will also be 2 seconds long. Keep the default setting,
     * Large segments (LARGE_SEGMENTS) to create caption segments that are 300 seconds long.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #captionSegmentLengthControl} will return {@link HlsCaptionSegmentLengthControl#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #captionSegmentLengthControlAsString}.
     * </p>
     * 
     * @return Set Caption segment length control (CaptionSegmentLengthControl) to Match video (MATCH_VIDEO) to create
     *         caption segments that align with the video segments from the first video output in this output group. For
     *         example, if the video segments are 2 seconds long, your WebVTT segments will also be 2 seconds long. Keep
     *         the default setting, Large segments (LARGE_SEGMENTS) to create caption segments that are 300 seconds
     *         long.
     * @see HlsCaptionSegmentLengthControl
     */
    public final String captionSegmentLengthControlAsString() {
        return captionSegmentLengthControl;
    }

    /**
     * Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the default
     * value Enabled (ENABLED) and control caching in your video distribution set up. For example, use the Cache-Control
     * http header.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientCache} will
     * return {@link HlsClientCache#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clientCacheAsString}.
     * </p>
     * 
     * @return Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the
     *         default value Enabled (ENABLED) and control caching in your video distribution set up. For example, use
     *         the Cache-Control http header.
     * @see HlsClientCache
     */
    public final HlsClientCache clientCache() {
        return HlsClientCache.fromValue(clientCache);
    }

    /**
     * Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the default
     * value Enabled (ENABLED) and control caching in your video distribution set up. For example, use the Cache-Control
     * http header.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #clientCache} will
     * return {@link HlsClientCache#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #clientCacheAsString}.
     * </p>
     * 
     * @return Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the
     *         default value Enabled (ENABLED) and control caching in your video distribution set up. For example, use
     *         the Cache-Control http header.
     * @see HlsClientCache
     */
    public final String clientCacheAsString() {
        return clientCache;
    }

    /**
     * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #codecSpecification} will return {@link HlsCodecSpecification#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #codecSpecificationAsString}.
     * </p>
     * 
     * @return Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * @see HlsCodecSpecification
     */
    public final HlsCodecSpecification codecSpecification() {
        return HlsCodecSpecification.fromValue(codecSpecification);
    }

    /**
     * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #codecSpecification} will return {@link HlsCodecSpecification#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #codecSpecificationAsString}.
     * </p>
     * 
     * @return Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
     * @see HlsCodecSpecification
     */
    public final String codecSpecificationAsString() {
        return codecSpecification;
    }

    /**
     * Use Destination (Destination) to specify the S3 output location and the output filename base. Destination accepts
     * format identifiers. If you do not specify the base filename in the URI, the service will use the filename of the
     * input file. If your job has multiple inputs, the service uses the filename of the first input file.
     * 
     * @return Use Destination (Destination) to specify the S3 output location and the output filename base. Destination
     *         accepts format identifiers. If you do not specify the base filename in the URI, the service will use the
     *         filename of the input file. If your job has multiple inputs, the service uses the filename of the first
     *         input file.
     */
    public final String destination() {
        return destination;
    }

    /**
     * Settings associated with the destination. Will vary based on the type of destination
     * 
     * @return Settings associated with the destination. Will vary based on the type of destination
     */
    public final DestinationSettings destinationSettings() {
        return destinationSettings;
    }

    /**
     * Indicates whether segments should be placed in subdirectories.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #directoryStructure} will return {@link HlsDirectoryStructure#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #directoryStructureAsString}.
     * </p>
     * 
     * @return Indicates whether segments should be placed in subdirectories.
     * @see HlsDirectoryStructure
     */
    public final HlsDirectoryStructure directoryStructure() {
        return HlsDirectoryStructure.fromValue(directoryStructure);
    }

    /**
     * Indicates whether segments should be placed in subdirectories.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #directoryStructure} will return {@link HlsDirectoryStructure#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #directoryStructureAsString}.
     * </p>
     * 
     * @return Indicates whether segments should be placed in subdirectories.
     * @see HlsDirectoryStructure
     */
    public final String directoryStructureAsString() {
        return directoryStructure;
    }

    /**
     * DRM settings.
     * 
     * @return DRM settings.
     */
    public final HlsEncryptionSettings encryption() {
        return encryption;
    }

    /**
     * Specify whether MediaConvert generates images for trick play. Keep the default value, None (NONE), to not
     * generate any images. Choose Thumbnail (THUMBNAIL) to generate tiled thumbnails. Choose Thumbnail and full frame
     * (THUMBNAIL_AND_FULLFRAME) to generate tiled thumbnails and full-resolution images of single frames. MediaConvert
     * creates a child manifest for each set of images that you generate and adds corresponding entries to the parent
     * manifest. A common application for these images is Roku trick mode. The thumbnails and full-frame images that
     * MediaConvert creates with this feature are compatible with this Roku specification:
     * https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageBasedTrickPlay} will return {@link HlsImageBasedTrickPlay#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #imageBasedTrickPlayAsString}.
     * </p>
     * 
     * @return Specify whether MediaConvert generates images for trick play. Keep the default value, None (NONE), to not
     *         generate any images. Choose Thumbnail (THUMBNAIL) to generate tiled thumbnails. Choose Thumbnail and full
     *         frame (THUMBNAIL_AND_FULLFRAME) to generate tiled thumbnails and full-resolution images of single frames.
     *         MediaConvert creates a child manifest for each set of images that you generate and adds corresponding
     *         entries to the parent manifest. A common application for these images is Roku trick mode. The thumbnails
     *         and full-frame images that MediaConvert creates with this feature are compatible with this Roku
     *         specification:
     *         https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     * @see HlsImageBasedTrickPlay
     */
    public final HlsImageBasedTrickPlay imageBasedTrickPlay() {
        return HlsImageBasedTrickPlay.fromValue(imageBasedTrickPlay);
    }

    /**
     * Specify whether MediaConvert generates images for trick play. Keep the default value, None (NONE), to not
     * generate any images. Choose Thumbnail (THUMBNAIL) to generate tiled thumbnails. Choose Thumbnail and full frame
     * (THUMBNAIL_AND_FULLFRAME) to generate tiled thumbnails and full-resolution images of single frames. MediaConvert
     * creates a child manifest for each set of images that you generate and adds corresponding entries to the parent
     * manifest. A common application for these images is Roku trick mode. The thumbnails and full-frame images that
     * MediaConvert creates with this feature are compatible with this Roku specification:
     * https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #imageBasedTrickPlay} will return {@link HlsImageBasedTrickPlay#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #imageBasedTrickPlayAsString}.
     * </p>
     * 
     * @return Specify whether MediaConvert generates images for trick play. Keep the default value, None (NONE), to not
     *         generate any images. Choose Thumbnail (THUMBNAIL) to generate tiled thumbnails. Choose Thumbnail and full
     *         frame (THUMBNAIL_AND_FULLFRAME) to generate tiled thumbnails and full-resolution images of single frames.
     *         MediaConvert creates a child manifest for each set of images that you generate and adds corresponding
     *         entries to the parent manifest. A common application for these images is Roku trick mode. The thumbnails
     *         and full-frame images that MediaConvert creates with this feature are compatible with this Roku
     *         specification:
     *         https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
     * @see HlsImageBasedTrickPlay
     */
    public final String imageBasedTrickPlayAsString() {
        return imageBasedTrickPlay;
    }

    /**
     * Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
     * 
     * @return Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
     */
    public final HlsImageBasedTrickPlaySettings imageBasedTrickPlaySettings() {
        return imageBasedTrickPlaySettings;
    }

    /**
     * When set to GZIP, compresses HLS playlist.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #manifestCompression} will return {@link HlsManifestCompression#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #manifestCompressionAsString}.
     * </p>
     * 
     * @return When set to GZIP, compresses HLS playlist.
     * @see HlsManifestCompression
     */
    public final HlsManifestCompression manifestCompression() {
        return HlsManifestCompression.fromValue(manifestCompression);
    }

    /**
     * When set to GZIP, compresses HLS playlist.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #manifestCompression} will return {@link HlsManifestCompression#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #manifestCompressionAsString}.
     * </p>
     * 
     * @return When set to GZIP, compresses HLS playlist.
     * @see HlsManifestCompression
     */
    public final String manifestCompressionAsString() {
        return manifestCompression;
    }

    /**
     * Indicates whether the output manifest should use floating point values for segment duration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #manifestDurationFormat} will return {@link HlsManifestDurationFormat#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #manifestDurationFormatAsString}.
     * </p>
     * 
     * @return Indicates whether the output manifest should use floating point values for segment duration.
     * @see HlsManifestDurationFormat
     */
    public final HlsManifestDurationFormat manifestDurationFormat() {
        return HlsManifestDurationFormat.fromValue(manifestDurationFormat);
    }

    /**
     * Indicates whether the output manifest should use floating point values for segment duration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #manifestDurationFormat} will return {@link HlsManifestDurationFormat#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #manifestDurationFormatAsString}.
     * </p>
     * 
     * @return Indicates whether the output manifest should use floating point values for segment duration.
     * @see HlsManifestDurationFormat
     */
    public final String manifestDurationFormatAsString() {
        return manifestDurationFormat;
    }

    /**
     * Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play back
     * the end of your video asset. If you know that player devices are hanging on the final segment of your video
     * because the length of your final segment is too short, use this setting to specify a minimum final segment
     * length, in seconds. Choose a value that is greater than or equal to 1 and less than your segment length. When you
     * specify a value for this setting, the encoder will combine any final segment that is shorter than the length that
     * you specify with the previous segment. For example, your segment length is 3 seconds and your final segment is .5
     * seconds without a minimum final segment length; when you set the minimum final segment length to 1, your final
     * segment is 3.5 seconds.
     * 
     * @return Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices
     *         play back the end of your video asset. If you know that player devices are hanging on the final segment
     *         of your video because the length of your final segment is too short, use this setting to specify a
     *         minimum final segment length, in seconds. Choose a value that is greater than or equal to 1 and less than
     *         your segment length. When you specify a value for this setting, the encoder will combine any final
     *         segment that is shorter than the length that you specify with the previous segment. For example, your
     *         segment length is 3 seconds and your final segment is .5 seconds without a minimum final segment length;
     *         when you set the minimum final segment length to 1, your final segment is 3.5 seconds.
     */
    public final Double minFinalSegmentLength() {
        return minFinalSegmentLength;
    }

    /**
     * When set, Minimum Segment Size is enforced by looking ahead and back within the specified range for a nearby
     * avail and extending the segment size if needed.
     * 
     * @return When set, Minimum Segment Size is enforced by looking ahead and back within the specified range for a
     *         nearby avail and extending the segment size if needed.
     */
    public final Integer minSegmentLength() {
        return minSegmentLength;
    }

    /**
     * Indicates whether the .m3u8 manifest file should be generated for this HLS output group.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputSelection}
     * will return {@link HlsOutputSelection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #outputSelectionAsString}.
     * </p>
     * 
     * @return Indicates whether the .m3u8 manifest file should be generated for this HLS output group.
     * @see HlsOutputSelection
     */
    public final HlsOutputSelection outputSelection() {
        return HlsOutputSelection.fromValue(outputSelection);
    }

    /**
     * Indicates whether the .m3u8 manifest file should be generated for this HLS output group.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputSelection}
     * will return {@link HlsOutputSelection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #outputSelectionAsString}.
     * </p>
     * 
     * @return Indicates whether the .m3u8 manifest file should be generated for this HLS output group.
     * @see HlsOutputSelection
     */
    public final String outputSelectionAsString() {
        return outputSelection;
    }

    /**
     * Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as follows:
     * either the program date and time are initialized using the input timecode source, or the time is initialized
     * using the input timecode source and the date is initialized using the timestamp_offset.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #programDateTime}
     * will return {@link HlsProgramDateTime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #programDateTimeAsString}.
     * </p>
     * 
     * @return Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as
     *         follows: either the program date and time are initialized using the input timecode source, or the time is
     *         initialized using the input timecode source and the date is initialized using the timestamp_offset.
     * @see HlsProgramDateTime
     */
    public final HlsProgramDateTime programDateTime() {
        return HlsProgramDateTime.fromValue(programDateTime);
    }

    /**
     * Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as follows:
     * either the program date and time are initialized using the input timecode source, or the time is initialized
     * using the input timecode source and the date is initialized using the timestamp_offset.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #programDateTime}
     * will return {@link HlsProgramDateTime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #programDateTimeAsString}.
     * </p>
     * 
     * @return Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as
     *         follows: either the program date and time are initialized using the input timecode source, or the time is
     *         initialized using the input timecode source and the date is initialized using the timestamp_offset.
     * @see HlsProgramDateTime
     */
    public final String programDateTimeAsString() {
        return programDateTime;
    }

    /**
     * Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.
     * 
     * @return Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.
     */
    public final Integer programDateTimePeriod() {
        return programDateTimePeriod;
    }

    /**
     * Specify whether MediaConvert generates HLS manifests while your job is running or when your job is complete. To
     * generate HLS manifests while your job is running: Choose Enabled. Use if you want to play back your content as
     * soon as it's available. MediaConvert writes the parent and child manifests after the first three media segments
     * are written to your destination S3 bucket. It then writes new updated manifests after each additional segment is
     * written. The parent manifest includes the latest BANDWIDTH and AVERAGE-BANDWIDTH attributes, and child manifests
     * include the latest available media segment. When your job completes, the final child playlists include an
     * EXT-X-ENDLIST tag. To generate HLS manifests only when your job completes: Choose Disabled.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #progressiveWriteHlsManifest} will return {@link HlsProgressiveWriteHlsManifest#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #progressiveWriteHlsManifestAsString}.
     * </p>
     * 
     * @return Specify whether MediaConvert generates HLS manifests while your job is running or when your job is
     *         complete. To generate HLS manifests while your job is running: Choose Enabled. Use if you want to play
     *         back your content as soon as it's available. MediaConvert writes the parent and child manifests after the
     *         first three media segments are written to your destination S3 bucket. It then writes new updated
     *         manifests after each additional segment is written. The parent manifest includes the latest BANDWIDTH and
     *         AVERAGE-BANDWIDTH attributes, and child manifests include the latest available media segment. When your
     *         job completes, the final child playlists include an EXT-X-ENDLIST tag. To generate HLS manifests only
     *         when your job completes: Choose Disabled.
     * @see HlsProgressiveWriteHlsManifest
     */
    public final HlsProgressiveWriteHlsManifest progressiveWriteHlsManifest() {
        return HlsProgressiveWriteHlsManifest.fromValue(progressiveWriteHlsManifest);
    }

    /**
     * Specify whether MediaConvert generates HLS manifests while your job is running or when your job is complete. To
     * generate HLS manifests while your job is running: Choose Enabled. Use if you want to play back your content as
     * soon as it's available. MediaConvert writes the parent and child manifests after the first three media segments
     * are written to your destination S3 bucket. It then writes new updated manifests after each additional segment is
     * written. The parent manifest includes the latest BANDWIDTH and AVERAGE-BANDWIDTH attributes, and child manifests
     * include the latest available media segment. When your job completes, the final child playlists include an
     * EXT-X-ENDLIST tag. To generate HLS manifests only when your job completes: Choose Disabled.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #progressiveWriteHlsManifest} will return {@link HlsProgressiveWriteHlsManifest#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #progressiveWriteHlsManifestAsString}.
     * </p>
     * 
     * @return Specify whether MediaConvert generates HLS manifests while your job is running or when your job is
     *         complete. To generate HLS manifests while your job is running: Choose Enabled. Use if you want to play
     *         back your content as soon as it's available. MediaConvert writes the parent and child manifests after the
     *         first three media segments are written to your destination S3 bucket. It then writes new updated
     *         manifests after each additional segment is written. The parent manifest includes the latest BANDWIDTH and
     *         AVERAGE-BANDWIDTH attributes, and child manifests include the latest available media segment. When your
     *         job completes, the final child playlists include an EXT-X-ENDLIST tag. To generate HLS manifests only
     *         when your job completes: Choose Disabled.
     * @see HlsProgressiveWriteHlsManifest
     */
    public final String progressiveWriteHlsManifestAsString() {
        return progressiveWriteHlsManifest;
    }

    /**
     * When set to SINGLE_FILE, emits program as a single media resource (.ts) file, uses #EXT-X-BYTERANGE tags to index
     * segment for playback.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentControl}
     * will return {@link HlsSegmentControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #segmentControlAsString}.
     * </p>
     * 
     * @return When set to SINGLE_FILE, emits program as a single media resource (.ts) file, uses #EXT-X-BYTERANGE tags
     *         to index segment for playback.
     * @see HlsSegmentControl
     */
    public final HlsSegmentControl segmentControl() {
        return HlsSegmentControl.fromValue(segmentControl);
    }

    /**
     * When set to SINGLE_FILE, emits program as a single media resource (.ts) file, uses #EXT-X-BYTERANGE tags to index
     * segment for playback.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #segmentControl}
     * will return {@link HlsSegmentControl#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #segmentControlAsString}.
     * </p>
     * 
     * @return When set to SINGLE_FILE, emits program as a single media resource (.ts) file, uses #EXT-X-BYTERANGE tags
     *         to index segment for playback.
     * @see HlsSegmentControl
     */
    public final String segmentControlAsString() {
        return segmentControl;
    }

    /**
     * Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert defaults to
     * 10. Related settings: Use Segment length control (SegmentLengthControl) to specify whether the encoder enforces
     * this value strictly. Use Segment control (HlsSegmentControl) to specify whether MediaConvert creates separate
     * segment files or one content file that has metadata to mark the segment boundaries.
     * 
     * @return Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert
     *         defaults to 10. Related settings: Use Segment length control (SegmentLengthControl) to specify whether
     *         the encoder enforces this value strictly. Use Segment control (HlsSegmentControl) to specify whether
     *         MediaConvert creates separate segment files or one content file that has metadata to mark the segment
     *         boundaries.
     */
    public final Integer segmentLength() {
        return segmentLength;
    }

    /**
     * Specify how you want MediaConvert to determine the segment length. Choose Exact (EXACT) to have the encoder use
     * the exact length that you specify with the setting Segment length (SegmentLength). This might result in extra
     * I-frames. Choose Multiple of GOP (GOP_MULTIPLE) to have the encoder round up the segment lengths to match the
     * next GOP boundary.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #segmentLengthControl} will return {@link HlsSegmentLengthControl#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #segmentLengthControlAsString}.
     * </p>
     * 
     * @return Specify how you want MediaConvert to determine the segment length. Choose Exact (EXACT) to have the
     *         encoder use the exact length that you specify with the setting Segment length (SegmentLength). This might
     *         result in extra I-frames. Choose Multiple of GOP (GOP_MULTIPLE) to have the encoder round up the segment
     *         lengths to match the next GOP boundary.
     * @see HlsSegmentLengthControl
     */
    public final HlsSegmentLengthControl segmentLengthControl() {
        return HlsSegmentLengthControl.fromValue(segmentLengthControl);
    }

    /**
     * Specify how you want MediaConvert to determine the segment length. Choose Exact (EXACT) to have the encoder use
     * the exact length that you specify with the setting Segment length (SegmentLength). This might result in extra
     * I-frames. Choose Multiple of GOP (GOP_MULTIPLE) to have the encoder round up the segment lengths to match the
     * next GOP boundary.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #segmentLengthControl} will return {@link HlsSegmentLengthControl#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #segmentLengthControlAsString}.
     * </p>
     * 
     * @return Specify how you want MediaConvert to determine the segment length. Choose Exact (EXACT) to have the
     *         encoder use the exact length that you specify with the setting Segment length (SegmentLength). This might
     *         result in extra I-frames. Choose Multiple of GOP (GOP_MULTIPLE) to have the encoder round up the segment
     *         lengths to match the next GOP boundary.
     * @see HlsSegmentLengthControl
     */
    public final String segmentLengthControlAsString() {
        return segmentLengthControl;
    }

    /**
     * Specify the number of segments to write to a subdirectory before starting a new one. You must also set Directory
     * structure to Subdirectory per stream for this setting to have an effect.
     * 
     * @return Specify the number of segments to write to a subdirectory before starting a new one. You must also set
     *         Directory structure to Subdirectory per stream for this setting to have an effect.
     */
    public final Integer segmentsPerSubdirectory() {
        return segmentsPerSubdirectory;
    }

    /**
     * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #streamInfResolution} will return {@link HlsStreamInfResolution#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #streamInfResolutionAsString}.
     * </p>
     * 
     * @return Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * @see HlsStreamInfResolution
     */
    public final HlsStreamInfResolution streamInfResolution() {
        return HlsStreamInfResolution.fromValue(streamInfResolution);
    }

    /**
     * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #streamInfResolution} will return {@link HlsStreamInfResolution#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #streamInfResolutionAsString}.
     * </p>
     * 
     * @return Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
     * @see HlsStreamInfResolution
     */
    public final String streamInfResolutionAsString() {
        return streamInfResolution;
    }

    /**
     * When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above its
     * current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to the nearest
     * integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down if less than 0.5 (<
     * 0.5). You may need to use LEGACY if your client needs to ensure that the target duration is always longer than
     * the actual duration of the segment. Some older players may experience interrupted playback when the actual
     * duration of a track in a segment is longer than the target duration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetDurationCompatibilityMode} will return
     * {@link HlsTargetDurationCompatibilityMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetDurationCompatibilityModeAsString}.
     * </p>
     * 
     * @return When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above
     *         its current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to
     *         the nearest integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down
     *         if less than 0.5 (< 0.5). You may need to use LEGACY if your client needs to ensure that the target
     *         duration is always longer than the actual duration of the segment. Some older players may experience
     *         interrupted playback when the actual duration of a track in a segment is longer than the target duration.
     * @see HlsTargetDurationCompatibilityMode
     */
    public final HlsTargetDurationCompatibilityMode targetDurationCompatibilityMode() {
        return HlsTargetDurationCompatibilityMode.fromValue(targetDurationCompatibilityMode);
    }

    /**
     * When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above its
     * current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to the nearest
     * integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down if less than 0.5 (<
     * 0.5). You may need to use LEGACY if your client needs to ensure that the target duration is always longer than
     * the actual duration of the segment. Some older players may experience interrupted playback when the actual
     * duration of a track in a segment is longer than the target duration.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetDurationCompatibilityMode} will return
     * {@link HlsTargetDurationCompatibilityMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetDurationCompatibilityModeAsString}.
     * </p>
     * 
     * @return When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above
     *         its current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to
     *         the nearest integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down
     *         if less than 0.5 (< 0.5). You may need to use LEGACY if your client needs to ensure that the target
     *         duration is always longer than the actual duration of the segment. Some older players may experience
     *         interrupted playback when the actual duration of a track in a segment is longer than the target duration.
     * @see HlsTargetDurationCompatibilityMode
     */
    public final String targetDurationCompatibilityModeAsString() {
        return targetDurationCompatibilityMode;
    }

    /**
     * Specify the type of the ID3 frame (timedMetadataId3Frame) to use for ID3 timestamps (timedMetadataId3Period) in
     * your output. To include ID3 timestamps: Specify PRIV (PRIV) or TDRL (TDRL) and set ID3 metadata (timedMetadata)
     * to Passthrough (PASSTHROUGH). To exclude ID3 timestamps: Set ID3 timestamp frame type to None (NONE).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #timedMetadataId3Frame} will return {@link HlsTimedMetadataId3Frame#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #timedMetadataId3FrameAsString}.
     * </p>
     * 
     * @return Specify the type of the ID3 frame (timedMetadataId3Frame) to use for ID3 timestamps
     *         (timedMetadataId3Period) in your output. To include ID3 timestamps: Specify PRIV (PRIV) or TDRL (TDRL)
     *         and set ID3 metadata (timedMetadata) to Passthrough (PASSTHROUGH). To exclude ID3 timestamps: Set ID3
     *         timestamp frame type to None (NONE).
     * @see HlsTimedMetadataId3Frame
     */
    public final HlsTimedMetadataId3Frame timedMetadataId3Frame() {
        return HlsTimedMetadataId3Frame.fromValue(timedMetadataId3Frame);
    }

    /**
     * Specify the type of the ID3 frame (timedMetadataId3Frame) to use for ID3 timestamps (timedMetadataId3Period) in
     * your output. To include ID3 timestamps: Specify PRIV (PRIV) or TDRL (TDRL) and set ID3 metadata (timedMetadata)
     * to Passthrough (PASSTHROUGH). To exclude ID3 timestamps: Set ID3 timestamp frame type to None (NONE).
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #timedMetadataId3Frame} will return {@link HlsTimedMetadataId3Frame#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #timedMetadataId3FrameAsString}.
     * </p>
     * 
     * @return Specify the type of the ID3 frame (timedMetadataId3Frame) to use for ID3 timestamps
     *         (timedMetadataId3Period) in your output. To include ID3 timestamps: Specify PRIV (PRIV) or TDRL (TDRL)
     *         and set ID3 metadata (timedMetadata) to Passthrough (PASSTHROUGH). To exclude ID3 timestamps: Set ID3
     *         timestamp frame type to None (NONE).
     * @see HlsTimedMetadataId3Frame
     */
    public final String timedMetadataId3FrameAsString() {
        return timedMetadataId3Frame;
    }

    /**
     * Specify the interval in seconds to write ID3 timestamps in your output. The first timestamp starts at the output
     * timecode and date, and increases incrementally with each ID3 timestamp. To use the default interval of 10
     * seconds: Leave blank. To include this metadata in your output: Set ID3 timestamp frame type
     * (timedMetadataId3Frame) to PRIV (PRIV) or TDRL (TDRL), and set ID3 metadata (timedMetadata) to Passthrough
     * (PASSTHROUGH).
     * 
     * @return Specify the interval in seconds to write ID3 timestamps in your output. The first timestamp starts at the
     *         output timecode and date, and increases incrementally with each ID3 timestamp. To use the default
     *         interval of 10 seconds: Leave blank. To include this metadata in your output: Set ID3 timestamp frame
     *         type (timedMetadataId3Frame) to PRIV (PRIV) or TDRL (TDRL), and set ID3 metadata (timedMetadata) to
     *         Passthrough (PASSTHROUGH).
     */
    public final Integer timedMetadataId3Period() {
        return timedMetadataId3Period;
    }

    /**
     * Provides an extra millisecond delta offset to fine tune the timestamps.
     * 
     * @return Provides an extra millisecond delta offset to fine tune the timestamps.
     */
    public final Integer timestampDeltaMilliseconds() {
        return timestampDeltaMilliseconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdMarkers() ? adMarkersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalManifests() ? additionalManifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(audioOnlyHeaderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(baseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasCaptionLanguageMappings() ? captionLanguageMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(captionLanguageSettingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(captionSegmentLengthControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientCacheAsString());
        hashCode = 31 * hashCode + Objects.hashCode(codecSpecificationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(destinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(directoryStructureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(encryption());
        hashCode = 31 * hashCode + Objects.hashCode(imageBasedTrickPlayAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageBasedTrickPlaySettings());
        hashCode = 31 * hashCode + Objects.hashCode(manifestCompressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(manifestDurationFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(minFinalSegmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(minSegmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(outputSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(programDateTimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(programDateTimePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(progressiveWriteHlsManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segmentControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(segmentLengthControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(segmentsPerSubdirectory());
        hashCode = 31 * hashCode + Objects.hashCode(streamInfResolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetDurationCompatibilityModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timedMetadataId3FrameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timedMetadataId3Period());
        hashCode = 31 * hashCode + Objects.hashCode(timestampDeltaMilliseconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsGroupSettings)) {
            return false;
        }
        HlsGroupSettings other = (HlsGroupSettings) obj;
        return hasAdMarkers() == other.hasAdMarkers() && Objects.equals(adMarkersAsStrings(), other.adMarkersAsStrings())
                && hasAdditionalManifests() == other.hasAdditionalManifests()
                && Objects.equals(additionalManifests(), other.additionalManifests())
                && Objects.equals(audioOnlyHeaderAsString(), other.audioOnlyHeaderAsString())
                && Objects.equals(baseUrl(), other.baseUrl())
                && hasCaptionLanguageMappings() == other.hasCaptionLanguageMappings()
                && Objects.equals(captionLanguageMappings(), other.captionLanguageMappings())
                && Objects.equals(captionLanguageSettingAsString(), other.captionLanguageSettingAsString())
                && Objects.equals(captionSegmentLengthControlAsString(), other.captionSegmentLengthControlAsString())
                && Objects.equals(clientCacheAsString(), other.clientCacheAsString())
                && Objects.equals(codecSpecificationAsString(), other.codecSpecificationAsString())
                && Objects.equals(destination(), other.destination())
                && Objects.equals(destinationSettings(), other.destinationSettings())
                && Objects.equals(directoryStructureAsString(), other.directoryStructureAsString())
                && Objects.equals(encryption(), other.encryption())
                && Objects.equals(imageBasedTrickPlayAsString(), other.imageBasedTrickPlayAsString())
                && Objects.equals(imageBasedTrickPlaySettings(), other.imageBasedTrickPlaySettings())
                && Objects.equals(manifestCompressionAsString(), other.manifestCompressionAsString())
                && Objects.equals(manifestDurationFormatAsString(), other.manifestDurationFormatAsString())
                && Objects.equals(minFinalSegmentLength(), other.minFinalSegmentLength())
                && Objects.equals(minSegmentLength(), other.minSegmentLength())
                && Objects.equals(outputSelectionAsString(), other.outputSelectionAsString())
                && Objects.equals(programDateTimeAsString(), other.programDateTimeAsString())
                && Objects.equals(programDateTimePeriod(), other.programDateTimePeriod())
                && Objects.equals(progressiveWriteHlsManifestAsString(), other.progressiveWriteHlsManifestAsString())
                && Objects.equals(segmentControlAsString(), other.segmentControlAsString())
                && Objects.equals(segmentLength(), other.segmentLength())
                && Objects.equals(segmentLengthControlAsString(), other.segmentLengthControlAsString())
                && Objects.equals(segmentsPerSubdirectory(), other.segmentsPerSubdirectory())
                && Objects.equals(streamInfResolutionAsString(), other.streamInfResolutionAsString())
                && Objects.equals(targetDurationCompatibilityModeAsString(), other.targetDurationCompatibilityModeAsString())
                && Objects.equals(timedMetadataId3FrameAsString(), other.timedMetadataId3FrameAsString())
                && Objects.equals(timedMetadataId3Period(), other.timedMetadataId3Period())
                && Objects.equals(timestampDeltaMilliseconds(), other.timestampDeltaMilliseconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HlsGroupSettings").add("AdMarkers", hasAdMarkers() ? adMarkersAsStrings() : null)
                .add("AdditionalManifests", hasAdditionalManifests() ? additionalManifests() : null)
                .add("AudioOnlyHeader", audioOnlyHeaderAsString()).add("BaseUrl", baseUrl())
                .add("CaptionLanguageMappings", hasCaptionLanguageMappings() ? captionLanguageMappings() : null)
                .add("CaptionLanguageSetting", captionLanguageSettingAsString())
                .add("CaptionSegmentLengthControl", captionSegmentLengthControlAsString())
                .add("ClientCache", clientCacheAsString()).add("CodecSpecification", codecSpecificationAsString())
                .add("Destination", destination()).add("DestinationSettings", destinationSettings())
                .add("DirectoryStructure", directoryStructureAsString()).add("Encryption", encryption())
                .add("ImageBasedTrickPlay", imageBasedTrickPlayAsString())
                .add("ImageBasedTrickPlaySettings", imageBasedTrickPlaySettings())
                .add("ManifestCompression", manifestCompressionAsString())
                .add("ManifestDurationFormat", manifestDurationFormatAsString())
                .add("MinFinalSegmentLength", minFinalSegmentLength()).add("MinSegmentLength", minSegmentLength())
                .add("OutputSelection", outputSelectionAsString()).add("ProgramDateTime", programDateTimeAsString())
                .add("ProgramDateTimePeriod", programDateTimePeriod())
                .add("ProgressiveWriteHlsManifest", progressiveWriteHlsManifestAsString())
                .add("SegmentControl", segmentControlAsString()).add("SegmentLength", segmentLength())
                .add("SegmentLengthControl", segmentLengthControlAsString())
                .add("SegmentsPerSubdirectory", segmentsPerSubdirectory())
                .add("StreamInfResolution", streamInfResolutionAsString())
                .add("TargetDurationCompatibilityMode", targetDurationCompatibilityModeAsString())
                .add("TimedMetadataId3Frame", timedMetadataId3FrameAsString())
                .add("TimedMetadataId3Period", timedMetadataId3Period())
                .add("TimestampDeltaMilliseconds", timestampDeltaMilliseconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdMarkers":
            return Optional.ofNullable(clazz.cast(adMarkersAsStrings()));
        case "AdditionalManifests":
            return Optional.ofNullable(clazz.cast(additionalManifests()));
        case "AudioOnlyHeader":
            return Optional.ofNullable(clazz.cast(audioOnlyHeaderAsString()));
        case "BaseUrl":
            return Optional.ofNullable(clazz.cast(baseUrl()));
        case "CaptionLanguageMappings":
            return Optional.ofNullable(clazz.cast(captionLanguageMappings()));
        case "CaptionLanguageSetting":
            return Optional.ofNullable(clazz.cast(captionLanguageSettingAsString()));
        case "CaptionSegmentLengthControl":
            return Optional.ofNullable(clazz.cast(captionSegmentLengthControlAsString()));
        case "ClientCache":
            return Optional.ofNullable(clazz.cast(clientCacheAsString()));
        case "CodecSpecification":
            return Optional.ofNullable(clazz.cast(codecSpecificationAsString()));
        case "Destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "DestinationSettings":
            return Optional.ofNullable(clazz.cast(destinationSettings()));
        case "DirectoryStructure":
            return Optional.ofNullable(clazz.cast(directoryStructureAsString()));
        case "Encryption":
            return Optional.ofNullable(clazz.cast(encryption()));
        case "ImageBasedTrickPlay":
            return Optional.ofNullable(clazz.cast(imageBasedTrickPlayAsString()));
        case "ImageBasedTrickPlaySettings":
            return Optional.ofNullable(clazz.cast(imageBasedTrickPlaySettings()));
        case "ManifestCompression":
            return Optional.ofNullable(clazz.cast(manifestCompressionAsString()));
        case "ManifestDurationFormat":
            return Optional.ofNullable(clazz.cast(manifestDurationFormatAsString()));
        case "MinFinalSegmentLength":
            return Optional.ofNullable(clazz.cast(minFinalSegmentLength()));
        case "MinSegmentLength":
            return Optional.ofNullable(clazz.cast(minSegmentLength()));
        case "OutputSelection":
            return Optional.ofNullable(clazz.cast(outputSelectionAsString()));
        case "ProgramDateTime":
            return Optional.ofNullable(clazz.cast(programDateTimeAsString()));
        case "ProgramDateTimePeriod":
            return Optional.ofNullable(clazz.cast(programDateTimePeriod()));
        case "ProgressiveWriteHlsManifest":
            return Optional.ofNullable(clazz.cast(progressiveWriteHlsManifestAsString()));
        case "SegmentControl":
            return Optional.ofNullable(clazz.cast(segmentControlAsString()));
        case "SegmentLength":
            return Optional.ofNullable(clazz.cast(segmentLength()));
        case "SegmentLengthControl":
            return Optional.ofNullable(clazz.cast(segmentLengthControlAsString()));
        case "SegmentsPerSubdirectory":
            return Optional.ofNullable(clazz.cast(segmentsPerSubdirectory()));
        case "StreamInfResolution":
            return Optional.ofNullable(clazz.cast(streamInfResolutionAsString()));
        case "TargetDurationCompatibilityMode":
            return Optional.ofNullable(clazz.cast(targetDurationCompatibilityModeAsString()));
        case "TimedMetadataId3Frame":
            return Optional.ofNullable(clazz.cast(timedMetadataId3FrameAsString()));
        case "TimedMetadataId3Period":
            return Optional.ofNullable(clazz.cast(timedMetadataId3Period()));
        case "TimestampDeltaMilliseconds":
            return Optional.ofNullable(clazz.cast(timestampDeltaMilliseconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsGroupSettings, T> g) {
        return obj -> g.apply((HlsGroupSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsGroupSettings> {
        /**
         * Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not determine
         * whether SCTE-35 markers appear in the outputs themselves.
         * 
         * @param adMarkers
         *        Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not
         *        determine whether SCTE-35 markers appear in the outputs themselves.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adMarkersWithStrings(Collection<String> adMarkers);

        /**
         * Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not determine
         * whether SCTE-35 markers appear in the outputs themselves.
         * 
         * @param adMarkers
         *        Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not
         *        determine whether SCTE-35 markers appear in the outputs themselves.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adMarkersWithStrings(String... adMarkers);

        /**
         * Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not determine
         * whether SCTE-35 markers appear in the outputs themselves.
         * 
         * @param adMarkers
         *        Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not
         *        determine whether SCTE-35 markers appear in the outputs themselves.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adMarkers(Collection<HlsAdMarkers> adMarkers);

        /**
         * Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not determine
         * whether SCTE-35 markers appear in the outputs themselves.
         * 
         * @param adMarkers
         *        Choose one or more ad marker types to decorate your Apple HLS manifest. This setting does not
         *        determine whether SCTE-35 markers appear in the outputs themselves.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adMarkers(HlsAdMarkers... adMarkers);

        /**
         * By default, the service creates one top-level .m3u8 HLS manifest for each HLS output group in your job. This
         * default manifest references every output in the output group. To create additional top-level manifests that
         * reference a subset of the outputs in the output group, specify a list of them here.
         * 
         * @param additionalManifests
         *        By default, the service creates one top-level .m3u8 HLS manifest for each HLS output group in your
         *        job. This default manifest references every output in the output group. To create additional top-level
         *        manifests that reference a subset of the outputs in the output group, specify a list of them here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalManifests(Collection<HlsAdditionalManifest> additionalManifests);

        /**
         * By default, the service creates one top-level .m3u8 HLS manifest for each HLS output group in your job. This
         * default manifest references every output in the output group. To create additional top-level manifests that
         * reference a subset of the outputs in the output group, specify a list of them here.
         * 
         * @param additionalManifests
         *        By default, the service creates one top-level .m3u8 HLS manifest for each HLS output group in your
         *        job. This default manifest references every output in the output group. To create additional top-level
         *        manifests that reference a subset of the outputs in the output group, specify a list of them here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalManifests(HlsAdditionalManifest... additionalManifests);

        /**
         * By default, the service creates one top-level .m3u8 HLS manifest for each HLS output group in your job. This
         * default manifest references every output in the output group. To create additional top-level manifests that
         * reference a subset of the outputs in the output group, specify a list of them here. This is a convenience
         * method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconvert.model.HlsAdditionalManifest.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.mediaconvert.model.HlsAdditionalManifest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconvert.model.HlsAdditionalManifest.Builder#build()} is called
         * immediately and its result is passed to {@link #additionalManifests(List<HlsAdditionalManifest>)}.
         * 
         * @param additionalManifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconvert.model.HlsAdditionalManifest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalManifests(java.util.Collection<HlsAdditionalManifest>)
         */
        Builder additionalManifests(Consumer<HlsAdditionalManifest.Builder>... additionalManifests);

        /**
         * Ignore this setting unless you are using FairPlay DRM with Verimatrix and you encounter playback issues. Keep
         * the default value, Include (INCLUDE), to output audio-only headers. Choose Exclude (EXCLUDE) to remove the
         * audio-only headers from your audio segments.
         * 
         * @param audioOnlyHeader
         *        Ignore this setting unless you are using FairPlay DRM with Verimatrix and you encounter playback
         *        issues. Keep the default value, Include (INCLUDE), to output audio-only headers. Choose Exclude
         *        (EXCLUDE) to remove the audio-only headers from your audio segments.
         * @see HlsAudioOnlyHeader
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsAudioOnlyHeader
         */
        Builder audioOnlyHeader(String audioOnlyHeader);

        /**
         * Ignore this setting unless you are using FairPlay DRM with Verimatrix and you encounter playback issues. Keep
         * the default value, Include (INCLUDE), to output audio-only headers. Choose Exclude (EXCLUDE) to remove the
         * audio-only headers from your audio segments.
         * 
         * @param audioOnlyHeader
         *        Ignore this setting unless you are using FairPlay DRM with Verimatrix and you encounter playback
         *        issues. Keep the default value, Include (INCLUDE), to output audio-only headers. Choose Exclude
         *        (EXCLUDE) to remove the audio-only headers from your audio segments.
         * @see HlsAudioOnlyHeader
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsAudioOnlyHeader
         */
        Builder audioOnlyHeader(HlsAudioOnlyHeader audioOnlyHeader);

        /**
         * A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if base
         * manifest is delivered from a different URL than the main .m3u8 file.
         * 
         * @param baseUrl
         *        A partial URI prefix that will be prepended to each output in the media .m3u8 file. Can be used if
         *        base manifest is delivered from a different URL than the main .m3u8 file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseUrl(String baseUrl);

        /**
         * Language to be used on Caption outputs
         * 
         * @param captionLanguageMappings
         *        Language to be used on Caption outputs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionLanguageMappings(Collection<HlsCaptionLanguageMapping> captionLanguageMappings);

        /**
         * Language to be used on Caption outputs
         * 
         * @param captionLanguageMappings
         *        Language to be used on Caption outputs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captionLanguageMappings(HlsCaptionLanguageMapping... captionLanguageMappings);

        /**
         * Language to be used on Caption outputs This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediaconvert.model.HlsCaptionLanguageMapping.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.mediaconvert.model.HlsCaptionLanguageMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediaconvert.model.HlsCaptionLanguageMapping.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #captionLanguageMappings(List<HlsCaptionLanguageMapping>)}.
         * 
         * @param captionLanguageMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediaconvert.model.HlsCaptionLanguageMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #captionLanguageMappings(java.util.Collection<HlsCaptionLanguageMapping>)
         */
        Builder captionLanguageMappings(Consumer<HlsCaptionLanguageMapping.Builder>... captionLanguageMappings);

        /**
         * Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest. Specify
         * at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code
         * you specify. Make sure to specify the languages in the order in which they appear in the original source (if
         * the source is embedded format) or the order of the caption selectors (if the source is other than embedded).
         * Otherwise, languages in the manifest will not match up properly with the output captions. None: Include
         * CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any CLOSED-CAPTIONS line from the manifest.
         * 
         * @param captionLanguageSetting
         *        Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest.
         *        Specify at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for
         *        each Language Code you specify. Make sure to specify the languages in the order in which they appear
         *        in the original source (if the source is embedded format) or the order of the caption selectors (if
         *        the source is other than embedded). Otherwise, languages in the manifest will not match up properly
         *        with the output captions. None: Include CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any
         *        CLOSED-CAPTIONS line from the manifest.
         * @see HlsCaptionLanguageSetting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsCaptionLanguageSetting
         */
        Builder captionLanguageSetting(String captionLanguageSetting);

        /**
         * Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest. Specify
         * at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for each Language Code
         * you specify. Make sure to specify the languages in the order in which they appear in the original source (if
         * the source is embedded format) or the order of the caption selectors (if the source is other than embedded).
         * Otherwise, languages in the manifest will not match up properly with the output captions. None: Include
         * CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any CLOSED-CAPTIONS line from the manifest.
         * 
         * @param captionLanguageSetting
         *        Applies only to 608 Embedded output captions. Insert: Include CLOSED-CAPTIONS lines in the manifest.
         *        Specify at least one language in the CC1 Language Code field. One CLOSED-CAPTION line is added for
         *        each Language Code you specify. Make sure to specify the languages in the order in which they appear
         *        in the original source (if the source is embedded format) or the order of the caption selectors (if
         *        the source is other than embedded). Otherwise, languages in the manifest will not match up properly
         *        with the output captions. None: Include CLOSED-CAPTIONS=NONE line in the manifest. Omit: Omit any
         *        CLOSED-CAPTIONS line from the manifest.
         * @see HlsCaptionLanguageSetting
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsCaptionLanguageSetting
         */
        Builder captionLanguageSetting(HlsCaptionLanguageSetting captionLanguageSetting);

        /**
         * Set Caption segment length control (CaptionSegmentLengthControl) to Match video (MATCH_VIDEO) to create
         * caption segments that align with the video segments from the first video output in this output group. For
         * example, if the video segments are 2 seconds long, your WebVTT segments will also be 2 seconds long. Keep the
         * default setting, Large segments (LARGE_SEGMENTS) to create caption segments that are 300 seconds long.
         * 
         * @param captionSegmentLengthControl
         *        Set Caption segment length control (CaptionSegmentLengthControl) to Match video (MATCH_VIDEO) to
         *        create caption segments that align with the video segments from the first video output in this output
         *        group. For example, if the video segments are 2 seconds long, your WebVTT segments will also be 2
         *        seconds long. Keep the default setting, Large segments (LARGE_SEGMENTS) to create caption segments
         *        that are 300 seconds long.
         * @see HlsCaptionSegmentLengthControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsCaptionSegmentLengthControl
         */
        Builder captionSegmentLengthControl(String captionSegmentLengthControl);

        /**
         * Set Caption segment length control (CaptionSegmentLengthControl) to Match video (MATCH_VIDEO) to create
         * caption segments that align with the video segments from the first video output in this output group. For
         * example, if the video segments are 2 seconds long, your WebVTT segments will also be 2 seconds long. Keep the
         * default setting, Large segments (LARGE_SEGMENTS) to create caption segments that are 300 seconds long.
         * 
         * @param captionSegmentLengthControl
         *        Set Caption segment length control (CaptionSegmentLengthControl) to Match video (MATCH_VIDEO) to
         *        create caption segments that align with the video segments from the first video output in this output
         *        group. For example, if the video segments are 2 seconds long, your WebVTT segments will also be 2
         *        seconds long. Keep the default setting, Large segments (LARGE_SEGMENTS) to create caption segments
         *        that are 300 seconds long.
         * @see HlsCaptionSegmentLengthControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsCaptionSegmentLengthControl
         */
        Builder captionSegmentLengthControl(HlsCaptionSegmentLengthControl captionSegmentLengthControl);

        /**
         * Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the
         * default value Enabled (ENABLED) and control caching in your video distribution set up. For example, use the
         * Cache-Control http header.
         * 
         * @param clientCache
         *        Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep
         *        the default value Enabled (ENABLED) and control caching in your video distribution set up. For
         *        example, use the Cache-Control http header.
         * @see HlsClientCache
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsClientCache
         */
        Builder clientCache(String clientCache);

        /**
         * Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep the
         * default value Enabled (ENABLED) and control caching in your video distribution set up. For example, use the
         * Cache-Control http header.
         * 
         * @param clientCache
         *        Disable this setting only when your workflow requires the #EXT-X-ALLOW-CACHE:no tag. Otherwise, keep
         *        the default value Enabled (ENABLED) and control caching in your video distribution set up. For
         *        example, use the Cache-Control http header.
         * @see HlsClientCache
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsClientCache
         */
        Builder clientCache(HlsClientCache clientCache);

        /**
         * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         * 
         * @param codecSpecification
         *        Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         * @see HlsCodecSpecification
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsCodecSpecification
         */
        Builder codecSpecification(String codecSpecification);

        /**
         * Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         * 
         * @param codecSpecification
         *        Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist generation.
         * @see HlsCodecSpecification
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsCodecSpecification
         */
        Builder codecSpecification(HlsCodecSpecification codecSpecification);

        /**
         * Use Destination (Destination) to specify the S3 output location and the output filename base. Destination
         * accepts format identifiers. If you do not specify the base filename in the URI, the service will use the
         * filename of the input file. If your job has multiple inputs, the service uses the filename of the first input
         * file.
         * 
         * @param destination
         *        Use Destination (Destination) to specify the S3 output location and the output filename base.
         *        Destination accepts format identifiers. If you do not specify the base filename in the URI, the
         *        service will use the filename of the input file. If your job has multiple inputs, the service uses the
         *        filename of the first input file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * Settings associated with the destination. Will vary based on the type of destination
         * 
         * @param destinationSettings
         *        Settings associated with the destination. Will vary based on the type of destination
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationSettings(DestinationSettings destinationSettings);

        /**
         * Settings associated with the destination. Will vary based on the type of destination This is a convenience
         * method that creates an instance of the {@link DestinationSettings.Builder} avoiding the need to create one
         * manually via {@link DestinationSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DestinationSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #destinationSettings(DestinationSettings)}.
         * 
         * @param destinationSettings
         *        a consumer that will call methods on {@link DestinationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationSettings(DestinationSettings)
         */
        default Builder destinationSettings(Consumer<DestinationSettings.Builder> destinationSettings) {
            return destinationSettings(DestinationSettings.builder().applyMutation(destinationSettings).build());
        }

        /**
         * Indicates whether segments should be placed in subdirectories.
         * 
         * @param directoryStructure
         *        Indicates whether segments should be placed in subdirectories.
         * @see HlsDirectoryStructure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsDirectoryStructure
         */
        Builder directoryStructure(String directoryStructure);

        /**
         * Indicates whether segments should be placed in subdirectories.
         * 
         * @param directoryStructure
         *        Indicates whether segments should be placed in subdirectories.
         * @see HlsDirectoryStructure
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsDirectoryStructure
         */
        Builder directoryStructure(HlsDirectoryStructure directoryStructure);

        /**
         * DRM settings.
         * 
         * @param encryption
         *        DRM settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryption(HlsEncryptionSettings encryption);

        /**
         * DRM settings. This is a convenience method that creates an instance of the
         * {@link HlsEncryptionSettings.Builder} avoiding the need to create one manually via
         * {@link HlsEncryptionSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HlsEncryptionSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #encryption(HlsEncryptionSettings)}.
         * 
         * @param encryption
         *        a consumer that will call methods on {@link HlsEncryptionSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryption(HlsEncryptionSettings)
         */
        default Builder encryption(Consumer<HlsEncryptionSettings.Builder> encryption) {
            return encryption(HlsEncryptionSettings.builder().applyMutation(encryption).build());
        }

        /**
         * Specify whether MediaConvert generates images for trick play. Keep the default value, None (NONE), to not
         * generate any images. Choose Thumbnail (THUMBNAIL) to generate tiled thumbnails. Choose Thumbnail and full
         * frame (THUMBNAIL_AND_FULLFRAME) to generate tiled thumbnails and full-resolution images of single frames.
         * MediaConvert creates a child manifest for each set of images that you generate and adds corresponding entries
         * to the parent manifest. A common application for these images is Roku trick mode. The thumbnails and
         * full-frame images that MediaConvert creates with this feature are compatible with this Roku specification:
         * https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
         * 
         * @param imageBasedTrickPlay
         *        Specify whether MediaConvert generates images for trick play. Keep the default value, None (NONE), to
         *        not generate any images. Choose Thumbnail (THUMBNAIL) to generate tiled thumbnails. Choose Thumbnail
         *        and full frame (THUMBNAIL_AND_FULLFRAME) to generate tiled thumbnails and full-resolution images of
         *        single frames. MediaConvert creates a child manifest for each set of images that you generate and adds
         *        corresponding entries to the parent manifest. A common application for these images is Roku trick
         *        mode. The thumbnails and full-frame images that MediaConvert creates with this feature are compatible
         *        with this Roku specification:
         *        https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
         * @see HlsImageBasedTrickPlay
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsImageBasedTrickPlay
         */
        Builder imageBasedTrickPlay(String imageBasedTrickPlay);

        /**
         * Specify whether MediaConvert generates images for trick play. Keep the default value, None (NONE), to not
         * generate any images. Choose Thumbnail (THUMBNAIL) to generate tiled thumbnails. Choose Thumbnail and full
         * frame (THUMBNAIL_AND_FULLFRAME) to generate tiled thumbnails and full-resolution images of single frames.
         * MediaConvert creates a child manifest for each set of images that you generate and adds corresponding entries
         * to the parent manifest. A common application for these images is Roku trick mode. The thumbnails and
         * full-frame images that MediaConvert creates with this feature are compatible with this Roku specification:
         * https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
         * 
         * @param imageBasedTrickPlay
         *        Specify whether MediaConvert generates images for trick play. Keep the default value, None (NONE), to
         *        not generate any images. Choose Thumbnail (THUMBNAIL) to generate tiled thumbnails. Choose Thumbnail
         *        and full frame (THUMBNAIL_AND_FULLFRAME) to generate tiled thumbnails and full-resolution images of
         *        single frames. MediaConvert creates a child manifest for each set of images that you generate and adds
         *        corresponding entries to the parent manifest. A common application for these images is Roku trick
         *        mode. The thumbnails and full-frame images that MediaConvert creates with this feature are compatible
         *        with this Roku specification:
         *        https://developer.roku.com/docs/developer-program/media-playback/trick-mode/hls-and-dash.md
         * @see HlsImageBasedTrickPlay
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsImageBasedTrickPlay
         */
        Builder imageBasedTrickPlay(HlsImageBasedTrickPlay imageBasedTrickPlay);

        /**
         * Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
         * 
         * @param imageBasedTrickPlaySettings
         *        Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageBasedTrickPlaySettings(HlsImageBasedTrickPlaySettings imageBasedTrickPlaySettings);

        /**
         * Tile and thumbnail settings applicable when imageBasedTrickPlay is ADVANCED This is a convenience method that
         * creates an instance of the {@link HlsImageBasedTrickPlaySettings.Builder} avoiding the need to create one
         * manually via {@link HlsImageBasedTrickPlaySettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HlsImageBasedTrickPlaySettings.Builder#build()} is called
         * immediately and its result is passed to {@link #imageBasedTrickPlaySettings(HlsImageBasedTrickPlaySettings)}.
         * 
         * @param imageBasedTrickPlaySettings
         *        a consumer that will call methods on {@link HlsImageBasedTrickPlaySettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageBasedTrickPlaySettings(HlsImageBasedTrickPlaySettings)
         */
        default Builder imageBasedTrickPlaySettings(Consumer<HlsImageBasedTrickPlaySettings.Builder> imageBasedTrickPlaySettings) {
            return imageBasedTrickPlaySettings(HlsImageBasedTrickPlaySettings.builder()
                    .applyMutation(imageBasedTrickPlaySettings).build());
        }

        /**
         * When set to GZIP, compresses HLS playlist.
         * 
         * @param manifestCompression
         *        When set to GZIP, compresses HLS playlist.
         * @see HlsManifestCompression
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsManifestCompression
         */
        Builder manifestCompression(String manifestCompression);

        /**
         * When set to GZIP, compresses HLS playlist.
         * 
         * @param manifestCompression
         *        When set to GZIP, compresses HLS playlist.
         * @see HlsManifestCompression
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsManifestCompression
         */
        Builder manifestCompression(HlsManifestCompression manifestCompression);

        /**
         * Indicates whether the output manifest should use floating point values for segment duration.
         * 
         * @param manifestDurationFormat
         *        Indicates whether the output manifest should use floating point values for segment duration.
         * @see HlsManifestDurationFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsManifestDurationFormat
         */
        Builder manifestDurationFormat(String manifestDurationFormat);

        /**
         * Indicates whether the output manifest should use floating point values for segment duration.
         * 
         * @param manifestDurationFormat
         *        Indicates whether the output manifest should use floating point values for segment duration.
         * @see HlsManifestDurationFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsManifestDurationFormat
         */
        Builder manifestDurationFormat(HlsManifestDurationFormat manifestDurationFormat);

        /**
         * Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices play
         * back the end of your video asset. If you know that player devices are hanging on the final segment of your
         * video because the length of your final segment is too short, use this setting to specify a minimum final
         * segment length, in seconds. Choose a value that is greater than or equal to 1 and less than your segment
         * length. When you specify a value for this setting, the encoder will combine any final segment that is shorter
         * than the length that you specify with the previous segment. For example, your segment length is 3 seconds and
         * your final segment is .5 seconds without a minimum final segment length; when you set the minimum final
         * segment length to 1, your final segment is 3.5 seconds.
         * 
         * @param minFinalSegmentLength
         *        Keep this setting at the default value of 0, unless you are troubleshooting a problem with how devices
         *        play back the end of your video asset. If you know that player devices are hanging on the final
         *        segment of your video because the length of your final segment is too short, use this setting to
         *        specify a minimum final segment length, in seconds. Choose a value that is greater than or equal to 1
         *        and less than your segment length. When you specify a value for this setting, the encoder will combine
         *        any final segment that is shorter than the length that you specify with the previous segment. For
         *        example, your segment length is 3 seconds and your final segment is .5 seconds without a minimum final
         *        segment length; when you set the minimum final segment length to 1, your final segment is 3.5 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minFinalSegmentLength(Double minFinalSegmentLength);

        /**
         * When set, Minimum Segment Size is enforced by looking ahead and back within the specified range for a nearby
         * avail and extending the segment size if needed.
         * 
         * @param minSegmentLength
         *        When set, Minimum Segment Size is enforced by looking ahead and back within the specified range for a
         *        nearby avail and extending the segment size if needed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSegmentLength(Integer minSegmentLength);

        /**
         * Indicates whether the .m3u8 manifest file should be generated for this HLS output group.
         * 
         * @param outputSelection
         *        Indicates whether the .m3u8 manifest file should be generated for this HLS output group.
         * @see HlsOutputSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsOutputSelection
         */
        Builder outputSelection(String outputSelection);

        /**
         * Indicates whether the .m3u8 manifest file should be generated for this HLS output group.
         * 
         * @param outputSelection
         *        Indicates whether the .m3u8 manifest file should be generated for this HLS output group.
         * @see HlsOutputSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsOutputSelection
         */
        Builder outputSelection(HlsOutputSelection outputSelection);

        /**
         * Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as follows:
         * either the program date and time are initialized using the input timecode source, or the time is initialized
         * using the input timecode source and the date is initialized using the timestamp_offset.
         * 
         * @param programDateTime
         *        Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as
         *        follows: either the program date and time are initialized using the input timecode source, or the time
         *        is initialized using the input timecode source and the date is initialized using the timestamp_offset.
         * @see HlsProgramDateTime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsProgramDateTime
         */
        Builder programDateTime(String programDateTime);

        /**
         * Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as follows:
         * either the program date and time are initialized using the input timecode source, or the time is initialized
         * using the input timecode source and the date is initialized using the timestamp_offset.
         * 
         * @param programDateTime
         *        Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The value is calculated as
         *        follows: either the program date and time are initialized using the input timecode source, or the time
         *        is initialized using the input timecode source and the date is initialized using the timestamp_offset.
         * @see HlsProgramDateTime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsProgramDateTime
         */
        Builder programDateTime(HlsProgramDateTime programDateTime);

        /**
         * Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.
         * 
         * @param programDateTimePeriod
         *        Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programDateTimePeriod(Integer programDateTimePeriod);

        /**
         * Specify whether MediaConvert generates HLS manifests while your job is running or when your job is complete.
         * To generate HLS manifests while your job is running: Choose Enabled. Use if you want to play back your
         * content as soon as it's available. MediaConvert writes the parent and child manifests after the first three
         * media segments are written to your destination S3 bucket. It then writes new updated manifests after each
         * additional segment is written. The parent manifest includes the latest BANDWIDTH and AVERAGE-BANDWIDTH
         * attributes, and child manifests include the latest available media segment. When your job completes, the
         * final child playlists include an EXT-X-ENDLIST tag. To generate HLS manifests only when your job completes:
         * Choose Disabled.
         * 
         * @param progressiveWriteHlsManifest
         *        Specify whether MediaConvert generates HLS manifests while your job is running or when your job is
         *        complete. To generate HLS manifests while your job is running: Choose Enabled. Use if you want to play
         *        back your content as soon as it's available. MediaConvert writes the parent and child manifests after
         *        the first three media segments are written to your destination S3 bucket. It then writes new updated
         *        manifests after each additional segment is written. The parent manifest includes the latest BANDWIDTH
         *        and AVERAGE-BANDWIDTH attributes, and child manifests include the latest available media segment. When
         *        your job completes, the final child playlists include an EXT-X-ENDLIST tag. To generate HLS manifests
         *        only when your job completes: Choose Disabled.
         * @see HlsProgressiveWriteHlsManifest
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsProgressiveWriteHlsManifest
         */
        Builder progressiveWriteHlsManifest(String progressiveWriteHlsManifest);

        /**
         * Specify whether MediaConvert generates HLS manifests while your job is running or when your job is complete.
         * To generate HLS manifests while your job is running: Choose Enabled. Use if you want to play back your
         * content as soon as it's available. MediaConvert writes the parent and child manifests after the first three
         * media segments are written to your destination S3 bucket. It then writes new updated manifests after each
         * additional segment is written. The parent manifest includes the latest BANDWIDTH and AVERAGE-BANDWIDTH
         * attributes, and child manifests include the latest available media segment. When your job completes, the
         * final child playlists include an EXT-X-ENDLIST tag. To generate HLS manifests only when your job completes:
         * Choose Disabled.
         * 
         * @param progressiveWriteHlsManifest
         *        Specify whether MediaConvert generates HLS manifests while your job is running or when your job is
         *        complete. To generate HLS manifests while your job is running: Choose Enabled. Use if you want to play
         *        back your content as soon as it's available. MediaConvert writes the parent and child manifests after
         *        the first three media segments are written to your destination S3 bucket. It then writes new updated
         *        manifests after each additional segment is written. The parent manifest includes the latest BANDWIDTH
         *        and AVERAGE-BANDWIDTH attributes, and child manifests include the latest available media segment. When
         *        your job completes, the final child playlists include an EXT-X-ENDLIST tag. To generate HLS manifests
         *        only when your job completes: Choose Disabled.
         * @see HlsProgressiveWriteHlsManifest
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsProgressiveWriteHlsManifest
         */
        Builder progressiveWriteHlsManifest(HlsProgressiveWriteHlsManifest progressiveWriteHlsManifest);

        /**
         * When set to SINGLE_FILE, emits program as a single media resource (.ts) file, uses #EXT-X-BYTERANGE tags to
         * index segment for playback.
         * 
         * @param segmentControl
         *        When set to SINGLE_FILE, emits program as a single media resource (.ts) file, uses #EXT-X-BYTERANGE
         *        tags to index segment for playback.
         * @see HlsSegmentControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsSegmentControl
         */
        Builder segmentControl(String segmentControl);

        /**
         * When set to SINGLE_FILE, emits program as a single media resource (.ts) file, uses #EXT-X-BYTERANGE tags to
         * index segment for playback.
         * 
         * @param segmentControl
         *        When set to SINGLE_FILE, emits program as a single media resource (.ts) file, uses #EXT-X-BYTERANGE
         *        tags to index segment for playback.
         * @see HlsSegmentControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsSegmentControl
         */
        Builder segmentControl(HlsSegmentControl segmentControl);

        /**
         * Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert defaults
         * to 10. Related settings: Use Segment length control (SegmentLengthControl) to specify whether the encoder
         * enforces this value strictly. Use Segment control (HlsSegmentControl) to specify whether MediaConvert creates
         * separate segment files or one content file that has metadata to mark the segment boundaries.
         * 
         * @param segmentLength
         *        Specify the length, in whole seconds, of each segment. When you don't specify a value, MediaConvert
         *        defaults to 10. Related settings: Use Segment length control (SegmentLengthControl) to specify whether
         *        the encoder enforces this value strictly. Use Segment control (HlsSegmentControl) to specify whether
         *        MediaConvert creates separate segment files or one content file that has metadata to mark the segment
         *        boundaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentLength(Integer segmentLength);

        /**
         * Specify how you want MediaConvert to determine the segment length. Choose Exact (EXACT) to have the encoder
         * use the exact length that you specify with the setting Segment length (SegmentLength). This might result in
         * extra I-frames. Choose Multiple of GOP (GOP_MULTIPLE) to have the encoder round up the segment lengths to
         * match the next GOP boundary.
         * 
         * @param segmentLengthControl
         *        Specify how you want MediaConvert to determine the segment length. Choose Exact (EXACT) to have the
         *        encoder use the exact length that you specify with the setting Segment length (SegmentLength). This
         *        might result in extra I-frames. Choose Multiple of GOP (GOP_MULTIPLE) to have the encoder round up the
         *        segment lengths to match the next GOP boundary.
         * @see HlsSegmentLengthControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsSegmentLengthControl
         */
        Builder segmentLengthControl(String segmentLengthControl);

        /**
         * Specify how you want MediaConvert to determine the segment length. Choose Exact (EXACT) to have the encoder
         * use the exact length that you specify with the setting Segment length (SegmentLength). This might result in
         * extra I-frames. Choose Multiple of GOP (GOP_MULTIPLE) to have the encoder round up the segment lengths to
         * match the next GOP boundary.
         * 
         * @param segmentLengthControl
         *        Specify how you want MediaConvert to determine the segment length. Choose Exact (EXACT) to have the
         *        encoder use the exact length that you specify with the setting Segment length (SegmentLength). This
         *        might result in extra I-frames. Choose Multiple of GOP (GOP_MULTIPLE) to have the encoder round up the
         *        segment lengths to match the next GOP boundary.
         * @see HlsSegmentLengthControl
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsSegmentLengthControl
         */
        Builder segmentLengthControl(HlsSegmentLengthControl segmentLengthControl);

        /**
         * Specify the number of segments to write to a subdirectory before starting a new one. You must also set
         * Directory structure to Subdirectory per stream for this setting to have an effect.
         * 
         * @param segmentsPerSubdirectory
         *        Specify the number of segments to write to a subdirectory before starting a new one. You must also set
         *        Directory structure to Subdirectory per stream for this setting to have an effect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentsPerSubdirectory(Integer segmentsPerSubdirectory);

        /**
         * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         * 
         * @param streamInfResolution
         *        Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         * @see HlsStreamInfResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsStreamInfResolution
         */
        Builder streamInfResolution(String streamInfResolution);

        /**
         * Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         * 
         * @param streamInfResolution
         *        Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of variant manifest.
         * @see HlsStreamInfResolution
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsStreamInfResolution
         */
        Builder streamInfResolution(HlsStreamInfResolution streamInfResolution);

        /**
         * When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above its
         * current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to the
         * nearest integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down if less
         * than 0.5 (< 0.5). You may need to use LEGACY if your client needs to ensure that the target duration is
         * always longer than the actual duration of the segment. Some older players may experience interrupted playback
         * when the actual duration of a track in a segment is longer than the target duration.
         * 
         * @param targetDurationCompatibilityMode
         *        When set to LEGACY, the segment target duration is always rounded up to the nearest integer value
         *        above its current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is
         *        rounded up to the nearest integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5)
         *        and rounded down if less than 0.5 (< 0.5). You may need to use LEGACY if your client needs to ensure
         *        that the target duration is always longer than the actual duration of the segment. Some older players
         *        may experience interrupted playback when the actual duration of a track in a segment is longer than
         *        the target duration.
         * @see HlsTargetDurationCompatibilityMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsTargetDurationCompatibilityMode
         */
        Builder targetDurationCompatibilityMode(String targetDurationCompatibilityMode);

        /**
         * When set to LEGACY, the segment target duration is always rounded up to the nearest integer value above its
         * current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is rounded up to the
         * nearest integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5) and rounded down if less
         * than 0.5 (< 0.5). You may need to use LEGACY if your client needs to ensure that the target duration is
         * always longer than the actual duration of the segment. Some older players may experience interrupted playback
         * when the actual duration of a track in a segment is longer than the target duration.
         * 
         * @param targetDurationCompatibilityMode
         *        When set to LEGACY, the segment target duration is always rounded up to the nearest integer value
         *        above its current value in seconds. When set to SPEC\\_COMPLIANT, the segment target duration is
         *        rounded up to the nearest integer value if fraction seconds are greater than or equal to 0.5 (>= 0.5)
         *        and rounded down if less than 0.5 (< 0.5). You may need to use LEGACY if your client needs to ensure
         *        that the target duration is always longer than the actual duration of the segment. Some older players
         *        may experience interrupted playback when the actual duration of a track in a segment is longer than
         *        the target duration.
         * @see HlsTargetDurationCompatibilityMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsTargetDurationCompatibilityMode
         */
        Builder targetDurationCompatibilityMode(HlsTargetDurationCompatibilityMode targetDurationCompatibilityMode);

        /**
         * Specify the type of the ID3 frame (timedMetadataId3Frame) to use for ID3 timestamps (timedMetadataId3Period)
         * in your output. To include ID3 timestamps: Specify PRIV (PRIV) or TDRL (TDRL) and set ID3 metadata
         * (timedMetadata) to Passthrough (PASSTHROUGH). To exclude ID3 timestamps: Set ID3 timestamp frame type to None
         * (NONE).
         * 
         * @param timedMetadataId3Frame
         *        Specify the type of the ID3 frame (timedMetadataId3Frame) to use for ID3 timestamps
         *        (timedMetadataId3Period) in your output. To include ID3 timestamps: Specify PRIV (PRIV) or TDRL (TDRL)
         *        and set ID3 metadata (timedMetadata) to Passthrough (PASSTHROUGH). To exclude ID3 timestamps: Set ID3
         *        timestamp frame type to None (NONE).
         * @see HlsTimedMetadataId3Frame
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsTimedMetadataId3Frame
         */
        Builder timedMetadataId3Frame(String timedMetadataId3Frame);

        /**
         * Specify the type of the ID3 frame (timedMetadataId3Frame) to use for ID3 timestamps (timedMetadataId3Period)
         * in your output. To include ID3 timestamps: Specify PRIV (PRIV) or TDRL (TDRL) and set ID3 metadata
         * (timedMetadata) to Passthrough (PASSTHROUGH). To exclude ID3 timestamps: Set ID3 timestamp frame type to None
         * (NONE).
         * 
         * @param timedMetadataId3Frame
         *        Specify the type of the ID3 frame (timedMetadataId3Frame) to use for ID3 timestamps
         *        (timedMetadataId3Period) in your output. To include ID3 timestamps: Specify PRIV (PRIV) or TDRL (TDRL)
         *        and set ID3 metadata (timedMetadata) to Passthrough (PASSTHROUGH). To exclude ID3 timestamps: Set ID3
         *        timestamp frame type to None (NONE).
         * @see HlsTimedMetadataId3Frame
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HlsTimedMetadataId3Frame
         */
        Builder timedMetadataId3Frame(HlsTimedMetadataId3Frame timedMetadataId3Frame);

        /**
         * Specify the interval in seconds to write ID3 timestamps in your output. The first timestamp starts at the
         * output timecode and date, and increases incrementally with each ID3 timestamp. To use the default interval of
         * 10 seconds: Leave blank. To include this metadata in your output: Set ID3 timestamp frame type
         * (timedMetadataId3Frame) to PRIV (PRIV) or TDRL (TDRL), and set ID3 metadata (timedMetadata) to Passthrough
         * (PASSTHROUGH).
         * 
         * @param timedMetadataId3Period
         *        Specify the interval in seconds to write ID3 timestamps in your output. The first timestamp starts at
         *        the output timecode and date, and increases incrementally with each ID3 timestamp. To use the default
         *        interval of 10 seconds: Leave blank. To include this metadata in your output: Set ID3 timestamp frame
         *        type (timedMetadataId3Frame) to PRIV (PRIV) or TDRL (TDRL), and set ID3 metadata (timedMetadata) to
         *        Passthrough (PASSTHROUGH).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timedMetadataId3Period(Integer timedMetadataId3Period);

        /**
         * Provides an extra millisecond delta offset to fine tune the timestamps.
         * 
         * @param timestampDeltaMilliseconds
         *        Provides an extra millisecond delta offset to fine tune the timestamps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampDeltaMilliseconds(Integer timestampDeltaMilliseconds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> adMarkers = DefaultSdkAutoConstructList.getInstance();

        private List<HlsAdditionalManifest> additionalManifests = DefaultSdkAutoConstructList.getInstance();

        private String audioOnlyHeader;

        private String baseUrl;

        private List<HlsCaptionLanguageMapping> captionLanguageMappings = DefaultSdkAutoConstructList.getInstance();

        private String captionLanguageSetting;

        private String captionSegmentLengthControl;

        private String clientCache;

        private String codecSpecification;

        private String destination;

        private DestinationSettings destinationSettings;

        private String directoryStructure;

        private HlsEncryptionSettings encryption;

        private String imageBasedTrickPlay;

        private HlsImageBasedTrickPlaySettings imageBasedTrickPlaySettings;

        private String manifestCompression;

        private String manifestDurationFormat;

        private Double minFinalSegmentLength;

        private Integer minSegmentLength;

        private String outputSelection;

        private String programDateTime;

        private Integer programDateTimePeriod;

        private String progressiveWriteHlsManifest;

        private String segmentControl;

        private Integer segmentLength;

        private String segmentLengthControl;

        private Integer segmentsPerSubdirectory;

        private String streamInfResolution;

        private String targetDurationCompatibilityMode;

        private String timedMetadataId3Frame;

        private Integer timedMetadataId3Period;

        private Integer timestampDeltaMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsGroupSettings model) {
            adMarkersWithStrings(model.adMarkers);
            additionalManifests(model.additionalManifests);
            audioOnlyHeader(model.audioOnlyHeader);
            baseUrl(model.baseUrl);
            captionLanguageMappings(model.captionLanguageMappings);
            captionLanguageSetting(model.captionLanguageSetting);
            captionSegmentLengthControl(model.captionSegmentLengthControl);
            clientCache(model.clientCache);
            codecSpecification(model.codecSpecification);
            destination(model.destination);
            destinationSettings(model.destinationSettings);
            directoryStructure(model.directoryStructure);
            encryption(model.encryption);
            imageBasedTrickPlay(model.imageBasedTrickPlay);
            imageBasedTrickPlaySettings(model.imageBasedTrickPlaySettings);
            manifestCompression(model.manifestCompression);
            manifestDurationFormat(model.manifestDurationFormat);
            minFinalSegmentLength(model.minFinalSegmentLength);
            minSegmentLength(model.minSegmentLength);
            outputSelection(model.outputSelection);
            programDateTime(model.programDateTime);
            programDateTimePeriod(model.programDateTimePeriod);
            progressiveWriteHlsManifest(model.progressiveWriteHlsManifest);
            segmentControl(model.segmentControl);
            segmentLength(model.segmentLength);
            segmentLengthControl(model.segmentLengthControl);
            segmentsPerSubdirectory(model.segmentsPerSubdirectory);
            streamInfResolution(model.streamInfResolution);
            targetDurationCompatibilityMode(model.targetDurationCompatibilityMode);
            timedMetadataId3Frame(model.timedMetadataId3Frame);
            timedMetadataId3Period(model.timedMetadataId3Period);
            timestampDeltaMilliseconds(model.timestampDeltaMilliseconds);
        }

        public final Collection<String> getAdMarkers() {
            if (adMarkers instanceof SdkAutoConstructList) {
                return null;
            }
            return adMarkers;
        }

        public final void setAdMarkers(Collection<String> adMarkers) {
            this.adMarkers = ___listOfHlsAdMarkersCopier.copy(adMarkers);
        }

        @Override
        public final Builder adMarkersWithStrings(Collection<String> adMarkers) {
            this.adMarkers = ___listOfHlsAdMarkersCopier.copy(adMarkers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adMarkersWithStrings(String... adMarkers) {
            adMarkersWithStrings(Arrays.asList(adMarkers));
            return this;
        }

        @Override
        public final Builder adMarkers(Collection<HlsAdMarkers> adMarkers) {
            this.adMarkers = ___listOfHlsAdMarkersCopier.copyEnumToString(adMarkers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adMarkers(HlsAdMarkers... adMarkers) {
            adMarkers(Arrays.asList(adMarkers));
            return this;
        }

        public final List<HlsAdditionalManifest.Builder> getAdditionalManifests() {
            List<HlsAdditionalManifest.Builder> result = ___listOfHlsAdditionalManifestCopier
                    .copyToBuilder(this.additionalManifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalManifests(Collection<HlsAdditionalManifest.BuilderImpl> additionalManifests) {
            this.additionalManifests = ___listOfHlsAdditionalManifestCopier.copyFromBuilder(additionalManifests);
        }

        @Override
        public final Builder additionalManifests(Collection<HlsAdditionalManifest> additionalManifests) {
            this.additionalManifests = ___listOfHlsAdditionalManifestCopier.copy(additionalManifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalManifests(HlsAdditionalManifest... additionalManifests) {
            additionalManifests(Arrays.asList(additionalManifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalManifests(Consumer<HlsAdditionalManifest.Builder>... additionalManifests) {
            additionalManifests(Stream.of(additionalManifests).map(c -> HlsAdditionalManifest.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAudioOnlyHeader() {
            return audioOnlyHeader;
        }

        public final void setAudioOnlyHeader(String audioOnlyHeader) {
            this.audioOnlyHeader = audioOnlyHeader;
        }

        @Override
        public final Builder audioOnlyHeader(String audioOnlyHeader) {
            this.audioOnlyHeader = audioOnlyHeader;
            return this;
        }

        @Override
        public final Builder audioOnlyHeader(HlsAudioOnlyHeader audioOnlyHeader) {
            this.audioOnlyHeader(audioOnlyHeader == null ? null : audioOnlyHeader.toString());
            return this;
        }

        public final String getBaseUrl() {
            return baseUrl;
        }

        public final void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        @Override
        public final Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public final List<HlsCaptionLanguageMapping.Builder> getCaptionLanguageMappings() {
            List<HlsCaptionLanguageMapping.Builder> result = ___listOfHlsCaptionLanguageMappingCopier
                    .copyToBuilder(this.captionLanguageMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCaptionLanguageMappings(Collection<HlsCaptionLanguageMapping.BuilderImpl> captionLanguageMappings) {
            this.captionLanguageMappings = ___listOfHlsCaptionLanguageMappingCopier.copyFromBuilder(captionLanguageMappings);
        }

        @Override
        public final Builder captionLanguageMappings(Collection<HlsCaptionLanguageMapping> captionLanguageMappings) {
            this.captionLanguageMappings = ___listOfHlsCaptionLanguageMappingCopier.copy(captionLanguageMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionLanguageMappings(HlsCaptionLanguageMapping... captionLanguageMappings) {
            captionLanguageMappings(Arrays.asList(captionLanguageMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder captionLanguageMappings(Consumer<HlsCaptionLanguageMapping.Builder>... captionLanguageMappings) {
            captionLanguageMappings(Stream.of(captionLanguageMappings)
                    .map(c -> HlsCaptionLanguageMapping.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCaptionLanguageSetting() {
            return captionLanguageSetting;
        }

        public final void setCaptionLanguageSetting(String captionLanguageSetting) {
            this.captionLanguageSetting = captionLanguageSetting;
        }

        @Override
        public final Builder captionLanguageSetting(String captionLanguageSetting) {
            this.captionLanguageSetting = captionLanguageSetting;
            return this;
        }

        @Override
        public final Builder captionLanguageSetting(HlsCaptionLanguageSetting captionLanguageSetting) {
            this.captionLanguageSetting(captionLanguageSetting == null ? null : captionLanguageSetting.toString());
            return this;
        }

        public final String getCaptionSegmentLengthControl() {
            return captionSegmentLengthControl;
        }

        public final void setCaptionSegmentLengthControl(String captionSegmentLengthControl) {
            this.captionSegmentLengthControl = captionSegmentLengthControl;
        }

        @Override
        public final Builder captionSegmentLengthControl(String captionSegmentLengthControl) {
            this.captionSegmentLengthControl = captionSegmentLengthControl;
            return this;
        }

        @Override
        public final Builder captionSegmentLengthControl(HlsCaptionSegmentLengthControl captionSegmentLengthControl) {
            this.captionSegmentLengthControl(captionSegmentLengthControl == null ? null : captionSegmentLengthControl.toString());
            return this;
        }

        public final String getClientCache() {
            return clientCache;
        }

        public final void setClientCache(String clientCache) {
            this.clientCache = clientCache;
        }

        @Override
        public final Builder clientCache(String clientCache) {
            this.clientCache = clientCache;
            return this;
        }

        @Override
        public final Builder clientCache(HlsClientCache clientCache) {
            this.clientCache(clientCache == null ? null : clientCache.toString());
            return this;
        }

        public final String getCodecSpecification() {
            return codecSpecification;
        }

        public final void setCodecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
        }

        @Override
        public final Builder codecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
            return this;
        }

        @Override
        public final Builder codecSpecification(HlsCodecSpecification codecSpecification) {
            this.codecSpecification(codecSpecification == null ? null : codecSpecification.toString());
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final DestinationSettings.Builder getDestinationSettings() {
            return destinationSettings != null ? destinationSettings.toBuilder() : null;
        }

        public final void setDestinationSettings(DestinationSettings.BuilderImpl destinationSettings) {
            this.destinationSettings = destinationSettings != null ? destinationSettings.build() : null;
        }

        @Override
        public final Builder destinationSettings(DestinationSettings destinationSettings) {
            this.destinationSettings = destinationSettings;
            return this;
        }

        public final String getDirectoryStructure() {
            return directoryStructure;
        }

        public final void setDirectoryStructure(String directoryStructure) {
            this.directoryStructure = directoryStructure;
        }

        @Override
        public final Builder directoryStructure(String directoryStructure) {
            this.directoryStructure = directoryStructure;
            return this;
        }

        @Override
        public final Builder directoryStructure(HlsDirectoryStructure directoryStructure) {
            this.directoryStructure(directoryStructure == null ? null : directoryStructure.toString());
            return this;
        }

        public final HlsEncryptionSettings.Builder getEncryption() {
            return encryption != null ? encryption.toBuilder() : null;
        }

        public final void setEncryption(HlsEncryptionSettings.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(HlsEncryptionSettings encryption) {
            this.encryption = encryption;
            return this;
        }

        public final String getImageBasedTrickPlay() {
            return imageBasedTrickPlay;
        }

        public final void setImageBasedTrickPlay(String imageBasedTrickPlay) {
            this.imageBasedTrickPlay = imageBasedTrickPlay;
        }

        @Override
        public final Builder imageBasedTrickPlay(String imageBasedTrickPlay) {
            this.imageBasedTrickPlay = imageBasedTrickPlay;
            return this;
        }

        @Override
        public final Builder imageBasedTrickPlay(HlsImageBasedTrickPlay imageBasedTrickPlay) {
            this.imageBasedTrickPlay(imageBasedTrickPlay == null ? null : imageBasedTrickPlay.toString());
            return this;
        }

        public final HlsImageBasedTrickPlaySettings.Builder getImageBasedTrickPlaySettings() {
            return imageBasedTrickPlaySettings != null ? imageBasedTrickPlaySettings.toBuilder() : null;
        }

        public final void setImageBasedTrickPlaySettings(HlsImageBasedTrickPlaySettings.BuilderImpl imageBasedTrickPlaySettings) {
            this.imageBasedTrickPlaySettings = imageBasedTrickPlaySettings != null ? imageBasedTrickPlaySettings.build() : null;
        }

        @Override
        public final Builder imageBasedTrickPlaySettings(HlsImageBasedTrickPlaySettings imageBasedTrickPlaySettings) {
            this.imageBasedTrickPlaySettings = imageBasedTrickPlaySettings;
            return this;
        }

        public final String getManifestCompression() {
            return manifestCompression;
        }

        public final void setManifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
        }

        @Override
        public final Builder manifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
            return this;
        }

        @Override
        public final Builder manifestCompression(HlsManifestCompression manifestCompression) {
            this.manifestCompression(manifestCompression == null ? null : manifestCompression.toString());
            return this;
        }

        public final String getManifestDurationFormat() {
            return manifestDurationFormat;
        }

        public final void setManifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
        }

        @Override
        public final Builder manifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
            return this;
        }

        @Override
        public final Builder manifestDurationFormat(HlsManifestDurationFormat manifestDurationFormat) {
            this.manifestDurationFormat(manifestDurationFormat == null ? null : manifestDurationFormat.toString());
            return this;
        }

        public final Double getMinFinalSegmentLength() {
            return minFinalSegmentLength;
        }

        public final void setMinFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
        }

        @Override
        public final Builder minFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
            return this;
        }

        public final Integer getMinSegmentLength() {
            return minSegmentLength;
        }

        public final void setMinSegmentLength(Integer minSegmentLength) {
            this.minSegmentLength = minSegmentLength;
        }

        @Override
        public final Builder minSegmentLength(Integer minSegmentLength) {
            this.minSegmentLength = minSegmentLength;
            return this;
        }

        public final String getOutputSelection() {
            return outputSelection;
        }

        public final void setOutputSelection(String outputSelection) {
            this.outputSelection = outputSelection;
        }

        @Override
        public final Builder outputSelection(String outputSelection) {
            this.outputSelection = outputSelection;
            return this;
        }

        @Override
        public final Builder outputSelection(HlsOutputSelection outputSelection) {
            this.outputSelection(outputSelection == null ? null : outputSelection.toString());
            return this;
        }

        public final String getProgramDateTime() {
            return programDateTime;
        }

        public final void setProgramDateTime(String programDateTime) {
            this.programDateTime = programDateTime;
        }

        @Override
        public final Builder programDateTime(String programDateTime) {
            this.programDateTime = programDateTime;
            return this;
        }

        @Override
        public final Builder programDateTime(HlsProgramDateTime programDateTime) {
            this.programDateTime(programDateTime == null ? null : programDateTime.toString());
            return this;
        }

        public final Integer getProgramDateTimePeriod() {
            return programDateTimePeriod;
        }

        public final void setProgramDateTimePeriod(Integer programDateTimePeriod) {
            this.programDateTimePeriod = programDateTimePeriod;
        }

        @Override
        public final Builder programDateTimePeriod(Integer programDateTimePeriod) {
            this.programDateTimePeriod = programDateTimePeriod;
            return this;
        }

        public final String getProgressiveWriteHlsManifest() {
            return progressiveWriteHlsManifest;
        }

        public final void setProgressiveWriteHlsManifest(String progressiveWriteHlsManifest) {
            this.progressiveWriteHlsManifest = progressiveWriteHlsManifest;
        }

        @Override
        public final Builder progressiveWriteHlsManifest(String progressiveWriteHlsManifest) {
            this.progressiveWriteHlsManifest = progressiveWriteHlsManifest;
            return this;
        }

        @Override
        public final Builder progressiveWriteHlsManifest(HlsProgressiveWriteHlsManifest progressiveWriteHlsManifest) {
            this.progressiveWriteHlsManifest(progressiveWriteHlsManifest == null ? null : progressiveWriteHlsManifest.toString());
            return this;
        }

        public final String getSegmentControl() {
            return segmentControl;
        }

        public final void setSegmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
        }

        @Override
        public final Builder segmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
            return this;
        }

        @Override
        public final Builder segmentControl(HlsSegmentControl segmentControl) {
            this.segmentControl(segmentControl == null ? null : segmentControl.toString());
            return this;
        }

        public final Integer getSegmentLength() {
            return segmentLength;
        }

        public final void setSegmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
        }

        @Override
        public final Builder segmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public final String getSegmentLengthControl() {
            return segmentLengthControl;
        }

        public final void setSegmentLengthControl(String segmentLengthControl) {
            this.segmentLengthControl = segmentLengthControl;
        }

        @Override
        public final Builder segmentLengthControl(String segmentLengthControl) {
            this.segmentLengthControl = segmentLengthControl;
            return this;
        }

        @Override
        public final Builder segmentLengthControl(HlsSegmentLengthControl segmentLengthControl) {
            this.segmentLengthControl(segmentLengthControl == null ? null : segmentLengthControl.toString());
            return this;
        }

        public final Integer getSegmentsPerSubdirectory() {
            return segmentsPerSubdirectory;
        }

        public final void setSegmentsPerSubdirectory(Integer segmentsPerSubdirectory) {
            this.segmentsPerSubdirectory = segmentsPerSubdirectory;
        }

        @Override
        public final Builder segmentsPerSubdirectory(Integer segmentsPerSubdirectory) {
            this.segmentsPerSubdirectory = segmentsPerSubdirectory;
            return this;
        }

        public final String getStreamInfResolution() {
            return streamInfResolution;
        }

        public final void setStreamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
        }

        @Override
        public final Builder streamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
            return this;
        }

        @Override
        public final Builder streamInfResolution(HlsStreamInfResolution streamInfResolution) {
            this.streamInfResolution(streamInfResolution == null ? null : streamInfResolution.toString());
            return this;
        }

        public final String getTargetDurationCompatibilityMode() {
            return targetDurationCompatibilityMode;
        }

        public final void setTargetDurationCompatibilityMode(String targetDurationCompatibilityMode) {
            this.targetDurationCompatibilityMode = targetDurationCompatibilityMode;
        }

        @Override
        public final Builder targetDurationCompatibilityMode(String targetDurationCompatibilityMode) {
            this.targetDurationCompatibilityMode = targetDurationCompatibilityMode;
            return this;
        }

        @Override
        public final Builder targetDurationCompatibilityMode(HlsTargetDurationCompatibilityMode targetDurationCompatibilityMode) {
            this.targetDurationCompatibilityMode(targetDurationCompatibilityMode == null ? null : targetDurationCompatibilityMode
                    .toString());
            return this;
        }

        public final String getTimedMetadataId3Frame() {
            return timedMetadataId3Frame;
        }

        public final void setTimedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
        }

        @Override
        public final Builder timedMetadataId3Frame(String timedMetadataId3Frame) {
            this.timedMetadataId3Frame = timedMetadataId3Frame;
            return this;
        }

        @Override
        public final Builder timedMetadataId3Frame(HlsTimedMetadataId3Frame timedMetadataId3Frame) {
            this.timedMetadataId3Frame(timedMetadataId3Frame == null ? null : timedMetadataId3Frame.toString());
            return this;
        }

        public final Integer getTimedMetadataId3Period() {
            return timedMetadataId3Period;
        }

        public final void setTimedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
        }

        @Override
        public final Builder timedMetadataId3Period(Integer timedMetadataId3Period) {
            this.timedMetadataId3Period = timedMetadataId3Period;
            return this;
        }

        public final Integer getTimestampDeltaMilliseconds() {
            return timestampDeltaMilliseconds;
        }

        public final void setTimestampDeltaMilliseconds(Integer timestampDeltaMilliseconds) {
            this.timestampDeltaMilliseconds = timestampDeltaMilliseconds;
        }

        @Override
        public final Builder timestampDeltaMilliseconds(Integer timestampDeltaMilliseconds) {
            this.timestampDeltaMilliseconds = timestampDeltaMilliseconds;
            return this;
        }

        @Override
        public HlsGroupSettings build() {
            return new HlsGroupSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
