/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.CmafGroupSettings;
import software.amazon.awssdk.services.mediaconvert.model.DashIsoGroupSettings;
import software.amazon.awssdk.services.mediaconvert.model.FileGroupSettings;
import software.amazon.awssdk.services.mediaconvert.model.HlsGroupSettings;
import software.amazon.awssdk.services.mediaconvert.model.MsSmoothGroupSettings;
import software.amazon.awssdk.services.mediaconvert.model.OutputGroupType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutputGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutputGroupSettings> {
    private static final SdkField<CmafGroupSettings> CMAF_GROUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CmafGroupSettings").getter(OutputGroupSettings.getter(OutputGroupSettings::cmafGroupSettings)).setter(OutputGroupSettings.setter(Builder::cmafGroupSettings)).constructor(CmafGroupSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cmafGroupSettings").build()}).build();
    private static final SdkField<DashIsoGroupSettings> DASH_ISO_GROUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DashIsoGroupSettings").getter(OutputGroupSettings.getter(OutputGroupSettings::dashIsoGroupSettings)).setter(OutputGroupSettings.setter(Builder::dashIsoGroupSettings)).constructor(DashIsoGroupSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dashIsoGroupSettings").build()}).build();
    private static final SdkField<FileGroupSettings> FILE_GROUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FileGroupSettings").getter(OutputGroupSettings.getter(OutputGroupSettings::fileGroupSettings)).setter(OutputGroupSettings.setter(Builder::fileGroupSettings)).constructor(FileGroupSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileGroupSettings").build()}).build();
    private static final SdkField<HlsGroupSettings> HLS_GROUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HlsGroupSettings").getter(OutputGroupSettings.getter(OutputGroupSettings::hlsGroupSettings)).setter(OutputGroupSettings.setter(Builder::hlsGroupSettings)).constructor(HlsGroupSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hlsGroupSettings").build()}).build();
    private static final SdkField<MsSmoothGroupSettings> MS_SMOOTH_GROUP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MsSmoothGroupSettings").getter(OutputGroupSettings.getter(OutputGroupSettings::msSmoothGroupSettings)).setter(OutputGroupSettings.setter(Builder::msSmoothGroupSettings)).constructor(MsSmoothGroupSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("msSmoothGroupSettings").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(OutputGroupSettings.getter(OutputGroupSettings::typeAsString)).setter(OutputGroupSettings.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CMAF_GROUP_SETTINGS_FIELD, DASH_ISO_GROUP_SETTINGS_FIELD, FILE_GROUP_SETTINGS_FIELD, HLS_GROUP_SETTINGS_FIELD, MS_SMOOTH_GROUP_SETTINGS_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final CmafGroupSettings cmafGroupSettings;
    private final DashIsoGroupSettings dashIsoGroupSettings;
    private final FileGroupSettings fileGroupSettings;
    private final HlsGroupSettings hlsGroupSettings;
    private final MsSmoothGroupSettings msSmoothGroupSettings;
    private final String type;

    private OutputGroupSettings(BuilderImpl builder) {
        this.cmafGroupSettings = builder.cmafGroupSettings;
        this.dashIsoGroupSettings = builder.dashIsoGroupSettings;
        this.fileGroupSettings = builder.fileGroupSettings;
        this.hlsGroupSettings = builder.hlsGroupSettings;
        this.msSmoothGroupSettings = builder.msSmoothGroupSettings;
        this.type = builder.type;
    }

    public final CmafGroupSettings cmafGroupSettings() {
        return this.cmafGroupSettings;
    }

    public final DashIsoGroupSettings dashIsoGroupSettings() {
        return this.dashIsoGroupSettings;
    }

    public final FileGroupSettings fileGroupSettings() {
        return this.fileGroupSettings;
    }

    public final HlsGroupSettings hlsGroupSettings() {
        return this.hlsGroupSettings;
    }

    public final MsSmoothGroupSettings msSmoothGroupSettings() {
        return this.msSmoothGroupSettings;
    }

    public final OutputGroupType type() {
        return OutputGroupType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cmafGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashIsoGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.msSmoothGroupSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputGroupSettings)) {
            return false;
        }
        OutputGroupSettings other = (OutputGroupSettings)obj;
        return Objects.equals(this.cmafGroupSettings(), other.cmafGroupSettings()) && Objects.equals(this.dashIsoGroupSettings(), other.dashIsoGroupSettings()) && Objects.equals(this.fileGroupSettings(), other.fileGroupSettings()) && Objects.equals(this.hlsGroupSettings(), other.hlsGroupSettings()) && Objects.equals(this.msSmoothGroupSettings(), other.msSmoothGroupSettings()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OutputGroupSettings").add("CmafGroupSettings", (Object)this.cmafGroupSettings()).add("DashIsoGroupSettings", (Object)this.dashIsoGroupSettings()).add("FileGroupSettings", (Object)this.fileGroupSettings()).add("HlsGroupSettings", (Object)this.hlsGroupSettings()).add("MsSmoothGroupSettings", (Object)this.msSmoothGroupSettings()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CmafGroupSettings": {
                return Optional.ofNullable(clazz.cast(this.cmafGroupSettings()));
            }
            case "DashIsoGroupSettings": {
                return Optional.ofNullable(clazz.cast(this.dashIsoGroupSettings()));
            }
            case "FileGroupSettings": {
                return Optional.ofNullable(clazz.cast(this.fileGroupSettings()));
            }
            case "HlsGroupSettings": {
                return Optional.ofNullable(clazz.cast(this.hlsGroupSettings()));
            }
            case "MsSmoothGroupSettings": {
                return Optional.ofNullable(clazz.cast(this.msSmoothGroupSettings()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutputGroupSettings, T> g) {
        return obj -> g.apply((OutputGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CmafGroupSettings cmafGroupSettings;
        private DashIsoGroupSettings dashIsoGroupSettings;
        private FileGroupSettings fileGroupSettings;
        private HlsGroupSettings hlsGroupSettings;
        private MsSmoothGroupSettings msSmoothGroupSettings;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(OutputGroupSettings model) {
            this.cmafGroupSettings(model.cmafGroupSettings);
            this.dashIsoGroupSettings(model.dashIsoGroupSettings);
            this.fileGroupSettings(model.fileGroupSettings);
            this.hlsGroupSettings(model.hlsGroupSettings);
            this.msSmoothGroupSettings(model.msSmoothGroupSettings);
            this.type(model.type);
        }

        public final CmafGroupSettings.Builder getCmafGroupSettings() {
            return this.cmafGroupSettings != null ? this.cmafGroupSettings.toBuilder() : null;
        }

        public final void setCmafGroupSettings(CmafGroupSettings.BuilderImpl cmafGroupSettings) {
            this.cmafGroupSettings = cmafGroupSettings != null ? cmafGroupSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder cmafGroupSettings(CmafGroupSettings cmafGroupSettings) {
            this.cmafGroupSettings = cmafGroupSettings;
            return this;
        }

        public final DashIsoGroupSettings.Builder getDashIsoGroupSettings() {
            return this.dashIsoGroupSettings != null ? this.dashIsoGroupSettings.toBuilder() : null;
        }

        public final void setDashIsoGroupSettings(DashIsoGroupSettings.BuilderImpl dashIsoGroupSettings) {
            this.dashIsoGroupSettings = dashIsoGroupSettings != null ? dashIsoGroupSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder dashIsoGroupSettings(DashIsoGroupSettings dashIsoGroupSettings) {
            this.dashIsoGroupSettings = dashIsoGroupSettings;
            return this;
        }

        public final FileGroupSettings.Builder getFileGroupSettings() {
            return this.fileGroupSettings != null ? this.fileGroupSettings.toBuilder() : null;
        }

        public final void setFileGroupSettings(FileGroupSettings.BuilderImpl fileGroupSettings) {
            this.fileGroupSettings = fileGroupSettings != null ? fileGroupSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder fileGroupSettings(FileGroupSettings fileGroupSettings) {
            this.fileGroupSettings = fileGroupSettings;
            return this;
        }

        public final HlsGroupSettings.Builder getHlsGroupSettings() {
            return this.hlsGroupSettings != null ? this.hlsGroupSettings.toBuilder() : null;
        }

        public final void setHlsGroupSettings(HlsGroupSettings.BuilderImpl hlsGroupSettings) {
            this.hlsGroupSettings = hlsGroupSettings != null ? hlsGroupSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder hlsGroupSettings(HlsGroupSettings hlsGroupSettings) {
            this.hlsGroupSettings = hlsGroupSettings;
            return this;
        }

        public final MsSmoothGroupSettings.Builder getMsSmoothGroupSettings() {
            return this.msSmoothGroupSettings != null ? this.msSmoothGroupSettings.toBuilder() : null;
        }

        public final void setMsSmoothGroupSettings(MsSmoothGroupSettings.BuilderImpl msSmoothGroupSettings) {
            this.msSmoothGroupSettings = msSmoothGroupSettings != null ? msSmoothGroupSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder msSmoothGroupSettings(MsSmoothGroupSettings msSmoothGroupSettings) {
            this.msSmoothGroupSettings = msSmoothGroupSettings;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(OutputGroupType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public OutputGroupSettings build() {
            return new OutputGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutputGroupSettings> {
        public Builder cmafGroupSettings(CmafGroupSettings var1);

        default public Builder cmafGroupSettings(Consumer<CmafGroupSettings.Builder> cmafGroupSettings) {
            return this.cmafGroupSettings((CmafGroupSettings)((CmafGroupSettings.Builder)CmafGroupSettings.builder().applyMutation(cmafGroupSettings)).build());
        }

        public Builder dashIsoGroupSettings(DashIsoGroupSettings var1);

        default public Builder dashIsoGroupSettings(Consumer<DashIsoGroupSettings.Builder> dashIsoGroupSettings) {
            return this.dashIsoGroupSettings((DashIsoGroupSettings)((DashIsoGroupSettings.Builder)DashIsoGroupSettings.builder().applyMutation(dashIsoGroupSettings)).build());
        }

        public Builder fileGroupSettings(FileGroupSettings var1);

        default public Builder fileGroupSettings(Consumer<FileGroupSettings.Builder> fileGroupSettings) {
            return this.fileGroupSettings((FileGroupSettings)((FileGroupSettings.Builder)FileGroupSettings.builder().applyMutation(fileGroupSettings)).build());
        }

        public Builder hlsGroupSettings(HlsGroupSettings var1);

        default public Builder hlsGroupSettings(Consumer<HlsGroupSettings.Builder> hlsGroupSettings) {
            return this.hlsGroupSettings((HlsGroupSettings)((HlsGroupSettings.Builder)HlsGroupSettings.builder().applyMutation(hlsGroupSettings)).build());
        }

        public Builder msSmoothGroupSettings(MsSmoothGroupSettings var1);

        default public Builder msSmoothGroupSettings(Consumer<MsSmoothGroupSettings.Builder> msSmoothGroupSettings) {
            return this.msSmoothGroupSettings((MsSmoothGroupSettings)((MsSmoothGroupSettings.Builder)MsSmoothGroupSettings.builder().applyMutation(msSmoothGroupSettings)).build());
        }

        public Builder type(String var1);

        public Builder type(OutputGroupType var1);
    }
}

