/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.MxfAfdSignaling;
import software.amazon.awssdk.services.mediaconvert.model.MxfProfile;
import software.amazon.awssdk.services.mediaconvert.model.MxfXavcProfileSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MxfSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MxfSettings> {
    private static final SdkField<String> AFD_SIGNALING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AfdSignaling").getter(MxfSettings.getter(MxfSettings::afdSignalingAsString)).setter(MxfSettings.setter(Builder::afdSignaling)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afdSignaling").build()}).build();
    private static final SdkField<String> PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Profile").getter(MxfSettings.getter(MxfSettings::profileAsString)).setter(MxfSettings.setter(Builder::profile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build()}).build();
    private static final SdkField<MxfXavcProfileSettings> XAVC_PROFILE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("XavcProfileSettings").getter(MxfSettings.getter(MxfSettings::xavcProfileSettings)).setter(MxfSettings.setter(Builder::xavcProfileSettings)).constructor(MxfXavcProfileSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xavcProfileSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFD_SIGNALING_FIELD, PROFILE_FIELD, XAVC_PROFILE_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String afdSignaling;
    private final String profile;
    private final MxfXavcProfileSettings xavcProfileSettings;

    private MxfSettings(BuilderImpl builder) {
        this.afdSignaling = builder.afdSignaling;
        this.profile = builder.profile;
        this.xavcProfileSettings = builder.xavcProfileSettings;
    }

    public final MxfAfdSignaling afdSignaling() {
        return MxfAfdSignaling.fromValue(this.afdSignaling);
    }

    public final String afdSignalingAsString() {
        return this.afdSignaling;
    }

    public final MxfProfile profile() {
        return MxfProfile.fromValue(this.profile);
    }

    public final String profileAsString() {
        return this.profile;
    }

    public final MxfXavcProfileSettings xavcProfileSettings() {
        return this.xavcProfileSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.afdSignalingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.xavcProfileSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MxfSettings)) {
            return false;
        }
        MxfSettings other = (MxfSettings)obj;
        return Objects.equals(this.afdSignalingAsString(), other.afdSignalingAsString()) && Objects.equals(this.profileAsString(), other.profileAsString()) && Objects.equals(this.xavcProfileSettings(), other.xavcProfileSettings());
    }

    public final String toString() {
        return ToString.builder((String)"MxfSettings").add("AfdSignaling", (Object)this.afdSignalingAsString()).add("Profile", (Object)this.profileAsString()).add("XavcProfileSettings", (Object)this.xavcProfileSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AfdSignaling": {
                return Optional.ofNullable(clazz.cast(this.afdSignalingAsString()));
            }
            case "Profile": {
                return Optional.ofNullable(clazz.cast(this.profileAsString()));
            }
            case "XavcProfileSettings": {
                return Optional.ofNullable(clazz.cast(this.xavcProfileSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MxfSettings, T> g) {
        return obj -> g.apply((MxfSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String afdSignaling;
        private String profile;
        private MxfXavcProfileSettings xavcProfileSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(MxfSettings model) {
            this.afdSignaling(model.afdSignaling);
            this.profile(model.profile);
            this.xavcProfileSettings(model.xavcProfileSettings);
        }

        public final String getAfdSignaling() {
            return this.afdSignaling;
        }

        public final void setAfdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
        }

        @Override
        @Transient
        public final Builder afdSignaling(String afdSignaling) {
            this.afdSignaling = afdSignaling;
            return this;
        }

        @Override
        @Transient
        public final Builder afdSignaling(MxfAfdSignaling afdSignaling) {
            this.afdSignaling(afdSignaling == null ? null : afdSignaling.toString());
            return this;
        }

        public final String getProfile() {
            return this.profile;
        }

        public final void setProfile(String profile) {
            this.profile = profile;
        }

        @Override
        @Transient
        public final Builder profile(String profile) {
            this.profile = profile;
            return this;
        }

        @Override
        @Transient
        public final Builder profile(MxfProfile profile) {
            this.profile(profile == null ? null : profile.toString());
            return this;
        }

        public final MxfXavcProfileSettings.Builder getXavcProfileSettings() {
            return this.xavcProfileSettings != null ? this.xavcProfileSettings.toBuilder() : null;
        }

        public final void setXavcProfileSettings(MxfXavcProfileSettings.BuilderImpl xavcProfileSettings) {
            this.xavcProfileSettings = xavcProfileSettings != null ? xavcProfileSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder xavcProfileSettings(MxfXavcProfileSettings xavcProfileSettings) {
            this.xavcProfileSettings = xavcProfileSettings;
            return this;
        }

        public MxfSettings build() {
            return new MxfSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MxfSettings> {
        public Builder afdSignaling(String var1);

        public Builder afdSignaling(MxfAfdSignaling var1);

        public Builder profile(String var1);

        public Builder profile(MxfProfile var1);

        public Builder xavcProfileSettings(MxfXavcProfileSettings var1);

        default public Builder xavcProfileSettings(Consumer<MxfXavcProfileSettings.Builder> xavcProfileSettings) {
            return this.xavcProfileSettings((MxfXavcProfileSettings)((MxfXavcProfileSettings.Builder)MxfXavcProfileSettings.builder().applyMutation(xavcProfileSettings)).build());
        }
    }
}

