/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Colorimetry {
    BT601("BT601"),
    BT709("BT709"),
    BT2020("BT2020"),
    BT2100("BT2100"),
    ST2065_1("ST2065-1"),
    ST2065_3("ST2065-3"),
    XYZ("XYZ"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Colorimetry> VALUE_MAP;
    private final String value;

    private Colorimetry(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Colorimetry fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Colorimetry> knownValues() {
        EnumSet<Colorimetry> knownValues = EnumSet.allOf(Colorimetry.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Colorimetry.class, Colorimetry::toString);
    }
}

