/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTransactionRequest extends ManagedBlockchainQueryRequest implements
        ToCopyableBuilder<GetTransactionRequest.Builder, GetTransactionRequest> {
    private static final SdkField<String> TRANSACTION_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transactionHash").getter(getter(GetTransactionRequest::transactionHash))
            .setter(setter(Builder::transactionHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionHash").build()).build();

    private static final SdkField<String> NETWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("network")
            .getter(getter(GetTransactionRequest::networkAsString)).setter(setter(Builder::network))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("network").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTION_HASH_FIELD,
            NETWORK_FIELD));

    private final String transactionHash;

    private final String network;

    private GetTransactionRequest(BuilderImpl builder) {
        super(builder);
        this.transactionHash = builder.transactionHash;
        this.network = builder.network;
    }

    /**
     * <p>
     * The hash of the transaction. It is generated whenever a transaction is verified and added to the blockchain.
     * </p>
     * 
     * @return The hash of the transaction. It is generated whenever a transaction is verified and added to the
     *         blockchain.
     */
    public final String transactionHash() {
        return transactionHash;
    }

    /**
     * <p>
     * The blockchain network where the transaction occurred.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #network} will
     * return {@link QueryNetwork#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkAsString}.
     * </p>
     * 
     * @return The blockchain network where the transaction occurred.
     * @see QueryNetwork
     */
    public final QueryNetwork network() {
        return QueryNetwork.fromValue(network);
    }

    /**
     * <p>
     * The blockchain network where the transaction occurred.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #network} will
     * return {@link QueryNetwork#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkAsString}.
     * </p>
     * 
     * @return The blockchain network where the transaction occurred.
     * @see QueryNetwork
     */
    public final String networkAsString() {
        return network;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transactionHash());
        hashCode = 31 * hashCode + Objects.hashCode(networkAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransactionRequest)) {
            return false;
        }
        GetTransactionRequest other = (GetTransactionRequest) obj;
        return Objects.equals(transactionHash(), other.transactionHash())
                && Objects.equals(networkAsString(), other.networkAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTransactionRequest").add("TransactionHash", transactionHash())
                .add("Network", networkAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transactionHash":
            return Optional.ofNullable(clazz.cast(transactionHash()));
        case "network":
            return Optional.ofNullable(clazz.cast(networkAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTransactionRequest, T> g) {
        return obj -> g.apply((GetTransactionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainQueryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTransactionRequest> {
        /**
         * <p>
         * The hash of the transaction. It is generated whenever a transaction is verified and added to the blockchain.
         * </p>
         * 
         * @param transactionHash
         *        The hash of the transaction. It is generated whenever a transaction is verified and added to the
         *        blockchain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionHash(String transactionHash);

        /**
         * <p>
         * The blockchain network where the transaction occurred.
         * </p>
         * 
         * @param network
         *        The blockchain network where the transaction occurred.
         * @see QueryNetwork
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryNetwork
         */
        Builder network(String network);

        /**
         * <p>
         * The blockchain network where the transaction occurred.
         * </p>
         * 
         * @param network
         *        The blockchain network where the transaction occurred.
         * @see QueryNetwork
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryNetwork
         */
        Builder network(QueryNetwork network);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ManagedBlockchainQueryRequest.BuilderImpl implements Builder {
        private String transactionHash;

        private String network;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransactionRequest model) {
            super(model);
            transactionHash(model.transactionHash);
            network(model.network);
        }

        public final String getTransactionHash() {
            return transactionHash;
        }

        public final void setTransactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
        }

        @Override
        public final Builder transactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
            return this;
        }

        public final String getNetwork() {
            return network;
        }

        public final void setNetwork(String network) {
            this.network = network;
        }

        @Override
        public final Builder network(String network) {
            this.network = network;
            return this;
        }

        @Override
        public final Builder network(QueryNetwork network) {
            this.network(network == null ? null : network.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTransactionRequest build() {
            return new GetTransactionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
