/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The container for the properties of a transaction event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransactionEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<TransactionEvent.Builder, TransactionEvent> {
    private static final SdkField<String> NETWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("network")
            .getter(getter(TransactionEvent::networkAsString)).setter(setter(Builder::network))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("network").build()).build();

    private static final SdkField<String> TRANSACTION_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transactionHash").getter(getter(TransactionEvent::transactionHash))
            .setter(setter(Builder::transactionHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionHash").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventType").getter(getter(TransactionEvent::eventTypeAsString)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<String> FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("from")
            .getter(getter(TransactionEvent::from)).setter(setter(Builder::from))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("from").build()).build();

    private static final SdkField<String> TO_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("to")
            .getter(getter(TransactionEvent::to)).setter(setter(Builder::to))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("to").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(TransactionEvent::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> CONTRACT_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contractAddress").getter(getter(TransactionEvent::contractAddress))
            .setter(setter(Builder::contractAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contractAddress").build()).build();

    private static final SdkField<String> TOKEN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tokenId").getter(getter(TransactionEvent::tokenId)).setter(setter(Builder::tokenId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenId").build()).build();

    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transactionId").getter(getter(TransactionEvent::transactionId)).setter(setter(Builder::transactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionId").build()).build();

    private static final SdkField<Integer> VOUT_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("voutIndex").getter(getter(TransactionEvent::voutIndex)).setter(setter(Builder::voutIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voutIndex").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_FIELD,
            TRANSACTION_HASH_FIELD, EVENT_TYPE_FIELD, FROM_FIELD, TO_FIELD, VALUE_FIELD, CONTRACT_ADDRESS_FIELD, TOKEN_ID_FIELD,
            TRANSACTION_ID_FIELD, VOUT_INDEX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String network;

    private final String transactionHash;

    private final String eventType;

    private final String from;

    private final String to;

    private final String value;

    private final String contractAddress;

    private final String tokenId;

    private final String transactionId;

    private final Integer voutIndex;

    private TransactionEvent(BuilderImpl builder) {
        this.network = builder.network;
        this.transactionHash = builder.transactionHash;
        this.eventType = builder.eventType;
        this.from = builder.from;
        this.to = builder.to;
        this.value = builder.value;
        this.contractAddress = builder.contractAddress;
        this.tokenId = builder.tokenId;
        this.transactionId = builder.transactionId;
        this.voutIndex = builder.voutIndex;
    }

    /**
     * <p>
     * The blockchain network where the transaction occurred.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #network} will
     * return {@link QueryNetwork#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkAsString}.
     * </p>
     * 
     * @return The blockchain network where the transaction occurred.
     * @see QueryNetwork
     */
    public final QueryNetwork network() {
        return QueryNetwork.fromValue(network);
    }

    /**
     * <p>
     * The blockchain network where the transaction occurred.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #network} will
     * return {@link QueryNetwork#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkAsString}.
     * </p>
     * 
     * @return The blockchain network where the transaction occurred.
     * @see QueryNetwork
     */
    public final String networkAsString() {
        return network;
    }

    /**
     * <p>
     * The hash of the transaction. It is generated whenever a transaction is verified and added to the blockchain.
     * </p>
     * 
     * @return The hash of the transaction. It is generated whenever a transaction is verified and added to the
     *         blockchain.
     */
    public final String transactionHash() {
        return transactionHash;
    }

    /**
     * <p>
     * The type of transaction event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link QueryTransactionEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The type of transaction event.
     * @see QueryTransactionEventType
     */
    public final QueryTransactionEventType eventType() {
        return QueryTransactionEventType.fromValue(eventType);
    }

    /**
     * <p>
     * The type of transaction event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link QueryTransactionEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The type of transaction event.
     * @see QueryTransactionEventType
     */
    public final String eventTypeAsString() {
        return eventType;
    }

    /**
     * <p>
     * The wallet address initiating the transaction. It can either be a public key or a contract.
     * </p>
     * 
     * @return The wallet address initiating the transaction. It can either be a public key or a contract.
     */
    public final String from() {
        return from;
    }

    /**
     * <p>
     * The wallet address receiving the transaction. It can either be a public key or a contract.
     * </p>
     * 
     * @return The wallet address receiving the transaction. It can either be a public key or a contract.
     */
    public final String to() {
        return to;
    }

    /**
     * <p>
     * The value that was transacted.
     * </p>
     * 
     * @return The value that was transacted.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The blockchain address. for the contract
     * </p>
     * 
     * @return The blockchain address. for the contract
     */
    public final String contractAddress() {
        return contractAddress;
    }

    /**
     * <p>
     * The unique identifier for the token involved in the transaction.
     * </p>
     * 
     * @return The unique identifier for the token involved in the transaction.
     */
    public final String tokenId() {
        return tokenId;
    }

    /**
     * <p>
     * The unique identifier of the transaction. It is generated whenever a transaction is verified and added to the
     * blockchain.
     * </p>
     * 
     * @return The unique identifier of the transaction. It is generated whenever a transaction is verified and added to
     *         the blockchain.
     */
    public final String transactionId() {
        return transactionId;
    }

    /**
     * <p>
     * The position of the vout in the transaction output list.
     * </p>
     * 
     * @return The position of the vout in the transaction output list.
     */
    public final Integer voutIndex() {
        return voutIndex;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkAsString());
        hashCode = 31 * hashCode + Objects.hashCode(transactionHash());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(from());
        hashCode = 31 * hashCode + Objects.hashCode(to());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(contractAddress());
        hashCode = 31 * hashCode + Objects.hashCode(tokenId());
        hashCode = 31 * hashCode + Objects.hashCode(transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(voutIndex());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactionEvent)) {
            return false;
        }
        TransactionEvent other = (TransactionEvent) obj;
        return Objects.equals(networkAsString(), other.networkAsString())
                && Objects.equals(transactionHash(), other.transactionHash())
                && Objects.equals(eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(from(), other.from())
                && Objects.equals(to(), other.to()) && Objects.equals(value(), other.value())
                && Objects.equals(contractAddress(), other.contractAddress()) && Objects.equals(tokenId(), other.tokenId())
                && Objects.equals(transactionId(), other.transactionId()) && Objects.equals(voutIndex(), other.voutIndex());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransactionEvent").add("Network", networkAsString()).add("TransactionHash", transactionHash())
                .add("EventType", eventTypeAsString()).add("From", from()).add("To", to()).add("Value", value())
                .add("ContractAddress", contractAddress()).add("TokenId", tokenId()).add("TransactionId", transactionId())
                .add("VoutIndex", voutIndex()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "network":
            return Optional.ofNullable(clazz.cast(networkAsString()));
        case "transactionHash":
            return Optional.ofNullable(clazz.cast(transactionHash()));
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "from":
            return Optional.ofNullable(clazz.cast(from()));
        case "to":
            return Optional.ofNullable(clazz.cast(to()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "contractAddress":
            return Optional.ofNullable(clazz.cast(contractAddress()));
        case "tokenId":
            return Optional.ofNullable(clazz.cast(tokenId()));
        case "transactionId":
            return Optional.ofNullable(clazz.cast(transactionId()));
        case "voutIndex":
            return Optional.ofNullable(clazz.cast(voutIndex()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransactionEvent, T> g) {
        return obj -> g.apply((TransactionEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransactionEvent> {
        /**
         * <p>
         * The blockchain network where the transaction occurred.
         * </p>
         * 
         * @param network
         *        The blockchain network where the transaction occurred.
         * @see QueryNetwork
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryNetwork
         */
        Builder network(String network);

        /**
         * <p>
         * The blockchain network where the transaction occurred.
         * </p>
         * 
         * @param network
         *        The blockchain network where the transaction occurred.
         * @see QueryNetwork
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryNetwork
         */
        Builder network(QueryNetwork network);

        /**
         * <p>
         * The hash of the transaction. It is generated whenever a transaction is verified and added to the blockchain.
         * </p>
         * 
         * @param transactionHash
         *        The hash of the transaction. It is generated whenever a transaction is verified and added to the
         *        blockchain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionHash(String transactionHash);

        /**
         * <p>
         * The type of transaction event.
         * </p>
         * 
         * @param eventType
         *        The type of transaction event.
         * @see QueryTransactionEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryTransactionEventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The type of transaction event.
         * </p>
         * 
         * @param eventType
         *        The type of transaction event.
         * @see QueryTransactionEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryTransactionEventType
         */
        Builder eventType(QueryTransactionEventType eventType);

        /**
         * <p>
         * The wallet address initiating the transaction. It can either be a public key or a contract.
         * </p>
         * 
         * @param from
         *        The wallet address initiating the transaction. It can either be a public key or a contract.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder from(String from);

        /**
         * <p>
         * The wallet address receiving the transaction. It can either be a public key or a contract.
         * </p>
         * 
         * @param to
         *        The wallet address receiving the transaction. It can either be a public key or a contract.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder to(String to);

        /**
         * <p>
         * The value that was transacted.
         * </p>
         * 
         * @param value
         *        The value that was transacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The blockchain address. for the contract
         * </p>
         * 
         * @param contractAddress
         *        The blockchain address. for the contract
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contractAddress(String contractAddress);

        /**
         * <p>
         * The unique identifier for the token involved in the transaction.
         * </p>
         * 
         * @param tokenId
         *        The unique identifier for the token involved in the transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenId(String tokenId);

        /**
         * <p>
         * The unique identifier of the transaction. It is generated whenever a transaction is verified and added to the
         * blockchain.
         * </p>
         * 
         * @param transactionId
         *        The unique identifier of the transaction. It is generated whenever a transaction is verified and added
         *        to the blockchain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        /**
         * <p>
         * The position of the vout in the transaction output list.
         * </p>
         * 
         * @param voutIndex
         *        The position of the vout in the transaction output list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voutIndex(Integer voutIndex);
    }

    static final class BuilderImpl implements Builder {
        private String network;

        private String transactionHash;

        private String eventType;

        private String from;

        private String to;

        private String value;

        private String contractAddress;

        private String tokenId;

        private String transactionId;

        private Integer voutIndex;

        private BuilderImpl() {
        }

        private BuilderImpl(TransactionEvent model) {
            network(model.network);
            transactionHash(model.transactionHash);
            eventType(model.eventType);
            from(model.from);
            to(model.to);
            value(model.value);
            contractAddress(model.contractAddress);
            tokenId(model.tokenId);
            transactionId(model.transactionId);
            voutIndex(model.voutIndex);
        }

        public final String getNetwork() {
            return network;
        }

        public final void setNetwork(String network) {
            this.network = network;
        }

        @Override
        public final Builder network(String network) {
            this.network = network;
            return this;
        }

        @Override
        public final Builder network(QueryNetwork network) {
            this.network(network == null ? null : network.toString());
            return this;
        }

        public final String getTransactionHash() {
            return transactionHash;
        }

        public final void setTransactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
        }

        @Override
        public final Builder transactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
            return this;
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(QueryTransactionEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final String getFrom() {
            return from;
        }

        public final void setFrom(String from) {
            this.from = from;
        }

        @Override
        public final Builder from(String from) {
            this.from = from;
            return this;
        }

        public final String getTo() {
            return to;
        }

        public final void setTo(String to) {
            this.to = to;
        }

        @Override
        public final Builder to(String to) {
            this.to = to;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getContractAddress() {
            return contractAddress;
        }

        public final void setContractAddress(String contractAddress) {
            this.contractAddress = contractAddress;
        }

        @Override
        public final Builder contractAddress(String contractAddress) {
            this.contractAddress = contractAddress;
            return this;
        }

        public final String getTokenId() {
            return tokenId;
        }

        public final void setTokenId(String tokenId) {
            this.tokenId = tokenId;
        }

        @Override
        public final Builder tokenId(String tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public final String getTransactionId() {
            return transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final Integer getVoutIndex() {
            return voutIndex;
        }

        public final void setVoutIndex(Integer voutIndex) {
            this.voutIndex = voutIndex;
        }

        @Override
        public final Builder voutIndex(Integer voutIndex) {
            this.voutIndex = voutIndex;
            return this;
        }

        @Override
        public TransactionEvent build() {
            return new TransactionEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
