/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The balance of the token.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TokenBalance implements SdkPojo, Serializable, ToCopyableBuilder<TokenBalance.Builder, TokenBalance> {
    private static final SdkField<OwnerIdentifier> OWNER_IDENTIFIER_FIELD = SdkField
            .<OwnerIdentifier> builder(MarshallingType.SDK_POJO).memberName("ownerIdentifier")
            .getter(getter(TokenBalance::ownerIdentifier)).setter(setter(Builder::ownerIdentifier))
            .constructor(OwnerIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerIdentifier").build()).build();

    private static final SdkField<TokenIdentifier> TOKEN_IDENTIFIER_FIELD = SdkField
            .<TokenIdentifier> builder(MarshallingType.SDK_POJO).memberName("tokenIdentifier")
            .getter(getter(TokenBalance::tokenIdentifier)).setter(setter(Builder::tokenIdentifier))
            .constructor(TokenIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenIdentifier").build()).build();

    private static final SdkField<String> BALANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("balance")
            .getter(getter(TokenBalance::balance)).setter(setter(Builder::balance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("balance").build()).build();

    private static final SdkField<BlockchainInstant> AT_BLOCKCHAIN_INSTANT_FIELD = SdkField
            .<BlockchainInstant> builder(MarshallingType.SDK_POJO).memberName("atBlockchainInstant")
            .getter(getter(TokenBalance::atBlockchainInstant)).setter(setter(Builder::atBlockchainInstant))
            .constructor(BlockchainInstant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("atBlockchainInstant").build())
            .build();

    private static final SdkField<BlockchainInstant> LAST_UPDATED_TIME_FIELD = SdkField
            .<BlockchainInstant> builder(MarshallingType.SDK_POJO).memberName("lastUpdatedTime")
            .getter(getter(TokenBalance::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .constructor(BlockchainInstant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_IDENTIFIER_FIELD,
            TOKEN_IDENTIFIER_FIELD, BALANCE_FIELD, AT_BLOCKCHAIN_INSTANT_FIELD, LAST_UPDATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final OwnerIdentifier ownerIdentifier;

    private final TokenIdentifier tokenIdentifier;

    private final String balance;

    private final BlockchainInstant atBlockchainInstant;

    private final BlockchainInstant lastUpdatedTime;

    private TokenBalance(BuilderImpl builder) {
        this.ownerIdentifier = builder.ownerIdentifier;
        this.tokenIdentifier = builder.tokenIdentifier;
        this.balance = builder.balance;
        this.atBlockchainInstant = builder.atBlockchainInstant;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * The container for the identifier of the owner.
     * </p>
     * 
     * @return The container for the identifier of the owner.
     */
    public final OwnerIdentifier ownerIdentifier() {
        return ownerIdentifier;
    }

    /**
     * <p>
     * The identifier for the token, including the unique token ID and its blockchain network.
     * </p>
     * 
     * @return The identifier for the token, including the unique token ID and its blockchain network.
     */
    public final TokenIdentifier tokenIdentifier() {
        return tokenIdentifier;
    }

    /**
     * <p>
     * The container of the token balance.
     * </p>
     * 
     * @return The container of the token balance.
     */
    public final String balance() {
        return balance;
    }

    /**
     * <p>
     * The time for when the TokenBalance is requested or the current time if a time is not provided in the request.
     * </p>
     * <note>
     * <p>
     * This time will only be recorded up to the second.
     * </p>
     * </note>
     * 
     * @return The time for when the TokenBalance is requested or the current time if a time is not provided in the
     *         request.</p> <note>
     *         <p>
     *         This time will only be recorded up to the second.
     *         </p>
     */
    public final BlockchainInstant atBlockchainInstant() {
        return atBlockchainInstant;
    }

    /**
     * <p>
     * The <code>timestamp</code> of the last transaction at which the balance for the token in the wallet was updated.
     * </p>
     * 
     * @return The <code>timestamp</code> of the last transaction at which the balance for the token in the wallet was
     *         updated.
     */
    public final BlockchainInstant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ownerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(tokenIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(balance());
        hashCode = 31 * hashCode + Objects.hashCode(atBlockchainInstant());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TokenBalance)) {
            return false;
        }
        TokenBalance other = (TokenBalance) obj;
        return Objects.equals(ownerIdentifier(), other.ownerIdentifier())
                && Objects.equals(tokenIdentifier(), other.tokenIdentifier()) && Objects.equals(balance(), other.balance())
                && Objects.equals(atBlockchainInstant(), other.atBlockchainInstant())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TokenBalance").add("OwnerIdentifier", ownerIdentifier())
                .add("TokenIdentifier", tokenIdentifier()).add("Balance", balance())
                .add("AtBlockchainInstant", atBlockchainInstant()).add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ownerIdentifier":
            return Optional.ofNullable(clazz.cast(ownerIdentifier()));
        case "tokenIdentifier":
            return Optional.ofNullable(clazz.cast(tokenIdentifier()));
        case "balance":
            return Optional.ofNullable(clazz.cast(balance()));
        case "atBlockchainInstant":
            return Optional.ofNullable(clazz.cast(atBlockchainInstant()));
        case "lastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TokenBalance, T> g) {
        return obj -> g.apply((TokenBalance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TokenBalance> {
        /**
         * <p>
         * The container for the identifier of the owner.
         * </p>
         * 
         * @param ownerIdentifier
         *        The container for the identifier of the owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerIdentifier(OwnerIdentifier ownerIdentifier);

        /**
         * <p>
         * The container for the identifier of the owner.
         * </p>
         * This is a convenience method that creates an instance of the {@link OwnerIdentifier.Builder} avoiding the
         * need to create one manually via {@link OwnerIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OwnerIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #ownerIdentifier(OwnerIdentifier)}.
         * 
         * @param ownerIdentifier
         *        a consumer that will call methods on {@link OwnerIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ownerIdentifier(OwnerIdentifier)
         */
        default Builder ownerIdentifier(Consumer<OwnerIdentifier.Builder> ownerIdentifier) {
            return ownerIdentifier(OwnerIdentifier.builder().applyMutation(ownerIdentifier).build());
        }

        /**
         * <p>
         * The identifier for the token, including the unique token ID and its blockchain network.
         * </p>
         * 
         * @param tokenIdentifier
         *        The identifier for the token, including the unique token ID and its blockchain network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenIdentifier(TokenIdentifier tokenIdentifier);

        /**
         * <p>
         * The identifier for the token, including the unique token ID and its blockchain network.
         * </p>
         * This is a convenience method that creates an instance of the {@link TokenIdentifier.Builder} avoiding the
         * need to create one manually via {@link TokenIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TokenIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #tokenIdentifier(TokenIdentifier)}.
         * 
         * @param tokenIdentifier
         *        a consumer that will call methods on {@link TokenIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tokenIdentifier(TokenIdentifier)
         */
        default Builder tokenIdentifier(Consumer<TokenIdentifier.Builder> tokenIdentifier) {
            return tokenIdentifier(TokenIdentifier.builder().applyMutation(tokenIdentifier).build());
        }

        /**
         * <p>
         * The container of the token balance.
         * </p>
         * 
         * @param balance
         *        The container of the token balance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder balance(String balance);

        /**
         * <p>
         * The time for when the TokenBalance is requested or the current time if a time is not provided in the request.
         * </p>
         * <note>
         * <p>
         * This time will only be recorded up to the second.
         * </p>
         * </note>
         * 
         * @param atBlockchainInstant
         *        The time for when the TokenBalance is requested or the current time if a time is not provided in the
         *        request.</p> <note>
         *        <p>
         *        This time will only be recorded up to the second.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder atBlockchainInstant(BlockchainInstant atBlockchainInstant);

        /**
         * <p>
         * The time for when the TokenBalance is requested or the current time if a time is not provided in the request.
         * </p>
         * <note>
         * <p>
         * This time will only be recorded up to the second.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link BlockchainInstant.Builder}
         * avoiding the need to create one manually via {@link BlockchainInstant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlockchainInstant.Builder#build()} is called immediately and its
         * result is passed to {@link #atBlockchainInstant(BlockchainInstant)}.
         * 
         * @param atBlockchainInstant
         *        a consumer that will call methods on {@link BlockchainInstant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #atBlockchainInstant(BlockchainInstant)
         */
        default Builder atBlockchainInstant(Consumer<BlockchainInstant.Builder> atBlockchainInstant) {
            return atBlockchainInstant(BlockchainInstant.builder().applyMutation(atBlockchainInstant).build());
        }

        /**
         * <p>
         * The <code>timestamp</code> of the last transaction at which the balance for the token in the wallet was
         * updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The <code>timestamp</code> of the last transaction at which the balance for the token in the wallet
         *        was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(BlockchainInstant lastUpdatedTime);

        /**
         * <p>
         * The <code>timestamp</code> of the last transaction at which the balance for the token in the wallet was
         * updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link BlockchainInstant.Builder} avoiding the
         * need to create one manually via {@link BlockchainInstant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlockchainInstant.Builder#build()} is called immediately and its
         * result is passed to {@link #lastUpdatedTime(BlockchainInstant)}.
         * 
         * @param lastUpdatedTime
         *        a consumer that will call methods on {@link BlockchainInstant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastUpdatedTime(BlockchainInstant)
         */
        default Builder lastUpdatedTime(Consumer<BlockchainInstant.Builder> lastUpdatedTime) {
            return lastUpdatedTime(BlockchainInstant.builder().applyMutation(lastUpdatedTime).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OwnerIdentifier ownerIdentifier;

        private TokenIdentifier tokenIdentifier;

        private String balance;

        private BlockchainInstant atBlockchainInstant;

        private BlockchainInstant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TokenBalance model) {
            ownerIdentifier(model.ownerIdentifier);
            tokenIdentifier(model.tokenIdentifier);
            balance(model.balance);
            atBlockchainInstant(model.atBlockchainInstant);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final OwnerIdentifier.Builder getOwnerIdentifier() {
            return ownerIdentifier != null ? ownerIdentifier.toBuilder() : null;
        }

        public final void setOwnerIdentifier(OwnerIdentifier.BuilderImpl ownerIdentifier) {
            this.ownerIdentifier = ownerIdentifier != null ? ownerIdentifier.build() : null;
        }

        @Override
        public final Builder ownerIdentifier(OwnerIdentifier ownerIdentifier) {
            this.ownerIdentifier = ownerIdentifier;
            return this;
        }

        public final TokenIdentifier.Builder getTokenIdentifier() {
            return tokenIdentifier != null ? tokenIdentifier.toBuilder() : null;
        }

        public final void setTokenIdentifier(TokenIdentifier.BuilderImpl tokenIdentifier) {
            this.tokenIdentifier = tokenIdentifier != null ? tokenIdentifier.build() : null;
        }

        @Override
        public final Builder tokenIdentifier(TokenIdentifier tokenIdentifier) {
            this.tokenIdentifier = tokenIdentifier;
            return this;
        }

        public final String getBalance() {
            return balance;
        }

        public final void setBalance(String balance) {
            this.balance = balance;
        }

        @Override
        public final Builder balance(String balance) {
            this.balance = balance;
            return this;
        }

        public final BlockchainInstant.Builder getAtBlockchainInstant() {
            return atBlockchainInstant != null ? atBlockchainInstant.toBuilder() : null;
        }

        public final void setAtBlockchainInstant(BlockchainInstant.BuilderImpl atBlockchainInstant) {
            this.atBlockchainInstant = atBlockchainInstant != null ? atBlockchainInstant.build() : null;
        }

        @Override
        public final Builder atBlockchainInstant(BlockchainInstant atBlockchainInstant) {
            this.atBlockchainInstant = atBlockchainInstant;
            return this;
        }

        public final BlockchainInstant.Builder getLastUpdatedTime() {
            return lastUpdatedTime != null ? lastUpdatedTime.toBuilder() : null;
        }

        public final void setLastUpdatedTime(BlockchainInstant.BuilderImpl lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime != null ? lastUpdatedTime.build() : null;
        }

        @Override
        public final Builder lastUpdatedTime(BlockchainInstant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public TokenBalance build() {
            return new TokenBalance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
