/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an S3 object that Amazon Macie selected for analysis while performing automated sensitive
 * data discovery for an S3 bucket, and the status and results of the analysis. This information is available only if
 * automated sensitive data discovery is currently enabled for your account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceProfileArtifact implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceProfileArtifact.Builder, ResourceProfileArtifact> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(ResourceProfileArtifact::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CLASSIFICATION_RESULT_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("classificationResultStatus")
            .getter(getter(ResourceProfileArtifact::classificationResultStatus))
            .setter(setter(Builder::classificationResultStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classificationResultStatus").build())
            .build();

    private static final SdkField<Boolean> SENSITIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("sensitive").getter(getter(ResourceProfileArtifact::sensitive)).setter(setter(Builder::sensitive))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitive").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CLASSIFICATION_RESULT_STATUS_FIELD, SENSITIVE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String classificationResultStatus;

    private final Boolean sensitive;

    private ResourceProfileArtifact(BuilderImpl builder) {
        this.arn = builder.arn;
        this.classificationResultStatus = builder.classificationResultStatus;
        this.sensitive = builder.sensitive;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the object.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the object.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the analysis. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * COMPLETE - Amazon Macie successfully completed its analysis of the object.
     * </p>
     * </li>
     * <li>
     * <p>
     * PARTIAL - Macie analyzed only a subset of data in the object. For example, the object is an archive file that
     * contains files in an unsupported format.
     * </p>
     * </li>
     * <li>
     * <p>
     * SKIPPED - Macie wasn't able to analyze the object. For example, the object is a malformed file.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the analysis. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         COMPLETE - Amazon Macie successfully completed its analysis of the object.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PARTIAL - Macie analyzed only a subset of data in the object. For example, the object is an archive file
     *         that contains files in an unsupported format.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SKIPPED - Macie wasn't able to analyze the object. For example, the object is a malformed file.
     *         </p>
     *         </li>
     */
    public final String classificationResultStatus() {
        return classificationResultStatus;
    }

    /**
     * <p>
     * Specifies whether Amazon Macie found sensitive data in the object.
     * </p>
     * 
     * @return Specifies whether Amazon Macie found sensitive data in the object.
     */
    public final Boolean sensitive() {
        return sensitive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(classificationResultStatus());
        hashCode = 31 * hashCode + Objects.hashCode(sensitive());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceProfileArtifact)) {
            return false;
        }
        ResourceProfileArtifact other = (ResourceProfileArtifact) obj;
        return Objects.equals(arn(), other.arn())
                && Objects.equals(classificationResultStatus(), other.classificationResultStatus())
                && Objects.equals(sensitive(), other.sensitive());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceProfileArtifact").add("Arn", arn())
                .add("ClassificationResultStatus", classificationResultStatus()).add("Sensitive", sensitive()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "classificationResultStatus":
            return Optional.ofNullable(clazz.cast(classificationResultStatus()));
        case "sensitive":
            return Optional.ofNullable(clazz.cast(sensitive()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceProfileArtifact, T> g) {
        return obj -> g.apply((ResourceProfileArtifact) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceProfileArtifact> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the object.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the analysis. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * COMPLETE - Amazon Macie successfully completed its analysis of the object.
         * </p>
         * </li>
         * <li>
         * <p>
         * PARTIAL - Macie analyzed only a subset of data in the object. For example, the object is an archive file that
         * contains files in an unsupported format.
         * </p>
         * </li>
         * <li>
         * <p>
         * SKIPPED - Macie wasn't able to analyze the object. For example, the object is a malformed file.
         * </p>
         * </li>
         * </ul>
         * 
         * @param classificationResultStatus
         *        The status of the analysis. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        COMPLETE - Amazon Macie successfully completed its analysis of the object.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PARTIAL - Macie analyzed only a subset of data in the object. For example, the object is an archive
         *        file that contains files in an unsupported format.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SKIPPED - Macie wasn't able to analyze the object. For example, the object is a malformed file.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classificationResultStatus(String classificationResultStatus);

        /**
         * <p>
         * Specifies whether Amazon Macie found sensitive data in the object.
         * </p>
         * 
         * @param sensitive
         *        Specifies whether Amazon Macie found sensitive data in the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitive(Boolean sensitive);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String classificationResultStatus;

        private Boolean sensitive;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceProfileArtifact model) {
            arn(model.arn);
            classificationResultStatus(model.classificationResultStatus);
            sensitive(model.sensitive);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClassificationResultStatus() {
            return classificationResultStatus;
        }

        public final void setClassificationResultStatus(String classificationResultStatus) {
            this.classificationResultStatus = classificationResultStatus;
        }

        @Override
        public final Builder classificationResultStatus(String classificationResultStatus) {
            this.classificationResultStatus = classificationResultStatus;
            return this;
        }

        public final Boolean getSensitive() {
            return sensitive;
        }

        public final void setSensitive(Boolean sensitive) {
            this.sensitive = sensitive;
        }

        @Override
        public final Builder sensitive(Boolean sensitive) {
            this.sensitive = sensitive;
            return this;
        }

        @Override
        public ResourceProfileArtifact build() {
            return new ResourceProfileArtifact(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
