/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSensitiveDataOccurrencesResponse extends Macie2Response implements
        ToCopyableBuilder<GetSensitiveDataOccurrencesResponse.Builder, GetSensitiveDataOccurrencesResponse> {
    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("error")
            .getter(getter(GetSensitiveDataOccurrencesResponse::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<Map<String, List<DetectedDataDetails>>> SENSITIVE_DATA_OCCURRENCES_FIELD = SdkField
            .<Map<String, List<DetectedDataDetails>>> builder(MarshallingType.MAP)
            .memberName("sensitiveDataOccurrences")
            .getter(getter(GetSensitiveDataOccurrencesResponse::sensitiveDataOccurrences))
            .setter(setter(Builder::sensitiveDataOccurrences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitiveDataOccurrences").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<DetectedDataDetails>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<DetectedDataDetails> builder(
                                                                            MarshallingType.SDK_POJO)
                                                                            .constructor(DetectedDataDetails::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetSensitiveDataOccurrencesResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD,
            SENSITIVE_DATA_OCCURRENCES_FIELD, STATUS_FIELD));

    private final String error;

    private final Map<String, List<DetectedDataDetails>> sensitiveDataOccurrences;

    private final String status;

    private GetSensitiveDataOccurrencesResponse(BuilderImpl builder) {
        super(builder);
        this.error = builder.error;
        this.sensitiveDataOccurrences = builder.sensitiveDataOccurrences;
        this.status = builder.status;
    }

    /**
     * <p>
     * If an error occurred when Amazon Macie attempted to retrieve occurrences of sensitive data reported by the
     * finding, a description of the error that occurred. This value is null if the status (status) of the request is
     * PROCESSING or SUCCESS.
     * </p>
     * 
     * @return If an error occurred when Amazon Macie attempted to retrieve occurrences of sensitive data reported by
     *         the finding, a description of the error that occurred. This value is null if the status (status) of the
     *         request is PROCESSING or SUCCESS.
     */
    public final String error() {
        return error;
    }

    /**
     * For responses, this returns true if the service returned a value for the SensitiveDataOccurrences property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSensitiveDataOccurrences() {
        return sensitiveDataOccurrences != null && !(sensitiveDataOccurrences instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map that specifies 1-100 types of sensitive data reported by the finding and, for each type, 1-10 occurrences
     * of sensitive data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSensitiveDataOccurrences} method.
     * </p>
     * 
     * @return A map that specifies 1-100 types of sensitive data reported by the finding and, for each type, 1-10
     *         occurrences of sensitive data.
     */
    public final Map<String, List<DetectedDataDetails>> sensitiveDataOccurrences() {
        return sensitiveDataOccurrences;
    }

    /**
     * <p>
     * The status of the request to retrieve occurrences of sensitive data reported by the finding. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ERROR - An error occurred when Amazon Macie attempted to locate, retrieve, or encrypt the sensitive data. The
     * error value indicates the nature of the error that occurred.
     * </p>
     * </li>
     * <li>
     * <p>
     * PROCESSING - Macie is processing the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * SUCCESS - Macie successfully located, retrieved, and encrypted the sensitive data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RevealRequestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the request to retrieve occurrences of sensitive data reported by the finding. Possible
     *         values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ERROR - An error occurred when Amazon Macie attempted to locate, retrieve, or encrypt the sensitive data.
     *         The error value indicates the nature of the error that occurred.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PROCESSING - Macie is processing the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SUCCESS - Macie successfully located, retrieved, and encrypted the sensitive data.
     *         </p>
     *         </li>
     * @see RevealRequestStatus
     */
    public final RevealRequestStatus status() {
        return RevealRequestStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the request to retrieve occurrences of sensitive data reported by the finding. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ERROR - An error occurred when Amazon Macie attempted to locate, retrieve, or encrypt the sensitive data. The
     * error value indicates the nature of the error that occurred.
     * </p>
     * </li>
     * <li>
     * <p>
     * PROCESSING - Macie is processing the request.
     * </p>
     * </li>
     * <li>
     * <p>
     * SUCCESS - Macie successfully located, retrieved, and encrypted the sensitive data.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RevealRequestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the request to retrieve occurrences of sensitive data reported by the finding. Possible
     *         values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ERROR - An error occurred when Amazon Macie attempted to locate, retrieve, or encrypt the sensitive data.
     *         The error value indicates the nature of the error that occurred.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PROCESSING - Macie is processing the request.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SUCCESS - Macie successfully located, retrieved, and encrypted the sensitive data.
     *         </p>
     *         </li>
     * @see RevealRequestStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(hasSensitiveDataOccurrences() ? sensitiveDataOccurrences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSensitiveDataOccurrencesResponse)) {
            return false;
        }
        GetSensitiveDataOccurrencesResponse other = (GetSensitiveDataOccurrencesResponse) obj;
        return Objects.equals(error(), other.error()) && hasSensitiveDataOccurrences() == other.hasSensitiveDataOccurrences()
                && Objects.equals(sensitiveDataOccurrences(), other.sensitiveDataOccurrences())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSensitiveDataOccurrencesResponse").add("Error", error())
                .add("SensitiveDataOccurrences", hasSensitiveDataOccurrences() ? sensitiveDataOccurrences() : null)
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "sensitiveDataOccurrences":
            return Optional.ofNullable(clazz.cast(sensitiveDataOccurrences()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSensitiveDataOccurrencesResponse, T> g) {
        return obj -> g.apply((GetSensitiveDataOccurrencesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSensitiveDataOccurrencesResponse> {
        /**
         * <p>
         * If an error occurred when Amazon Macie attempted to retrieve occurrences of sensitive data reported by the
         * finding, a description of the error that occurred. This value is null if the status (status) of the request
         * is PROCESSING or SUCCESS.
         * </p>
         * 
         * @param error
         *        If an error occurred when Amazon Macie attempted to retrieve occurrences of sensitive data reported by
         *        the finding, a description of the error that occurred. This value is null if the status (status) of
         *        the request is PROCESSING or SUCCESS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * <p>
         * A map that specifies 1-100 types of sensitive data reported by the finding and, for each type, 1-10
         * occurrences of sensitive data.
         * </p>
         * 
         * @param sensitiveDataOccurrences
         *        A map that specifies 1-100 types of sensitive data reported by the finding and, for each type, 1-10
         *        occurrences of sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensitiveDataOccurrences(Map<String, ? extends Collection<DetectedDataDetails>> sensitiveDataOccurrences);

        /**
         * <p>
         * The status of the request to retrieve occurrences of sensitive data reported by the finding. Possible values
         * are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ERROR - An error occurred when Amazon Macie attempted to locate, retrieve, or encrypt the sensitive data. The
         * error value indicates the nature of the error that occurred.
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING - Macie is processing the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * SUCCESS - Macie successfully located, retrieved, and encrypted the sensitive data.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the request to retrieve occurrences of sensitive data reported by the finding. Possible
         *        values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ERROR - An error occurred when Amazon Macie attempted to locate, retrieve, or encrypt the sensitive
         *        data. The error value indicates the nature of the error that occurred.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING - Macie is processing the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SUCCESS - Macie successfully located, retrieved, and encrypted the sensitive data.
         *        </p>
         *        </li>
         * @see RevealRequestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevealRequestStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the request to retrieve occurrences of sensitive data reported by the finding. Possible values
         * are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ERROR - An error occurred when Amazon Macie attempted to locate, retrieve, or encrypt the sensitive data. The
         * error value indicates the nature of the error that occurred.
         * </p>
         * </li>
         * <li>
         * <p>
         * PROCESSING - Macie is processing the request.
         * </p>
         * </li>
         * <li>
         * <p>
         * SUCCESS - Macie successfully located, retrieved, and encrypted the sensitive data.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the request to retrieve occurrences of sensitive data reported by the finding. Possible
         *        values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ERROR - An error occurred when Amazon Macie attempted to locate, retrieve, or encrypt the sensitive
         *        data. The error value indicates the nature of the error that occurred.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PROCESSING - Macie is processing the request.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SUCCESS - Macie successfully located, retrieved, and encrypted the sensitive data.
         *        </p>
         *        </li>
         * @see RevealRequestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevealRequestStatus
         */
        Builder status(RevealRequestStatus status);
    }

    static final class BuilderImpl extends Macie2Response.BuilderImpl implements Builder {
        private String error;

        private Map<String, List<DetectedDataDetails>> sensitiveDataOccurrences = DefaultSdkAutoConstructMap.getInstance();

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSensitiveDataOccurrencesResponse model) {
            super(model);
            error(model.error);
            sensitiveDataOccurrences(model.sensitiveDataOccurrences);
            status(model.status);
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final Map<String, List<DetectedDataDetails.Builder>> getSensitiveDataOccurrences() {
            Map<String, List<DetectedDataDetails.Builder>> result = SensitiveDataOccurrencesCopier
                    .copyToBuilder(this.sensitiveDataOccurrences);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setSensitiveDataOccurrences(
                Map<String, ? extends Collection<DetectedDataDetails.BuilderImpl>> sensitiveDataOccurrences) {
            this.sensitiveDataOccurrences = SensitiveDataOccurrencesCopier.copyFromBuilder(sensitiveDataOccurrences);
        }

        @Override
        public final Builder sensitiveDataOccurrences(
                Map<String, ? extends Collection<DetectedDataDetails>> sensitiveDataOccurrences) {
            this.sensitiveDataOccurrences = SensitiveDataOccurrencesCopier.copy(sensitiveDataOccurrences);
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RevealRequestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetSensitiveDataOccurrencesResponse build() {
            return new GetSensitiveDataOccurrencesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
