/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMemberRequest extends Macie2Request implements
        ToCopyableBuilder<CreateMemberRequest.Builder, CreateMemberRequest> {
    private static final SdkField<AccountDetail> ACCOUNT_FIELD = SdkField.<AccountDetail> builder(MarshallingType.SDK_POJO)
            .memberName("account").getter(getter(CreateMemberRequest::account)).setter(setter(Builder::account))
            .constructor(AccountDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("account").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateMemberRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_FIELD, TAGS_FIELD));

    private final AccountDetail account;

    private final Map<String, String> tags;

    private CreateMemberRequest(BuilderImpl builder) {
        super(builder);
        this.account = builder.account;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The details of the account to associate with the administrator account.
     * </p>
     * 
     * @return The details of the account to associate with the administrator account.
     */
    public final AccountDetail account() {
        return account;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs that specifies the tags to associate with the account in Amazon Macie.
     * </p>
     * <p>
     * An account can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum
     * length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of key-value pairs that specifies the tags to associate with the account in Amazon Macie.</p>
     *         <p>
     *         An account can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The
     *         maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(account());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMemberRequest)) {
            return false;
        }
        CreateMemberRequest other = (CreateMemberRequest) obj;
        return Objects.equals(account(), other.account()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMemberRequest").add("Account", account()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "account":
            return Optional.ofNullable(clazz.cast(account()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMemberRequest, T> g) {
        return obj -> g.apply((CreateMemberRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateMemberRequest> {
        /**
         * <p>
         * The details of the account to associate with the administrator account.
         * </p>
         * 
         * @param account
         *        The details of the account to associate with the administrator account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(AccountDetail account);

        /**
         * <p>
         * The details of the account to associate with the administrator account.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountDetail.Builder} avoiding the need
         * to create one manually via {@link AccountDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountDetail.Builder#build()} is called immediately and its
         * result is passed to {@link #account(AccountDetail)}.
         * 
         * @param account
         *        a consumer that will call methods on {@link AccountDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #account(AccountDetail)
         */
        default Builder account(Consumer<AccountDetail.Builder> account) {
            return account(AccountDetail.builder().applyMutation(account).build());
        }

        /**
         * <p>
         * A map of key-value pairs that specifies the tags to associate with the account in Amazon Macie.
         * </p>
         * <p>
         * An account can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The
         * maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
         * </p>
         * 
         * @param tags
         *        A map of key-value pairs that specifies the tags to associate with the account in Amazon Macie.</p>
         *        <p>
         *        An account can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value.
         *        The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private AccountDetail account;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMemberRequest model) {
            super(model);
            account(model.account);
            tags(model.tags);
        }

        public final AccountDetail.Builder getAccount() {
            return account != null ? account.toBuilder() : null;
        }

        public final void setAccount(AccountDetail.BuilderImpl account) {
            this.account = account != null ? account.build() : null;
        }

        @Override
        public final Builder account(AccountDetail account) {
            this.account = account;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMemberRequest build() {
            return new CreateMemberRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
