/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAllowListRequest extends Macie2Request implements
        ToCopyableBuilder<CreateAllowListRequest.Builder, CreateAllowListRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateAllowListRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<AllowListCriteria> CRITERIA_FIELD = SdkField
            .<AllowListCriteria> builder(MarshallingType.SDK_POJO).memberName("criteria")
            .getter(getter(CreateAllowListRequest::criteria)).setter(setter(Builder::criteria))
            .constructor(AllowListCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("criteria").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateAllowListRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateAllowListRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateAllowListRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            CRITERIA_FIELD, DESCRIPTION_FIELD, NAME_FIELD, TAGS_FIELD));

    private final String clientToken;

    private final AllowListCriteria criteria;

    private final String description;

    private final String name;

    private final Map<String, String> tags;

    private CreateAllowListRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.criteria = builder.criteria;
        this.description = builder.description;
        this.name = builder.name;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The criteria that specify the text or text pattern to ignore. The criteria can be the location and name of an S3
     * object that lists specific text to ignore (s3WordsList), or a regular expression (regex) that defines a text
     * pattern to ignore.
     * </p>
     * 
     * @return The criteria that specify the text or text pattern to ignore. The criteria can be the location and name
     *         of an S3 object that lists specific text to ignore (s3WordsList), or a regular expression (regex) that
     *         defines a text pattern to ignore.
     */
    public final AllowListCriteria criteria() {
        return criteria;
    }

    /**
     * <p>
     * A custom description of the allow list. The description can contain as many as 512 characters.
     * </p>
     * 
     * @return A custom description of the allow list. The description can contain as many as 512 characters.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A custom name for the allow list. The name can contain as many as 128 characters.
     * </p>
     * 
     * @return A custom name for the allow list. The name can contain as many as 128 characters.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of key-value pairs that specifies the tags to associate with the allow list.
     * </p>
     * <p>
     * An allow list can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The
     * maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A map of key-value pairs that specifies the tags to associate with the allow list.</p>
     *         <p>
     *         An allow list can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value.
     *         The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(criteria());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAllowListRequest)) {
            return false;
        }
        CreateAllowListRequest other = (CreateAllowListRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(criteria(), other.criteria())
                && Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAllowListRequest").add("ClientToken", clientToken()).add("Criteria", criteria())
                .add("Description", description()).add("Name", name()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "criteria":
            return Optional.ofNullable(clazz.cast(criteria()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAllowListRequest, T> g) {
        return obj -> g.apply((CreateAllowListRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Macie2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateAllowListRequest> {
        /**
         * <p>
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The criteria that specify the text or text pattern to ignore. The criteria can be the location and name of an
         * S3 object that lists specific text to ignore (s3WordsList), or a regular expression (regex) that defines a
         * text pattern to ignore.
         * </p>
         * 
         * @param criteria
         *        The criteria that specify the text or text pattern to ignore. The criteria can be the location and
         *        name of an S3 object that lists specific text to ignore (s3WordsList), or a regular expression (regex)
         *        that defines a text pattern to ignore.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criteria(AllowListCriteria criteria);

        /**
         * <p>
         * The criteria that specify the text or text pattern to ignore. The criteria can be the location and name of an
         * S3 object that lists specific text to ignore (s3WordsList), or a regular expression (regex) that defines a
         * text pattern to ignore.
         * </p>
         * This is a convenience method that creates an instance of the {@link AllowListCriteria.Builder} avoiding the
         * need to create one manually via {@link AllowListCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AllowListCriteria.Builder#build()} is called immediately and its
         * result is passed to {@link #criteria(AllowListCriteria)}.
         * 
         * @param criteria
         *        a consumer that will call methods on {@link AllowListCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #criteria(AllowListCriteria)
         */
        default Builder criteria(Consumer<AllowListCriteria.Builder> criteria) {
            return criteria(AllowListCriteria.builder().applyMutation(criteria).build());
        }

        /**
         * <p>
         * A custom description of the allow list. The description can contain as many as 512 characters.
         * </p>
         * 
         * @param description
         *        A custom description of the allow list. The description can contain as many as 512 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A custom name for the allow list. The name can contain as many as 128 characters.
         * </p>
         * 
         * @param name
         *        A custom name for the allow list. The name can contain as many as 128 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A map of key-value pairs that specifies the tags to associate with the allow list.
         * </p>
         * <p>
         * An allow list can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The
         * maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
         * </p>
         * 
         * @param tags
         *        A map of key-value pairs that specifies the tags to associate with the allow list.</p>
         *        <p>
         *        An allow list can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag
         *        value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Macie2Request.BuilderImpl implements Builder {
        private String clientToken;

        private AllowListCriteria criteria;

        private String description;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAllowListRequest model) {
            super(model);
            clientToken(model.clientToken);
            criteria(model.criteria);
            description(model.description);
            name(model.name);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final AllowListCriteria.Builder getCriteria() {
            return criteria != null ? criteria.toBuilder() : null;
        }

        public final void setCriteria(AllowListCriteria.BuilderImpl criteria) {
            this.criteria = criteria != null ? criteria.build() : null;
        }

        @Override
        public final Builder criteria(AllowListCriteria criteria) {
            this.criteria = criteria;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAllowListRequest build() {
            return new CreateAllowListRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
