/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.services.macie2.model.ResourceProfileArtifact;
import software.amazon.awssdk.services.macie2.model.___listOfResourceProfileArtifactCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceProfileArtifactsResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, ListResourceProfileArtifactsResponse> {
    private static final SdkField<List<ResourceProfileArtifact>> ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("artifacts").getter(ListResourceProfileArtifactsResponse.getter(ListResourceProfileArtifactsResponse::artifacts)).setter(ListResourceProfileArtifactsResponse.setter(Builder::artifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceProfileArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListResourceProfileArtifactsResponse.getter(ListResourceProfileArtifactsResponse::nextToken)).setter(ListResourceProfileArtifactsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACTS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ResourceProfileArtifact> artifacts;
    private final String nextToken;

    private ListResourceProfileArtifactsResponse(BuilderImpl builder) {
        super(builder);
        this.artifacts = builder.artifacts;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasArtifacts() {
        return this.artifacts != null && !(this.artifacts instanceof SdkAutoConstructList);
    }

    public final List<ResourceProfileArtifact> artifacts() {
        return this.artifacts;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArtifacts() ? this.artifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceProfileArtifactsResponse)) {
            return false;
        }
        ListResourceProfileArtifactsResponse other = (ListResourceProfileArtifactsResponse)((Object)obj);
        return this.hasArtifacts() == other.hasArtifacts() && Objects.equals(this.artifacts(), other.artifacts()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceProfileArtifactsResponse").add("Artifacts", this.hasArtifacts() ? this.artifacts() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "artifacts": {
                return Optional.ofNullable(clazz.cast(this.artifacts()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceProfileArtifactsResponse, T> g) {
        return obj -> g.apply((ListResourceProfileArtifactsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private List<ResourceProfileArtifact> artifacts = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceProfileArtifactsResponse model) {
            super(model);
            this.artifacts(model.artifacts);
            this.nextToken(model.nextToken);
        }

        public final List<ResourceProfileArtifact.Builder> getArtifacts() {
            List<ResourceProfileArtifact.Builder> result = ___listOfResourceProfileArtifactCopier.copyToBuilder(this.artifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setArtifacts(Collection<ResourceProfileArtifact.BuilderImpl> artifacts) {
            this.artifacts = ___listOfResourceProfileArtifactCopier.copyFromBuilder(artifacts);
        }

        @Override
        public final Builder artifacts(Collection<ResourceProfileArtifact> artifacts) {
            this.artifacts = ___listOfResourceProfileArtifactCopier.copy(artifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifacts(ResourceProfileArtifact ... artifacts) {
            this.artifacts(Arrays.asList(artifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifacts(Consumer<ResourceProfileArtifact.Builder> ... artifacts) {
            this.artifacts(Stream.of(artifacts).map(c -> (ResourceProfileArtifact)((ResourceProfileArtifact.Builder)ResourceProfileArtifact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceProfileArtifactsResponse build() {
            return new ListResourceProfileArtifactsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceProfileArtifactsResponse> {
        public Builder artifacts(Collection<ResourceProfileArtifact> var1);

        public Builder artifacts(ResourceProfileArtifact ... var1);

        public Builder artifacts(Consumer<ResourceProfileArtifact.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

