/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.services.macie2.model.RelationshipStatus;
import software.amazon.awssdk.services.macie2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMemberResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, GetMemberResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(GetMemberResponse.getter(GetMemberResponse::accountId)).setter(GetMemberResponse.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> ADMINISTRATOR_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("administratorAccountId").getter(GetMemberResponse.getter(GetMemberResponse::administratorAccountId)).setter(GetMemberResponse.setter(Builder::administratorAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("administratorAccountId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetMemberResponse.getter(GetMemberResponse::arn)).setter(GetMemberResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> EMAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("email").getter(GetMemberResponse.getter(GetMemberResponse::email)).setter(GetMemberResponse.setter(Builder::email)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("email").build()}).build();
    private static final SdkField<Instant> INVITED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("invitedAt").getter(GetMemberResponse.getter(GetMemberResponse::invitedAt)).setter(GetMemberResponse.setter(Builder::invitedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invitedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> MASTER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("masterAccountId").getter(GetMemberResponse.getter(GetMemberResponse::masterAccountId)).setter(GetMemberResponse.setter(Builder::masterAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("masterAccountId").build()}).build();
    private static final SdkField<String> RELATIONSHIP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relationshipStatus").getter(GetMemberResponse.getter(GetMemberResponse::relationshipStatusAsString)).setter(GetMemberResponse.setter(Builder::relationshipStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationshipStatus").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetMemberResponse.getter(GetMemberResponse::tags)).setter(GetMemberResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetMemberResponse.getter(GetMemberResponse::updatedAt)).setter(GetMemberResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ADMINISTRATOR_ACCOUNT_ID_FIELD, ARN_FIELD, EMAIL_FIELD, INVITED_AT_FIELD, MASTER_ACCOUNT_ID_FIELD, RELATIONSHIP_STATUS_FIELD, TAGS_FIELD, UPDATED_AT_FIELD));
    private final String accountId;
    private final String administratorAccountId;
    private final String arn;
    private final String email;
    private final Instant invitedAt;
    private final String masterAccountId;
    private final String relationshipStatus;
    private final Map<String, String> tags;
    private final Instant updatedAt;

    private GetMemberResponse(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.administratorAccountId = builder.administratorAccountId;
        this.arn = builder.arn;
        this.email = builder.email;
        this.invitedAt = builder.invitedAt;
        this.masterAccountId = builder.masterAccountId;
        this.relationshipStatus = builder.relationshipStatus;
        this.tags = builder.tags;
        this.updatedAt = builder.updatedAt;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String administratorAccountId() {
        return this.administratorAccountId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String email() {
        return this.email;
    }

    public final Instant invitedAt() {
        return this.invitedAt;
    }

    public final String masterAccountId() {
        return this.masterAccountId;
    }

    public final RelationshipStatus relationshipStatus() {
        return RelationshipStatus.fromValue(this.relationshipStatus);
    }

    public final String relationshipStatusAsString() {
        return this.relationshipStatus;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.administratorAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.email());
        hashCode = 31 * hashCode + Objects.hashCode(this.invitedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.relationshipStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMemberResponse)) {
            return false;
        }
        GetMemberResponse other = (GetMemberResponse)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.administratorAccountId(), other.administratorAccountId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.email(), other.email()) && Objects.equals(this.invitedAt(), other.invitedAt()) && Objects.equals(this.masterAccountId(), other.masterAccountId()) && Objects.equals(this.relationshipStatusAsString(), other.relationshipStatusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetMemberResponse").add("AccountId", (Object)this.accountId()).add("AdministratorAccountId", (Object)this.administratorAccountId()).add("Arn", (Object)this.arn()).add("Email", (Object)this.email()).add("InvitedAt", (Object)this.invitedAt()).add("MasterAccountId", (Object)this.masterAccountId()).add("RelationshipStatus", (Object)this.relationshipStatusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "administratorAccountId": {
                return Optional.ofNullable(clazz.cast(this.administratorAccountId()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "email": {
                return Optional.ofNullable(clazz.cast(this.email()));
            }
            case "invitedAt": {
                return Optional.ofNullable(clazz.cast(this.invitedAt()));
            }
            case "masterAccountId": {
                return Optional.ofNullable(clazz.cast(this.masterAccountId()));
            }
            case "relationshipStatus": {
                return Optional.ofNullable(clazz.cast(this.relationshipStatusAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMemberResponse, T> g) {
        return obj -> g.apply((GetMemberResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private String accountId;
        private String administratorAccountId;
        private String arn;
        private String email;
        private Instant invitedAt;
        private String masterAccountId;
        private String relationshipStatus;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMemberResponse model) {
            super(model);
            this.accountId(model.accountId);
            this.administratorAccountId(model.administratorAccountId);
            this.arn(model.arn);
            this.email(model.email);
            this.invitedAt(model.invitedAt);
            this.masterAccountId(model.masterAccountId);
            this.relationshipStatus(model.relationshipStatus);
            this.tags(model.tags);
            this.updatedAt(model.updatedAt);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAdministratorAccountId() {
            return this.administratorAccountId;
        }

        public final void setAdministratorAccountId(String administratorAccountId) {
            this.administratorAccountId = administratorAccountId;
        }

        @Override
        public final Builder administratorAccountId(String administratorAccountId) {
            this.administratorAccountId = administratorAccountId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getEmail() {
            return this.email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final Instant getInvitedAt() {
            return this.invitedAt;
        }

        public final void setInvitedAt(Instant invitedAt) {
            this.invitedAt = invitedAt;
        }

        @Override
        public final Builder invitedAt(Instant invitedAt) {
            this.invitedAt = invitedAt;
            return this;
        }

        public final String getMasterAccountId() {
            return this.masterAccountId;
        }

        public final void setMasterAccountId(String masterAccountId) {
            this.masterAccountId = masterAccountId;
        }

        @Override
        public final Builder masterAccountId(String masterAccountId) {
            this.masterAccountId = masterAccountId;
            return this;
        }

        public final String getRelationshipStatus() {
            return this.relationshipStatus;
        }

        public final void setRelationshipStatus(String relationshipStatus) {
            this.relationshipStatus = relationshipStatus;
        }

        @Override
        public final Builder relationshipStatus(String relationshipStatus) {
            this.relationshipStatus = relationshipStatus;
            return this;
        }

        @Override
        public final Builder relationshipStatus(RelationshipStatus relationshipStatus) {
            this.relationshipStatus(relationshipStatus == null ? null : relationshipStatus.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetMemberResponse build() {
            return new GetMemberResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMemberResponse> {
        public Builder accountId(String var1);

        public Builder administratorAccountId(String var1);

        public Builder arn(String var1);

        public Builder email(String var1);

        public Builder invitedAt(Instant var1);

        public Builder masterAccountId(String var1);

        public Builder relationshipStatus(String var1);

        public Builder relationshipStatus(RelationshipStatus var1);

        public Builder tags(Map<String, String> var1);

        public Builder updatedAt(Instant var1);
    }
}

