/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.macie2.model.FindingPublishingFrequency;
import software.amazon.awssdk.services.macie2.model.Macie2Response;
import software.amazon.awssdk.services.macie2.model.MacieStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMacieSessionResponse
extends Macie2Response
implements ToCopyableBuilder<Builder, GetMacieSessionResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetMacieSessionResponse.getter(GetMacieSessionResponse::createdAt)).setter(GetMacieSessionResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> FINDING_PUBLISHING_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("findingPublishingFrequency").getter(GetMacieSessionResponse.getter(GetMacieSessionResponse::findingPublishingFrequencyAsString)).setter(GetMacieSessionResponse.setter(Builder::findingPublishingFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingPublishingFrequency").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceRole").getter(GetMacieSessionResponse.getter(GetMacieSessionResponse::serviceRole)).setter(GetMacieSessionResponse.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetMacieSessionResponse.getter(GetMacieSessionResponse::statusAsString)).setter(GetMacieSessionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetMacieSessionResponse.getter(GetMacieSessionResponse::updatedAt)).setter(GetMacieSessionResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, FINDING_PUBLISHING_FREQUENCY_FIELD, SERVICE_ROLE_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));
    private final Instant createdAt;
    private final String findingPublishingFrequency;
    private final String serviceRole;
    private final String status;
    private final Instant updatedAt;

    private GetMacieSessionResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.findingPublishingFrequency = builder.findingPublishingFrequency;
        this.serviceRole = builder.serviceRole;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final FindingPublishingFrequency findingPublishingFrequency() {
        return FindingPublishingFrequency.fromValue(this.findingPublishingFrequency);
    }

    public final String findingPublishingFrequencyAsString() {
        return this.findingPublishingFrequency;
    }

    public final String serviceRole() {
        return this.serviceRole;
    }

    public final MacieStatus status() {
        return MacieStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingPublishingFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMacieSessionResponse)) {
            return false;
        }
        GetMacieSessionResponse other = (GetMacieSessionResponse)((Object)obj);
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.findingPublishingFrequencyAsString(), other.findingPublishingFrequencyAsString()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetMacieSessionResponse").add("CreatedAt", (Object)this.createdAt()).add("FindingPublishingFrequency", (Object)this.findingPublishingFrequencyAsString()).add("ServiceRole", (Object)this.serviceRole()).add("Status", (Object)this.statusAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "findingPublishingFrequency": {
                return Optional.ofNullable(clazz.cast(this.findingPublishingFrequencyAsString()));
            }
            case "serviceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMacieSessionResponse, T> g) {
        return obj -> g.apply((GetMacieSessionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Macie2Response.BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String findingPublishingFrequency;
        private String serviceRole;
        private String status;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMacieSessionResponse model) {
            super(model);
            this.createdAt(model.createdAt);
            this.findingPublishingFrequency(model.findingPublishingFrequency);
            this.serviceRole(model.serviceRole);
            this.status(model.status);
            this.updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getFindingPublishingFrequency() {
            return this.findingPublishingFrequency;
        }

        public final void setFindingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
        }

        @Override
        public final Builder findingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
            return this;
        }

        @Override
        public final Builder findingPublishingFrequency(FindingPublishingFrequency findingPublishingFrequency) {
            this.findingPublishingFrequency(findingPublishingFrequency == null ? null : findingPublishingFrequency.toString());
            return this;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MacieStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetMacieSessionResponse build() {
            return new GetMacieSessionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Macie2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMacieSessionResponse> {
        public Builder createdAt(Instant var1);

        public Builder findingPublishingFrequency(String var1);

        public Builder findingPublishingFrequency(FindingPublishingFrequency var1);

        public Builder serviceRole(String var1);

        public Builder status(String var1);

        public Builder status(MacieStatus var1);

        public Builder updatedAt(Instant var1);
    }
}

