/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.macie.MacieClient;
import software.amazon.awssdk.services.macie.internal.UserAgentUtils;
import software.amazon.awssdk.services.macie.model.ListS3ResourcesRequest;
import software.amazon.awssdk.services.macie.model.ListS3ResourcesResponse;

public class ListS3ResourcesIterable
implements SdkIterable<ListS3ResourcesResponse> {
    private final MacieClient client;
    private final ListS3ResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListS3ResourcesIterable(MacieClient client, ListS3ResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListS3ResourcesResponseFetcher();
    }

    public Iterator<ListS3ResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListS3ResourcesResponseFetcher
    implements SyncPageFetcher<ListS3ResourcesResponse> {
        private ListS3ResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListS3ResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListS3ResourcesResponse nextPage(ListS3ResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListS3ResourcesIterable.this.client.listS3Resources(ListS3ResourcesIterable.this.firstRequest);
            }
            return ListS3ResourcesIterable.this.client.listS3Resources((ListS3ResourcesRequest)((Object)ListS3ResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

