/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.macie.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class S3ResourcesClassificationCopier {
    static List<S3ResourceClassification> copy(Collection<? extends S3ResourceClassification> s3ResourcesClassificationParam) {
        List<S3ResourceClassification> list;
        if (s3ResourcesClassificationParam == null || s3ResourcesClassificationParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<S3ResourceClassification> modifiableList = new ArrayList<>();
            s3ResourcesClassificationParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3ResourceClassification> copyFromBuilder(
            Collection<? extends S3ResourceClassification.Builder> s3ResourcesClassificationParam) {
        List<S3ResourceClassification> list;
        if (s3ResourcesClassificationParam == null || s3ResourcesClassificationParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<S3ResourceClassification> modifiableList = new ArrayList<>();
            s3ResourcesClassificationParam.forEach(entry -> {
                S3ResourceClassification member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<S3ResourceClassification.Builder> copyToBuilder(
            Collection<? extends S3ResourceClassification> s3ResourcesClassificationParam) {
        List<S3ResourceClassification.Builder> list;
        if (s3ResourcesClassificationParam == null || s3ResourcesClassificationParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<S3ResourceClassification.Builder> modifiableList = new ArrayList<>();
            s3ResourcesClassificationParam.forEach(entry -> {
                S3ResourceClassification.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
