/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The scheduled maintenance for a runtime engine.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PendingMaintenance implements SdkPojo, Serializable,
        ToCopyableBuilder<PendingMaintenance.Builder, PendingMaintenance> {
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("engineVersion").getter(getter(PendingMaintenance::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineVersion").build()).build();

    private static final SdkField<MaintenanceSchedule> SCHEDULE_FIELD = SdkField
            .<MaintenanceSchedule> builder(MarshallingType.SDK_POJO).memberName("schedule")
            .getter(getter(PendingMaintenance::schedule)).setter(setter(Builder::schedule))
            .constructor(MaintenanceSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_VERSION_FIELD,
            SCHEDULE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String engineVersion;

    private final MaintenanceSchedule schedule;

    private PendingMaintenance(BuilderImpl builder) {
        this.engineVersion = builder.engineVersion;
        this.schedule = builder.schedule;
    }

    /**
     * <p>
     * The specific runtime engine that the maintenance schedule applies to.
     * </p>
     * 
     * @return The specific runtime engine that the maintenance schedule applies to.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The maintenance schedule for the runtime engine version.
     * </p>
     * 
     * @return The maintenance schedule for the runtime engine version.
     */
    public final MaintenanceSchedule schedule() {
        return schedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PendingMaintenance)) {
            return false;
        }
        PendingMaintenance other = (PendingMaintenance) obj;
        return Objects.equals(engineVersion(), other.engineVersion()) && Objects.equals(schedule(), other.schedule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PendingMaintenance").add("EngineVersion", engineVersion()).add("Schedule", schedule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "engineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PendingMaintenance, T> g) {
        return obj -> g.apply((PendingMaintenance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PendingMaintenance> {
        /**
         * <p>
         * The specific runtime engine that the maintenance schedule applies to.
         * </p>
         * 
         * @param engineVersion
         *        The specific runtime engine that the maintenance schedule applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The maintenance schedule for the runtime engine version.
         * </p>
         * 
         * @param schedule
         *        The maintenance schedule for the runtime engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(MaintenanceSchedule schedule);

        /**
         * <p>
         * The maintenance schedule for the runtime engine version.
         * </p>
         * This is a convenience method that creates an instance of the {@link MaintenanceSchedule.Builder} avoiding the
         * need to create one manually via {@link MaintenanceSchedule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaintenanceSchedule.Builder#build()} is called immediately and
         * its result is passed to {@link #schedule(MaintenanceSchedule)}.
         * 
         * @param schedule
         *        a consumer that will call methods on {@link MaintenanceSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schedule(MaintenanceSchedule)
         */
        default Builder schedule(Consumer<MaintenanceSchedule.Builder> schedule) {
            return schedule(MaintenanceSchedule.builder().applyMutation(schedule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String engineVersion;

        private MaintenanceSchedule schedule;

        private BuilderImpl() {
        }

        private BuilderImpl(PendingMaintenance model) {
            engineVersion(model.engineVersion);
            schedule(model.schedule);
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final MaintenanceSchedule.Builder getSchedule() {
            return schedule != null ? schedule.toBuilder() : null;
        }

        public final void setSchedule(MaintenanceSchedule.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(MaintenanceSchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        @Override
        public PendingMaintenance build() {
            return new PendingMaintenance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
