/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies a specific batch job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobIdentifier implements SdkPojo, Serializable, ToCopyableBuilder<JobIdentifier.Builder, JobIdentifier> {
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileName").getter(getter(JobIdentifier::fileName)).setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileName").build()).build();

    private static final SdkField<String> SCRIPT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scriptName").getter(getter(JobIdentifier::scriptName)).setter(setter(Builder::scriptName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_NAME_FIELD,
            SCRIPT_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fileName;

    private final String scriptName;

    private final Type type;

    private JobIdentifier(BuilderImpl builder) {
        this.fileName = builder.fileName;
        this.scriptName = builder.scriptName;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name of the file that contains the batch job definition.
     * </p>
     * 
     * @return The name of the file that contains the batch job definition.
     */
    public final String fileName() {
        return fileName;
    }

    /**
     * <p>
     * The name of the script that contains the batch job definition.
     * </p>
     * 
     * @return The name of the script that contains the batch job definition.
     */
    public final String scriptName() {
        return scriptName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        hashCode = 31 * hashCode + Objects.hashCode(scriptName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobIdentifier)) {
            return false;
        }
        JobIdentifier other = (JobIdentifier) obj;
        return Objects.equals(fileName(), other.fileName()) && Objects.equals(scriptName(), other.scriptName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobIdentifier").add("FileName", fileName()).add("ScriptName", scriptName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        case "scriptName":
            return Optional.ofNullable(clazz.cast(scriptName()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #fileName()} initialized to the given value.
     *
     * <p>
     * The name of the file that contains the batch job definition.
     * </p>
     * 
     * @param fileName
     *        The name of the file that contains the batch job definition.
     */
    public static JobIdentifier fromFileName(String fileName) {
        return builder().fileName(fileName).build();
    }

    /**
     * Create an instance of this class with {@link #scriptName()} initialized to the given value.
     *
     * <p>
     * The name of the script that contains the batch job definition.
     * </p>
     * 
     * @param scriptName
     *        The name of the script that contains the batch job definition.
     */
    public static JobIdentifier fromScriptName(String scriptName) {
        return builder().scriptName(scriptName).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobIdentifier, T> g) {
        return obj -> g.apply((JobIdentifier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobIdentifier> {
        /**
         * <p>
         * The name of the file that contains the batch job definition.
         * </p>
         * 
         * @param fileName
         *        The name of the file that contains the batch job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);

        /**
         * <p>
         * The name of the script that contains the batch job definition.
         * </p>
         * 
         * @param scriptName
         *        The name of the script that contains the batch job definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptName(String scriptName);
    }

    static final class BuilderImpl implements Builder {
        private String fileName;

        private String scriptName;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(JobIdentifier model) {
            fileName(model.fileName);
            scriptName(model.scriptName);
        }

        public final String getFileName() {
            return fileName;
        }

        public final void setFileName(String fileName) {
            Object oldValue = this.fileName;
            this.fileName = fileName;
            handleUnionValueChange(Type.FILE_NAME, oldValue, this.fileName);
        }

        @Override
        public final Builder fileName(String fileName) {
            Object oldValue = this.fileName;
            this.fileName = fileName;
            handleUnionValueChange(Type.FILE_NAME, oldValue, this.fileName);
            return this;
        }

        public final String getScriptName() {
            return scriptName;
        }

        public final void setScriptName(String scriptName) {
            Object oldValue = this.scriptName;
            this.scriptName = scriptName;
            handleUnionValueChange(Type.SCRIPT_NAME, oldValue, this.scriptName);
        }

        @Override
        public final Builder scriptName(String scriptName) {
            Object oldValue = this.scriptName;
            this.scriptName = scriptName;
            handleUnionValueChange(Type.SCRIPT_NAME, oldValue, this.scriptName);
            return this;
        }

        @Override
        public JobIdentifier build() {
            return new JobIdentifier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see JobIdentifier#type()
     */
    public enum Type {
        FILE_NAME,

        SCRIPT_NAME,

        UNKNOWN_TO_SDK_VERSION
    }
}
