/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The length of the records in the data set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecordLength implements SdkPojo, Serializable, ToCopyableBuilder<RecordLength.Builder, RecordLength> {
    private static final SdkField<Integer> MAX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("max")
            .getter(getter(RecordLength::max)).setter(setter(Builder::max))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("max").build()).build();

    private static final SdkField<Integer> MIN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("min")
            .getter(getter(RecordLength::min)).setter(setter(Builder::min))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("min").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_FIELD, MIN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer max;

    private final Integer min;

    private RecordLength(BuilderImpl builder) {
        this.max = builder.max;
        this.min = builder.min;
    }

    /**
     * <p>
     * The maximum record length. In case of fixed, both minimum and maximum are the same.
     * </p>
     * 
     * @return The maximum record length. In case of fixed, both minimum and maximum are the same.
     */
    public final Integer max() {
        return max;
    }

    /**
     * <p>
     * The minimum record length of a record.
     * </p>
     * 
     * @return The minimum record length of a record.
     */
    public final Integer min() {
        return min;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(max());
        hashCode = 31 * hashCode + Objects.hashCode(min());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordLength)) {
            return false;
        }
        RecordLength other = (RecordLength) obj;
        return Objects.equals(max(), other.max()) && Objects.equals(min(), other.min());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecordLength").add("Max", max()).add("Min", min()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "max":
            return Optional.ofNullable(clazz.cast(max()));
        case "min":
            return Optional.ofNullable(clazz.cast(min()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecordLength, T> g) {
        return obj -> g.apply((RecordLength) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecordLength> {
        /**
         * <p>
         * The maximum record length. In case of fixed, both minimum and maximum are the same.
         * </p>
         * 
         * @param max
         *        The maximum record length. In case of fixed, both minimum and maximum are the same.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(Integer max);

        /**
         * <p>
         * The minimum record length of a record.
         * </p>
         * 
         * @param min
         *        The minimum record length of a record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder min(Integer min);
    }

    static final class BuilderImpl implements Builder {
        private Integer max;

        private Integer min;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordLength model) {
            max(model.max);
            min(model.min);
        }

        public final Integer getMax() {
            return max;
        }

        public final void setMax(Integer max) {
            this.max = max;
        }

        @Override
        public final Builder max(Integer max) {
            this.max = max;
            return this;
        }

        public final Integer getMin() {
            return min;
        }

        public final void setMin(Integer min) {
            this.min = min;
        }

        @Override
        public final Builder min(Integer min) {
            this.min = min;
            return this;
        }

        @Override
        public RecordLength build() {
            return new RecordLength(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
