/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSignedBluinsightsUrlResponse extends M2Response implements
        ToCopyableBuilder<GetSignedBluinsightsUrlResponse.Builder, GetSignedBluinsightsUrlResponse> {
    private static final SdkField<String> SIGNED_BI_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signedBiUrl").getter(getter(GetSignedBluinsightsUrlResponse::signedBiUrl))
            .setter(setter(Builder::signedBiUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signedBiUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNED_BI_URL_FIELD));

    private final String signedBiUrl;

    private GetSignedBluinsightsUrlResponse(BuilderImpl builder) {
        super(builder);
        this.signedBiUrl = builder.signedBiUrl;
    }

    /**
     * <p>
     * Single sign-on AWS Blu Insights URL.
     * </p>
     * 
     * @return Single sign-on AWS Blu Insights URL.
     */
    public final String signedBiUrl() {
        return signedBiUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(signedBiUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSignedBluinsightsUrlResponse)) {
            return false;
        }
        GetSignedBluinsightsUrlResponse other = (GetSignedBluinsightsUrlResponse) obj;
        return Objects.equals(signedBiUrl(), other.signedBiUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSignedBluinsightsUrlResponse").add("SignedBiUrl", signedBiUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "signedBiUrl":
            return Optional.ofNullable(clazz.cast(signedBiUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSignedBluinsightsUrlResponse, T> g) {
        return obj -> g.apply((GetSignedBluinsightsUrlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends M2Response.Builder, SdkPojo, CopyableBuilder<Builder, GetSignedBluinsightsUrlResponse> {
        /**
         * <p>
         * Single sign-on AWS Blu Insights URL.
         * </p>
         * 
         * @param signedBiUrl
         *        Single sign-on AWS Blu Insights URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signedBiUrl(String signedBiUrl);
    }

    static final class BuilderImpl extends M2Response.BuilderImpl implements Builder {
        private String signedBiUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSignedBluinsightsUrlResponse model) {
            super(model);
            signedBiUrl(model.signedBiUrl);
        }

        public final String getSignedBiUrl() {
            return signedBiUrl;
        }

        public final void setSignedBiUrl(String signedBiUrl) {
            this.signedBiUrl = signedBiUrl;
        }

        @Override
        public final Builder signedBiUrl(String signedBiUrl) {
            this.signedBiUrl = signedBiUrl;
            return this;
        }

        @Override
        public GetSignedBluinsightsUrlResponse build() {
            return new GetSignedBluinsightsUrlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
