/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Additional details about the data set. Different attributes correspond to different data set organizations. The
 * values are populated based on datasetOrg, storageType and backend (Blu Age or Micro Focus).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetOrgAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetOrgAttributes.Builder, DatasetOrgAttributes> {
    private static final SdkField<GdgAttributes> GDG_FIELD = SdkField.<GdgAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("gdg").getter(getter(DatasetOrgAttributes::gdg)).setter(setter(Builder::gdg))
            .constructor(GdgAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gdg").build()).build();

    private static final SdkField<PoAttributes> PO_FIELD = SdkField.<PoAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("po").getter(getter(DatasetOrgAttributes::po)).setter(setter(Builder::po))
            .constructor(PoAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("po").build()).build();

    private static final SdkField<PsAttributes> PS_FIELD = SdkField.<PsAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("ps").getter(getter(DatasetOrgAttributes::ps)).setter(setter(Builder::ps))
            .constructor(PsAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ps").build()).build();

    private static final SdkField<VsamAttributes> VSAM_FIELD = SdkField.<VsamAttributes> builder(MarshallingType.SDK_POJO)
            .memberName("vsam").getter(getter(DatasetOrgAttributes::vsam)).setter(setter(Builder::vsam))
            .constructor(VsamAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vsam").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GDG_FIELD, PO_FIELD, PS_FIELD,
            VSAM_FIELD));

    private static final long serialVersionUID = 1L;

    private final GdgAttributes gdg;

    private final PoAttributes po;

    private final PsAttributes ps;

    private final VsamAttributes vsam;

    private final Type type;

    private DatasetOrgAttributes(BuilderImpl builder) {
        this.gdg = builder.gdg;
        this.po = builder.po;
        this.ps = builder.ps;
        this.vsam = builder.vsam;
        this.type = builder.type;
    }

    /**
     * <p>
     * The generation data group of the data set.
     * </p>
     * 
     * @return The generation data group of the data set.
     */
    public final GdgAttributes gdg() {
        return gdg;
    }

    /**
     * <p>
     * The details of a PO type data set.
     * </p>
     * 
     * @return The details of a PO type data set.
     */
    public final PoAttributes po() {
        return po;
    }

    /**
     * <p>
     * The details of a PS type data set.
     * </p>
     * 
     * @return The details of a PS type data set.
     */
    public final PsAttributes ps() {
        return ps;
    }

    /**
     * <p>
     * The details of a VSAM data set.
     * </p>
     * 
     * @return The details of a VSAM data set.
     */
    public final VsamAttributes vsam() {
        return vsam;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(gdg());
        hashCode = 31 * hashCode + Objects.hashCode(po());
        hashCode = 31 * hashCode + Objects.hashCode(ps());
        hashCode = 31 * hashCode + Objects.hashCode(vsam());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetOrgAttributes)) {
            return false;
        }
        DatasetOrgAttributes other = (DatasetOrgAttributes) obj;
        return Objects.equals(gdg(), other.gdg()) && Objects.equals(po(), other.po()) && Objects.equals(ps(), other.ps())
                && Objects.equals(vsam(), other.vsam());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetOrgAttributes").add("Gdg", gdg()).add("Po", po()).add("Ps", ps()).add("Vsam", vsam())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gdg":
            return Optional.ofNullable(clazz.cast(gdg()));
        case "po":
            return Optional.ofNullable(clazz.cast(po()));
        case "ps":
            return Optional.ofNullable(clazz.cast(ps()));
        case "vsam":
            return Optional.ofNullable(clazz.cast(vsam()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #gdg()} initialized to the given value.
     *
     * <p>
     * The generation data group of the data set.
     * </p>
     * 
     * @param gdg
     *        The generation data group of the data set.
     */
    public static DatasetOrgAttributes fromGdg(GdgAttributes gdg) {
        return builder().gdg(gdg).build();
    }

    /**
     * Create an instance of this class with {@link #gdg()} initialized to the given value.
     *
     * <p>
     * The generation data group of the data set.
     * </p>
     * 
     * @param gdg
     *        The generation data group of the data set.
     */
    public static DatasetOrgAttributes fromGdg(Consumer<GdgAttributes.Builder> gdg) {
        GdgAttributes.Builder builder = GdgAttributes.builder();
        gdg.accept(builder);
        return fromGdg(builder.build());
    }

    /**
     * Create an instance of this class with {@link #po()} initialized to the given value.
     *
     * <p>
     * The details of a PO type data set.
     * </p>
     * 
     * @param po
     *        The details of a PO type data set.
     */
    public static DatasetOrgAttributes fromPo(PoAttributes po) {
        return builder().po(po).build();
    }

    /**
     * Create an instance of this class with {@link #po()} initialized to the given value.
     *
     * <p>
     * The details of a PO type data set.
     * </p>
     * 
     * @param po
     *        The details of a PO type data set.
     */
    public static DatasetOrgAttributes fromPo(Consumer<PoAttributes.Builder> po) {
        PoAttributes.Builder builder = PoAttributes.builder();
        po.accept(builder);
        return fromPo(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ps()} initialized to the given value.
     *
     * <p>
     * The details of a PS type data set.
     * </p>
     * 
     * @param ps
     *        The details of a PS type data set.
     */
    public static DatasetOrgAttributes fromPs(PsAttributes ps) {
        return builder().ps(ps).build();
    }

    /**
     * Create an instance of this class with {@link #ps()} initialized to the given value.
     *
     * <p>
     * The details of a PS type data set.
     * </p>
     * 
     * @param ps
     *        The details of a PS type data set.
     */
    public static DatasetOrgAttributes fromPs(Consumer<PsAttributes.Builder> ps) {
        PsAttributes.Builder builder = PsAttributes.builder();
        ps.accept(builder);
        return fromPs(builder.build());
    }

    /**
     * Create an instance of this class with {@link #vsam()} initialized to the given value.
     *
     * <p>
     * The details of a VSAM data set.
     * </p>
     * 
     * @param vsam
     *        The details of a VSAM data set.
     */
    public static DatasetOrgAttributes fromVsam(VsamAttributes vsam) {
        return builder().vsam(vsam).build();
    }

    /**
     * Create an instance of this class with {@link #vsam()} initialized to the given value.
     *
     * <p>
     * The details of a VSAM data set.
     * </p>
     * 
     * @param vsam
     *        The details of a VSAM data set.
     */
    public static DatasetOrgAttributes fromVsam(Consumer<VsamAttributes.Builder> vsam) {
        VsamAttributes.Builder builder = VsamAttributes.builder();
        vsam.accept(builder);
        return fromVsam(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetOrgAttributes, T> g) {
        return obj -> g.apply((DatasetOrgAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetOrgAttributes> {
        /**
         * <p>
         * The generation data group of the data set.
         * </p>
         * 
         * @param gdg
         *        The generation data group of the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gdg(GdgAttributes gdg);

        /**
         * <p>
         * The generation data group of the data set.
         * </p>
         * This is a convenience method that creates an instance of the {@link GdgAttributes.Builder} avoiding the need
         * to create one manually via {@link GdgAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GdgAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #gdg(GdgAttributes)}.
         * 
         * @param gdg
         *        a consumer that will call methods on {@link GdgAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gdg(GdgAttributes)
         */
        default Builder gdg(Consumer<GdgAttributes.Builder> gdg) {
            return gdg(GdgAttributes.builder().applyMutation(gdg).build());
        }

        /**
         * <p>
         * The details of a PO type data set.
         * </p>
         * 
         * @param po
         *        The details of a PO type data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder po(PoAttributes po);

        /**
         * <p>
         * The details of a PO type data set.
         * </p>
         * This is a convenience method that creates an instance of the {@link PoAttributes.Builder} avoiding the need
         * to create one manually via {@link PoAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PoAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #po(PoAttributes)}.
         * 
         * @param po
         *        a consumer that will call methods on {@link PoAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #po(PoAttributes)
         */
        default Builder po(Consumer<PoAttributes.Builder> po) {
            return po(PoAttributes.builder().applyMutation(po).build());
        }

        /**
         * <p>
         * The details of a PS type data set.
         * </p>
         * 
         * @param ps
         *        The details of a PS type data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ps(PsAttributes ps);

        /**
         * <p>
         * The details of a PS type data set.
         * </p>
         * This is a convenience method that creates an instance of the {@link PsAttributes.Builder} avoiding the need
         * to create one manually via {@link PsAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PsAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #ps(PsAttributes)}.
         * 
         * @param ps
         *        a consumer that will call methods on {@link PsAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ps(PsAttributes)
         */
        default Builder ps(Consumer<PsAttributes.Builder> ps) {
            return ps(PsAttributes.builder().applyMutation(ps).build());
        }

        /**
         * <p>
         * The details of a VSAM data set.
         * </p>
         * 
         * @param vsam
         *        The details of a VSAM data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vsam(VsamAttributes vsam);

        /**
         * <p>
         * The details of a VSAM data set.
         * </p>
         * This is a convenience method that creates an instance of the {@link VsamAttributes.Builder} avoiding the need
         * to create one manually via {@link VsamAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VsamAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #vsam(VsamAttributes)}.
         * 
         * @param vsam
         *        a consumer that will call methods on {@link VsamAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vsam(VsamAttributes)
         */
        default Builder vsam(Consumer<VsamAttributes.Builder> vsam) {
            return vsam(VsamAttributes.builder().applyMutation(vsam).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GdgAttributes gdg;

        private PoAttributes po;

        private PsAttributes ps;

        private VsamAttributes vsam;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetOrgAttributes model) {
            gdg(model.gdg);
            po(model.po);
            ps(model.ps);
            vsam(model.vsam);
        }

        public final GdgAttributes.Builder getGdg() {
            return gdg != null ? gdg.toBuilder() : null;
        }

        public final void setGdg(GdgAttributes.BuilderImpl gdg) {
            Object oldValue = this.gdg;
            this.gdg = gdg != null ? gdg.build() : null;
            handleUnionValueChange(Type.GDG, oldValue, this.gdg);
        }

        @Override
        public final Builder gdg(GdgAttributes gdg) {
            Object oldValue = this.gdg;
            this.gdg = gdg;
            handleUnionValueChange(Type.GDG, oldValue, this.gdg);
            return this;
        }

        public final PoAttributes.Builder getPo() {
            return po != null ? po.toBuilder() : null;
        }

        public final void setPo(PoAttributes.BuilderImpl po) {
            Object oldValue = this.po;
            this.po = po != null ? po.build() : null;
            handleUnionValueChange(Type.PO, oldValue, this.po);
        }

        @Override
        public final Builder po(PoAttributes po) {
            Object oldValue = this.po;
            this.po = po;
            handleUnionValueChange(Type.PO, oldValue, this.po);
            return this;
        }

        public final PsAttributes.Builder getPs() {
            return ps != null ? ps.toBuilder() : null;
        }

        public final void setPs(PsAttributes.BuilderImpl ps) {
            Object oldValue = this.ps;
            this.ps = ps != null ? ps.build() : null;
            handleUnionValueChange(Type.PS, oldValue, this.ps);
        }

        @Override
        public final Builder ps(PsAttributes ps) {
            Object oldValue = this.ps;
            this.ps = ps;
            handleUnionValueChange(Type.PS, oldValue, this.ps);
            return this;
        }

        public final VsamAttributes.Builder getVsam() {
            return vsam != null ? vsam.toBuilder() : null;
        }

        public final void setVsam(VsamAttributes.BuilderImpl vsam) {
            Object oldValue = this.vsam;
            this.vsam = vsam != null ? vsam.build() : null;
            handleUnionValueChange(Type.VSAM, oldValue, this.vsam);
        }

        @Override
        public final Builder vsam(VsamAttributes vsam) {
            Object oldValue = this.vsam;
            this.vsam = vsam;
            handleUnionValueChange(Type.VSAM, oldValue, this.vsam);
            return this;
        }

        @Override
        public DatasetOrgAttributes build() {
            return new DatasetOrgAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DatasetOrgAttributes#type()
     */
    public enum Type {
        GDG,

        PO,

        PS,

        VSAM,

        UNKNOWN_TO_SDK_VERSION
    }
}
