/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class DataSetImportTaskListCopier {
    static List<DataSetImportTask> copy(Collection<? extends DataSetImportTask> dataSetImportTaskListParam) {
        List<DataSetImportTask> list;
        if (dataSetImportTaskListParam == null || dataSetImportTaskListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DataSetImportTask> modifiableList = new ArrayList<>();
            dataSetImportTaskListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DataSetImportTask> copyFromBuilder(Collection<? extends DataSetImportTask.Builder> dataSetImportTaskListParam) {
        List<DataSetImportTask> list;
        if (dataSetImportTaskListParam == null || dataSetImportTaskListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DataSetImportTask> modifiableList = new ArrayList<>();
            dataSetImportTaskListParam.forEach(entry -> {
                DataSetImportTask member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<DataSetImportTask.Builder> copyToBuilder(Collection<? extends DataSetImportTask> dataSetImportTaskListParam) {
        List<DataSetImportTask.Builder> list;
        if (dataSetImportTaskListParam == null || dataSetImportTaskListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<DataSetImportTask.Builder> modifiableList = new ArrayList<>();
            dataSetImportTaskListParam.forEach(entry -> {
                DataSetImportTask.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
