/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.m2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the storage configuration for a runtime environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StorageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<StorageConfiguration.Builder, StorageConfiguration> {
    private static final SdkField<EfsStorageConfiguration> EFS_FIELD = SdkField
            .<EfsStorageConfiguration> builder(MarshallingType.SDK_POJO).memberName("efs")
            .getter(getter(StorageConfiguration::efs)).setter(setter(Builder::efs)).constructor(EfsStorageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("efs").build()).build();

    private static final SdkField<FsxStorageConfiguration> FSX_FIELD = SdkField
            .<FsxStorageConfiguration> builder(MarshallingType.SDK_POJO).memberName("fsx")
            .getter(getter(StorageConfiguration::fsx)).setter(setter(Builder::fsx)).constructor(FsxStorageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fsx").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFS_FIELD, FSX_FIELD));

    private static final long serialVersionUID = 1L;

    private final EfsStorageConfiguration efs;

    private final FsxStorageConfiguration fsx;

    private final Type type;

    private StorageConfiguration(BuilderImpl builder) {
        this.efs = builder.efs;
        this.fsx = builder.fsx;
        this.type = builder.type;
    }

    /**
     * <p>
     * Defines the storage configuration for an Amazon EFS file system.
     * </p>
     * 
     * @return Defines the storage configuration for an Amazon EFS file system.
     */
    public final EfsStorageConfiguration efs() {
        return efs;
    }

    /**
     * <p>
     * Defines the storage configuration for an Amazon FSx file system.
     * </p>
     * 
     * @return Defines the storage configuration for an Amazon FSx file system.
     */
    public final FsxStorageConfiguration fsx() {
        return fsx;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(efs());
        hashCode = 31 * hashCode + Objects.hashCode(fsx());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageConfiguration)) {
            return false;
        }
        StorageConfiguration other = (StorageConfiguration) obj;
        return Objects.equals(efs(), other.efs()) && Objects.equals(fsx(), other.fsx());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StorageConfiguration").add("Efs", efs()).add("Fsx", fsx()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "efs":
            return Optional.ofNullable(clazz.cast(efs()));
        case "fsx":
            return Optional.ofNullable(clazz.cast(fsx()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #efs()} initialized to the given value.
     *
     * <p>
     * Defines the storage configuration for an Amazon EFS file system.
     * </p>
     * 
     * @param efs
     *        Defines the storage configuration for an Amazon EFS file system.
     */
    public static StorageConfiguration fromEfs(EfsStorageConfiguration efs) {
        return builder().efs(efs).build();
    }

    /**
     * Create an instance of this class with {@link #efs()} initialized to the given value.
     *
     * <p>
     * Defines the storage configuration for an Amazon EFS file system.
     * </p>
     * 
     * @param efs
     *        Defines the storage configuration for an Amazon EFS file system.
     */
    public static StorageConfiguration fromEfs(Consumer<EfsStorageConfiguration.Builder> efs) {
        EfsStorageConfiguration.Builder builder = EfsStorageConfiguration.builder();
        efs.accept(builder);
        return fromEfs(builder.build());
    }

    /**
     * Create an instance of this class with {@link #fsx()} initialized to the given value.
     *
     * <p>
     * Defines the storage configuration for an Amazon FSx file system.
     * </p>
     * 
     * @param fsx
     *        Defines the storage configuration for an Amazon FSx file system.
     */
    public static StorageConfiguration fromFsx(FsxStorageConfiguration fsx) {
        return builder().fsx(fsx).build();
    }

    /**
     * Create an instance of this class with {@link #fsx()} initialized to the given value.
     *
     * <p>
     * Defines the storage configuration for an Amazon FSx file system.
     * </p>
     * 
     * @param fsx
     *        Defines the storage configuration for an Amazon FSx file system.
     */
    public static StorageConfiguration fromFsx(Consumer<FsxStorageConfiguration.Builder> fsx) {
        FsxStorageConfiguration.Builder builder = FsxStorageConfiguration.builder();
        fsx.accept(builder);
        return fromFsx(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StorageConfiguration, T> g) {
        return obj -> g.apply((StorageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StorageConfiguration> {
        /**
         * <p>
         * Defines the storage configuration for an Amazon EFS file system.
         * </p>
         * 
         * @param efs
         *        Defines the storage configuration for an Amazon EFS file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder efs(EfsStorageConfiguration efs);

        /**
         * <p>
         * Defines the storage configuration for an Amazon EFS file system.
         * </p>
         * This is a convenience method that creates an instance of the {@link EfsStorageConfiguration.Builder} avoiding
         * the need to create one manually via {@link EfsStorageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EfsStorageConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #efs(EfsStorageConfiguration)}.
         * 
         * @param efs
         *        a consumer that will call methods on {@link EfsStorageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #efs(EfsStorageConfiguration)
         */
        default Builder efs(Consumer<EfsStorageConfiguration.Builder> efs) {
            return efs(EfsStorageConfiguration.builder().applyMutation(efs).build());
        }

        /**
         * <p>
         * Defines the storage configuration for an Amazon FSx file system.
         * </p>
         * 
         * @param fsx
         *        Defines the storage configuration for an Amazon FSx file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fsx(FsxStorageConfiguration fsx);

        /**
         * <p>
         * Defines the storage configuration for an Amazon FSx file system.
         * </p>
         * This is a convenience method that creates an instance of the {@link FsxStorageConfiguration.Builder} avoiding
         * the need to create one manually via {@link FsxStorageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FsxStorageConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #fsx(FsxStorageConfiguration)}.
         * 
         * @param fsx
         *        a consumer that will call methods on {@link FsxStorageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fsx(FsxStorageConfiguration)
         */
        default Builder fsx(Consumer<FsxStorageConfiguration.Builder> fsx) {
            return fsx(FsxStorageConfiguration.builder().applyMutation(fsx).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EfsStorageConfiguration efs;

        private FsxStorageConfiguration fsx;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(StorageConfiguration model) {
            efs(model.efs);
            fsx(model.fsx);
        }

        public final EfsStorageConfiguration.Builder getEfs() {
            return efs != null ? efs.toBuilder() : null;
        }

        public final void setEfs(EfsStorageConfiguration.BuilderImpl efs) {
            Object oldValue = this.efs;
            this.efs = efs != null ? efs.build() : null;
            handleUnionValueChange(Type.EFS, oldValue, this.efs);
        }

        @Override
        public final Builder efs(EfsStorageConfiguration efs) {
            Object oldValue = this.efs;
            this.efs = efs;
            handleUnionValueChange(Type.EFS, oldValue, this.efs);
            return this;
        }

        public final FsxStorageConfiguration.Builder getFsx() {
            return fsx != null ? fsx.toBuilder() : null;
        }

        public final void setFsx(FsxStorageConfiguration.BuilderImpl fsx) {
            Object oldValue = this.fsx;
            this.fsx = fsx != null ? fsx.build() : null;
            handleUnionValueChange(Type.FSX, oldValue, this.fsx);
        }

        @Override
        public final Builder fsx(FsxStorageConfiguration fsx) {
            Object oldValue = this.fsx;
            this.fsx = fsx;
            handleUnionValueChange(Type.FSX, oldValue, this.fsx);
            return this;
        }

        @Override
        public StorageConfiguration build() {
            return new StorageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see StorageConfiguration#type()
     */
    public enum Type {
        EFS,

        FSX,

        UNKNOWN_TO_SDK_VERSION
    }
}
