/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the column used to track time in a source data file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimestampColumn implements SdkPojo, Serializable, ToCopyableBuilder<TimestampColumn.Builder, TimestampColumn> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnName").getter(getter(TimestampColumn::columnName)).setter(setter(Builder::columnName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()).build();

    private static final SdkField<String> COLUMN_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnFormat").getter(getter(TimestampColumn::columnFormat)).setter(setter(Builder::columnFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD,
            COLUMN_FORMAT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String columnName;

    private final String columnFormat;

    private TimestampColumn(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.columnFormat = builder.columnFormat;
    }

    /**
     * <p>
     * The name of the timestamp column.
     * </p>
     * 
     * @return The name of the timestamp column.
     */
    public final String columnName() {
        return columnName;
    }

    /**
     * <p>
     * The format of the timestamp column.
     * </p>
     * 
     * @return The format of the timestamp column.
     */
    public final String columnFormat() {
        return columnFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnName());
        hashCode = 31 * hashCode + Objects.hashCode(columnFormat());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimestampColumn)) {
            return false;
        }
        TimestampColumn other = (TimestampColumn) obj;
        return Objects.equals(columnName(), other.columnName()) && Objects.equals(columnFormat(), other.columnFormat());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimestampColumn").add("ColumnName", columnName()).add("ColumnFormat", columnFormat()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnName":
            return Optional.ofNullable(clazz.cast(columnName()));
        case "ColumnFormat":
            return Optional.ofNullable(clazz.cast(columnFormat()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimestampColumn, T> g) {
        return obj -> g.apply((TimestampColumn) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimestampColumn> {
        /**
         * <p>
         * The name of the timestamp column.
         * </p>
         * 
         * @param columnName
         *        The name of the timestamp column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnName(String columnName);

        /**
         * <p>
         * The format of the timestamp column.
         * </p>
         * 
         * @param columnFormat
         *        The format of the timestamp column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnFormat(String columnFormat);
    }

    static final class BuilderImpl implements Builder {
        private String columnName;

        private String columnFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(TimestampColumn model) {
            columnName(model.columnName);
            columnFormat(model.columnFormat);
        }

        public final String getColumnName() {
            return columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final String getColumnFormat() {
            return columnFormat;
        }

        public final void setColumnFormat(String columnFormat) {
            this.columnFormat = columnFormat;
        }

        @Override
        public final Builder columnFormat(String columnFormat) {
            this.columnFormat = columnFormat;
            return this;
        }

        @Override
        public TimestampColumn build() {
            return new TimestampColumn(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
